/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.model;

import ch.raffael.meldioc.Configuration;
import ch.raffael.meldioc.ExtensionPoint;
import ch.raffael.meldioc.Feature;
import ch.raffael.meldioc.Parameter;
import ch.raffael.meldioc.Provision;
import ch.raffael.meldioc.Setup;
import ch.raffael.meldioc.model.AccessPolicy;
import ch.raffael.meldioc.model.Adaptor;
import ch.raffael.meldioc.model.InconsistentModelException;
import ch.raffael.meldioc.model.SrcElement_Immutable;
import ch.raffael.meldioc.model.SrcElement_With;
import ch.raffael.meldioc.model.config.ConfigurationConfig;
import ch.raffael.meldioc.model.config.ElementConfig;
import ch.raffael.meldioc.model.config.ExtensionPointConfig;
import ch.raffael.meldioc.model.config.FeatureConfig;
import ch.raffael.meldioc.model.config.MountConfig;
import ch.raffael.meldioc.model.config.ParameterConfig;
import ch.raffael.meldioc.model.config.ParameterPrefixConfig;
import ch.raffael.meldioc.model.config.ProvisionConfig;
import ch.raffael.meldioc.model.config.SetupConfig;
import ch.raffael.meldioc.util.immutables.Immutable;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.collection.Seq;
import io.vavr.collection.Set;
import io.vavr.control.Option;
import java.lang.annotation.Annotation;
import org.immutables.value.Value;
import org.jetbrains.annotations.Nullable;

@Immutable.Pure
public abstract class SrcElement<S, T>
implements SrcElement_With<S, T> {
    public static final String CONSTRUCTOR_NAME = "<init>";
    private static final Object PSEUDO_SOURCE = new Object();

    SrcElement() {
    }

    public static <S, T> Builder<S, T> builder() {
        return new Builder();
    }

    public abstract Kind kind();

    public abstract String name();

    public abstract T type();

    public abstract S source();

    public SrcElement<S, T> parent() {
        return (SrcElement)this.parentOption().getOrElseThrow(() -> new InconsistentModelException("Element " + String.valueOf(this) + " has no parent", this));
    }

    public boolean synthetic() {
        return this.synthesized();
    }

    public SrcElement<S, T> withSynthetic(boolean synthetic) {
        return this.withSynthesized(synthetic);
    }

    @Value.Default
    boolean synthesized() {
        return false;
    }

    public abstract Option<SrcElement<S, T>> parentOption();

    @Value.Redacted
    public abstract AccessPolicy accessPolicy();

    @Value.Redacted
    public abstract boolean isStatic();

    @Value.Redacted
    public abstract boolean isFinal();

    @Value.Redacted
    public abstract boolean isSealed();

    @Value.Redacted
    public abstract boolean isAbstract();

    public boolean isOverridable() {
        return !this.isFinal() && !this.isStatic() && this.accessPolicy() != AccessPolicy.PRIVATE;
    }

    @Value.Redacted
    abstract Seq<SrcElement<S, T>> parameters();

    @Value.Redacted
    abstract Seq<T> exceptions();

    @Value.Redacted
    public abstract Set<ElementConfig<S>> configs();

    public Option<SrcElement<S, T>> findClass() {
        Option<SrcElement<S, T>> e = Option.some((Object)this);
        while (e.isDefined() && ((SrcElement)e.get()).kind() != Kind.CLASS) {
            e = ((SrcElement)e.get()).parentOption();
        }
        return e;
    }

    public SrcElement<S, T> findOutermost() {
        SrcElement<S, T> p = this;
        while (p.parentOption().isDefined()) {
            p = p.parent();
        }
        return p;
    }

    public boolean accessibleTo(Adaptor<S, T> adaptor, SrcElement<S, T> that) {
        return this.accessibleTo(adaptor, that, false);
    }

    public boolean accessibleToByExtension(Adaptor<S, T> adaptor, SrcElement<S, T> that) {
        return this.accessibleTo(adaptor, that, true);
    }

    public boolean accessibleTo(Adaptor<S, T> adaptor, SrcElement<S, T> that, boolean byExtension) {
        if (this.kind() == Kind.PARAMETER || that.kind() == Kind.PARAMETER) {
            return false;
        }
        if (this.accessPolicy() == AccessPolicy.PUBLIC) {
            return true;
        }
        SrcElement thisClass = (SrcElement)this.findClass().getOrNull();
        if (thisClass == null) {
            return false;
        }
        SrcElement thatClass = (SrcElement)that.findClass().getOrNull();
        if (thatClass == null) {
            return false;
        }
        if (thisClass.equals(thatClass)) {
            return true;
        }
        if (byExtension && this.accessPolicy() == AccessPolicy.PROTECTED) {
            return true;
        }
        if ((this.accessPolicy() == AccessPolicy.LOCAL || this.accessPolicy() == AccessPolicy.PROTECTED) && adaptor.packageOf(thisClass).equals(adaptor.packageOf(thatClass))) {
            return true;
        }
        if (this.accessPolicy() == AccessPolicy.PROTECTED) {
            return adaptor.isSubtypeOf(thatClass.type(), thisClass.type());
        }
        return false;
    }

    public boolean canOverride(SrcElement<S, T> that, Adaptor<S, T> adaptor) {
        if (this.kind() != Kind.METHOD || that.kind() != Kind.METHOD) {
            return false;
        }
        if (!this.methodSignature().equals(that.methodSignature())) {
            return false;
        }
        return adaptor.isSubtypeOf(this.type(), that.type());
    }

    @Value.Lazy
    public Tuple2<String, Seq<SrcElement<?, T>>> methodSignature() {
        return Tuple.of((Object)this.name(), (Object)this.parameters().zipWithIndex().map(tpl -> tpl.map1(p -> p.withoutSource().withName("arg" + String.valueOf(tpl._2)))).map(Tuple2::_1));
    }

    public SrcElement<?, T> withoutSource() {
        return this.withSource(PSEUDO_SOURCE);
    }

    public <ES extends S> ES source(Class<ES> type) throws InconsistentModelException {
        try {
            return type.cast(this.source());
        }
        catch (ClassCastException e) {
            throw new InconsistentModelException("Source of type " + type.getName() + " expected", this, e);
        }
    }

    public <ET extends T> ET type(Class<ET> type) throws InconsistentModelException {
        try {
            return type.cast(this.type());
        }
        catch (ClassCastException e) {
            throw new InconsistentModelException("Type reference of type " + type.getName() + " expected", this, e);
        }
    }

    public boolean isInnerClass() {
        if (this.kind() != Kind.CLASS) {
            return false;
        }
        SrcElement<S, T> c = this;
        while (c.parentOption().isDefined()) {
            if (c.parent().kind() != Kind.CLASS) {
                return true;
            }
            if (!c.isStatic()) {
                return true;
            }
            c = c.parent();
        }
        return false;
    }

    public SrcElement<S, T> narrow(Kind kind) {
        if (this.kind() != kind) {
            throw new InconsistentModelException("Expected kind " + String.valueOf((Object)kind) + ", actual kind is " + String.valueOf((Object)this.kind()), this);
        }
        return this;
    }

    public <ES extends S, ET extends T> SrcElement<ES, ET> narrow(@Nullable Class<ES> sourceType, @Nullable Class<ET> typeType) {
        return this.narrow(null, sourceType, typeType);
    }

    public <ES extends S, ET extends T> SrcElement<ES, ET> narrow(@Nullable Kind kind, @Nullable Class<ES> sourceType, @Nullable Class<ET> typeType) {
        if (kind != null && this.kind() != kind) {
            throw new InconsistentModelException("Expected kind " + String.valueOf((Object)kind) + ", actual kind is " + String.valueOf((Object)this.kind()), this);
        }
        if (sourceType != null) {
            this.source(sourceType);
        }
        if (typeType != null) {
            this.type(typeType);
        }
        return this;
    }

    public SrcElement<Option.None<Void>, Option.None<Void>> detach() {
        return SrcElement.builder().from(this).source(SrcElement.voidNone()).type(SrcElement.voidNone()).parentOption(this.parentOption().map(SrcElement::detach)).parameters(this.parameters().map(SrcElement::detach)).build();
    }

    public ConfigurationConfig<S> configurationConfig() {
        return this.requireConfig(this.configurationConfigOption(), Configuration.class);
    }

    public Option<ConfigurationConfig<S>> configurationConfigOption() {
        return this.configs().find(ConfigurationConfig.class::isInstance).map(ConfigurationConfig.class::cast);
    }

    public SetupConfig<S> setupConfig() {
        return this.requireConfig(this.setupConfigOption(), Setup.class);
    }

    public Option<SetupConfig<S>> setupConfigOption() {
        return this.configs().find(SetupConfig.class::isInstance).map(SetupConfig.class::cast);
    }

    public ParameterConfig<S> parameterConfig() {
        return this.requireConfig(this.parameterConfigOption(), Parameter.class);
    }

    public Option<ParameterConfig<S>> parameterConfigOption() {
        return this.configs().find(ParameterConfig.class::isInstance).map(ParameterConfig.class::cast);
    }

    public ParameterPrefixConfig<S> parameterPrefixConfig() {
        return this.requireConfig(this.parameterPrefixConfigOption(), Parameter.Prefix.class);
    }

    public Option<ParameterPrefixConfig<S>> parameterPrefixConfigOption() {
        return this.configs().find(ParameterPrefixConfig.class::isInstance).map(ParameterPrefixConfig.class::cast);
    }

    public ExtensionPointConfig<S> extensionPointConfig() {
        return this.requireConfig(this.extensionPointConfigOption(), ExtensionPoint.class);
    }

    public Option<ExtensionPointConfig<S>> extensionPointConfigOption() {
        return this.configs().find(ExtensionPointConfig.class::isInstance).map(ExtensionPointConfig.class::cast);
    }

    public FeatureConfig<S> featureConfig() {
        return this.requireConfig(this.featureConfigOption(), Feature.class);
    }

    public Option<FeatureConfig<S>> featureConfigOption() {
        return this.configs().find(FeatureConfig.class::isInstance).map(FeatureConfig.class::cast);
    }

    public MountConfig<S> mountConfig() {
        return this.requireConfig(this.mountConfigOption(), Feature.Mount.class);
    }

    public Option<MountConfig<S>> mountConfigOption() {
        return this.configs().find(MountConfig.class::isInstance).map(MountConfig.class::cast);
    }

    public ProvisionConfig<S> provisionConfig() {
        return this.requireConfig(this.provisionConfigOption(), Provision.class);
    }

    public Option<ProvisionConfig<S>> provisionConfigOption() {
        return this.configs().find(ProvisionConfig.class::isInstance).map(ProvisionConfig.class::cast);
    }

    private <C> C requireConfig(Option<C> option, Class<? extends Annotation> type) {
        return (C)option.getOrElseThrow(() -> new InconsistentModelException("Expected configuration of type @" + type.getName() + "not present", this));
    }

    @Value.Check
    void verify() {
        this.kind().verify(this);
    }

    private static Option.None<Void> voidNone() {
        return (Option.None)Option.none();
    }

    public static final class Builder<S, T>
    extends SrcElement_Immutable.Builder<S, T> {
        Builder() {
        }

        public Builder<S, T> synthetic(boolean synthetic) {
            return this.synthesized(synthetic);
        }

        public Builder<S, T> parent(Option<SrcElement<S, T>> parent) {
            return this.parentOption((Option)parent);
        }

        public Builder<S, T> parent(SrcElement<S, T> parent) {
            return this.parentOption((SrcElement)parent);
        }
    }

    public static enum Kind {
        CLASS{

            @Override
            public void verify(SrcElement<?, ?> element) {
                super.verify(element);
                1.verifyOptionalParent(element, CLASS);
                1.verifyNoParameters(element);
            }
        }
        ,
        METHOD{

            @Override
            public void verify(SrcElement<?, ?> element) {
                super.verify(element);
                2.verifyParent(element, CLASS);
            }
        }
        ,
        PARAMETER{

            @Override
            public void verify(SrcElement<?, ?> element) {
                super.verify(element);
                3.verifyNoParameters(element);
                if (element.parentOption().isDefined()) {
                    throw new InconsistentModelException("Method parameters must not have a parent", element);
                }
            }
        };


        void verify(SrcElement<?, ?> element) {
            element.narrow(this);
        }

        static void verifyNoParameters(SrcElement<?, ?> element) {
            if (!element.parameters().isEmpty()) {
                throw new InconsistentModelException("Elements of kind " + String.valueOf((Object)element.kind()) + " cannot have parameters", element);
            }
        }

        static void verifyOptionalParent(SrcElement<?, ?> element, Kind kind) {
            element.parentOption().forEach(p -> {
                if (p.kind() != kind) {
                    throw new InconsistentModelException("Parent of kind " + String.valueOf((Object)p.kind()) + " must be a " + String.valueOf((Object)kind), element);
                }
            });
        }

        static void verifyParent(SrcElement<?, ?> element, Kind kind) {
            if (element.parentOption().isEmpty()) {
                throw new InconsistentModelException("Elements of kind " + String.valueOf((Object)element.kind()) + " must have a parent", element);
            }
            Kind.verifyOptionalParent(element, kind);
        }
    }
}

