/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.model.config;

import ch.raffael.meldioc.model.ClassRef;
import ch.raffael.meldioc.model.config.AnnotationAttribute_Immutable;
import ch.raffael.meldioc.model.config.AnnotationAttribute_With;
import ch.raffael.meldioc.util.immutables.Immutable;
import io.vavr.collection.LinkedHashMap;
import io.vavr.collection.Map;
import io.vavr.control.Option;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.stream.Stream;

@Immutable.Pure
public abstract class AnnotationAttribute
implements AnnotationAttribute_With {
    AnnotationAttribute() {
    }

    public static Builder builder() {
        return new Builder();
    }

    static Map<String, AnnotationAttribute> allOf(Class<? extends Annotation> type) {
        return (Map)Stream.of(type.getDeclaredMethods()).filter(m -> !m.isSynthetic()).filter(m -> !Modifier.isStatic(m.getModifiers())).map(AnnotationAttribute::of).collect(LinkedHashMap.collector(AnnotationAttribute::name));
    }

    static AnnotationAttribute of(Method method) {
        Object def;
        Class<Object> type;
        boolean isArray = method.getReturnType().isArray();
        Class<?> clazz = type = isArray ? method.getReturnType().getComponentType() : method.getReturnType();
        if (Class.class.isAssignableFrom(type)) {
            type = ClassRef.class;
        }
        if ((def = method.getDefaultValue()) instanceof Class) {
            def = ClassRef.of((Class)def);
        }
        return AnnotationAttribute_Immutable.builder().name(method.getName()).valueType(isArray ? Array.newInstance(type, 0).getClass() : type).defaultValue(Option.of((Object)def)).build();
    }

    public abstract String name();

    public abstract Class<?> valueType();

    public abstract Option<Object> defaultValue();

    public static final class Builder
    extends AnnotationAttribute_Immutable.Builder {
        Builder() {
        }
    }
}

