/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.model.config;

import ch.raffael.meldioc.Configuration;
import ch.raffael.meldioc.ExtensionPoint;
import ch.raffael.meldioc.Feature;
import ch.raffael.meldioc.Parameter;
import ch.raffael.meldioc.Provision;
import ch.raffael.meldioc.Setup;
import ch.raffael.meldioc.model.config.AnnotationAttribute;
import ch.raffael.meldioc.model.config.ModelAnnotationType_Immutable;
import ch.raffael.meldioc.model.config.ModelAnnotationType_With;
import ch.raffael.meldioc.util.immutables.IllegalBuilderStateException;
import ch.raffael.meldioc.util.immutables.Immutable;
import io.vavr.Lazy;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.collection.LinkedHashSet;
import io.vavr.collection.List;
import io.vavr.collection.Map;
import io.vavr.collection.Set;
import java.lang.annotation.Annotation;
import java.util.function.Consumer;
import org.immutables.value.Value;

@Immutable.Pure
public abstract class ModelAnnotationType
implements ModelAnnotationType_With {
    private static final Lazy<Map<Class<? extends Annotation>, ModelAnnotationType>> ALL_MAP = Lazy.of(() -> List.of((Object[])new Tuple2[]{ModelAnnotationType.mapEntry(Provision.class, b -> b.onMethod().willImplement().willDecorate()), ModelAnnotationType.mapEntry(ExtensionPoint.class, b -> b.onClass().onMethod().willDecorate().auxiliaryRole()), ModelAnnotationType.mapEntry(Parameter.class, b -> b.onMethod().willImplement().willDecorate()), ModelAnnotationType.mapEntry(Parameter.Prefix.class, b -> b.onClass().modifier()), ModelAnnotationType.mapEntry(Setup.class, b -> b.onMethod().supportsParameters()), ModelAnnotationType.mapEntry(Feature.Mount.class, b -> b.onMethod().willImplement()), ModelAnnotationType.mapEntry(Feature.class, b -> b.onClass().featureRole().willImplement().willDecorate()), ModelAnnotationType.mapEntry(Configuration.class, b -> b.onClass().featureRole().willImplement().willDecorate()), ModelAnnotationType.mapEntry(Feature.DependsOn.class, b -> b.modifier().onImplements())}).toMap(t -> t));
    private static final Lazy<Set<ModelAnnotationType>> ALL = Lazy.of(() -> LinkedHashSet.ofAll((Iterable)((Map)ALL_MAP.get()).values()));

    private static <T extends Annotation> Tuple2<Class<T>, ModelAnnotationType> mapEntry(Class<T> annotationType, Consumer<? super Builder> conf) {
        Builder builder = ModelAnnotationType.builder().annotationType(annotationType);
        conf.accept(builder);
        return Tuple.of(annotationType, (Object)builder.build());
    }

    ModelAnnotationType() {
    }

    static Builder builder() {
        return new Builder();
    }

    public static Set<ModelAnnotationType> all() {
        return (Set)ALL.get();
    }

    public static <A extends Annotation> ModelAnnotationType of(Class<A> annotationType) {
        return (ModelAnnotationType)((Map)ALL_MAP.get()).get(annotationType).getOrElseThrow(() -> new IllegalArgumentException("Not a model annotation type: " + String.valueOf(annotationType)));
    }

    public abstract Class<? extends Annotation> annotationType();

    @Value.Lazy
    @Value.Auxiliary
    public Map<String, AnnotationAttribute> attributes() {
        return AnnotationAttribute.allOf(this.annotationType());
    }

    @Value.Derived
    @Value.Auxiliary
    public String displayName() {
        return "@" + this.annotationType().getSimpleName();
    }

    @Value.Default
    public boolean role() {
        return true;
    }

    public boolean modifier() {
        return !this.role();
    }

    @Value.Default
    public boolean auxiliaryRole() {
        return false;
    }

    @Value.Default
    public boolean featureRole() {
        return false;
    }

    @Value.Default
    public boolean onMethod() {
        return false;
    }

    @Value.Default
    public boolean onClass() {
        return false;
    }

    @Value.Default
    public boolean onInterface() {
        return this.onClass();
    }

    @Value.Default
    public boolean onImplements() {
        return false;
    }

    @Value.Default
    public boolean supportsParameters() {
        return false;
    }

    @Value.Default
    public boolean willDecorate() {
        return false;
    }

    @Value.Default
    public boolean willImplement() {
        return false;
    }

    @Value.Check
    void check() {
        if (this.featureRole() && !this.role()) {
            throw new IllegalBuilderStateException("featureRole but not role");
        }
        if (this.auxiliaryRole() && !this.role()) {
            throw new IllegalBuilderStateException("auxiliary role but not role");
        }
    }

    static final class Builder
    extends ModelAnnotationType_Immutable.Builder {
        Builder() {
        }

        Builder modifier() {
            return this.role(false);
        }

        Builder auxiliaryRole() {
            return this.auxiliaryRole(true);
        }

        Builder featureRole() {
            return this.featureRole(true);
        }

        Builder onMethod() {
            return this.onMethod(true);
        }

        Builder onClass() {
            return this.onClass(true);
        }

        Builder onInterface() {
            return this.onInterface(true);
        }

        Builder onImplements() {
            return this.onImplements(true);
        }

        Builder supportsParameters() {
            return this.supportsParameters(true);
        }

        Builder willDecorate() {
            return this.willDecorate(true);
        }

        Builder willImplement() {
            return this.willImplement(true);
        }
    }
}

