/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.model.config;

import ch.raffael.meldioc.Parameter;
import ch.raffael.meldioc.model.SrcElement;
import ch.raffael.meldioc.model.config.ElementConfig;
import ch.raffael.meldioc.model.config.ModelAnnotationType;
import ch.raffael.meldioc.model.config.ParameterConfig_Immutable;
import ch.raffael.meldioc.model.config.ParameterConfig_With;
import ch.raffael.meldioc.util.Strings;
import ch.raffael.meldioc.util.immutables.Immutable;
import io.vavr.collection.HashMap;
import io.vavr.collection.Map;
import io.vavr.control.Option;
import java.util.function.Function;

@Immutable.Pure
public abstract class ParameterConfig<S>
extends ElementConfig<S>
implements ParameterConfig_With<S> {
    public static final ModelAnnotationType TYPE = ModelAnnotationType.of(Parameter.class);
    public static final String VALUE = "value";
    public static final String ABSOLUTE = "absolute";

    ParameterConfig() {
    }

    public static <S> Builder<S> builder() {
        return new Builder();
    }

    public static ParameterConfig<Parameter> of(Parameter annotation) {
        return ParameterConfig.builder().source(annotation).value(annotation.value()).absolute(annotation.absolute()).build();
    }

    public abstract String value();

    public abstract boolean absolute();

    @Override
    public final ModelAnnotationType type() {
        return TYPE;
    }

    @Override
    public Map<String, Object> valueMap() {
        return HashMap.of((Object)VALUE, (Object)this.value(), (Object)ABSOLUTE, (Object)this.absolute());
    }

    @Override
    public String displayName() {
        return this.type().displayName() + (String)(this.value().isEmpty() ? "" : "(value=\"" + this.value() + "\")");
    }

    public Option<String> path() {
        return Option.when((!this.value().isEmpty() ? 1 : 0) != 0, this::value);
    }

    public String fullPath(SrcElement<?, ?> element) {
        if (this.value().equals("*")) {
            return "*";
        }
        String name = (String)this.path().getOrElse(() -> Strings.camelCaseWords((String)element.name()).map(String::toLowerCase).mkString((CharSequence)"-"));
        if (this.absolute()) {
            return name;
        }
        Option enclosing = Option.some(element);
        while (enclosing.isDefined() && ((SrcElement)enclosing.get()).kind() != SrcElement.Kind.CLASS) {
            enclosing = enclosing.flatMap(SrcElement::parentOption);
        }
        return (String)enclosing.map(e -> e.parameterPrefixConfigOption().map(p -> p.value() + "." + name)).flatMap(Function.identity()).getOrElse((Object)name);
    }

    public static final class Builder<S>
    extends ParameterConfig_Immutable.Builder<S> {
        Builder() {
        }
    }
}

