/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.model.messages;

import ch.raffael.meldioc.Configuration;
import ch.raffael.meldioc.ExtensionPoint;
import ch.raffael.meldioc.Feature;
import ch.raffael.meldioc.model.SrcElement;
import ch.raffael.meldioc.model.messages.SimpleMessage;
import ch.raffael.meldioc.util.Strings;
import io.vavr.Value;
import io.vavr.collection.HashMap;
import io.vavr.collection.List;
import io.vavr.collection.Map;
import io.vavr.collection.Seq;
import io.vavr.control.Option;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public interface Message<S, T> {
    public static final Map<String, Function<? super SrcElement<?, ?>, Option<String>>> RENDER_ATTRIBUTE_EXTRACTORS = HashMap.of((Object)"name", e -> Option.some((Object)e.name()), (Object)"className", e -> e.findClass().map(SrcElement::name), (Object)"kind", e -> Option.some((Object)e.kind().name().toLowerCase()), (Object)"Kind", e -> Option.some((Object)Strings.capitalize((CharSequence)e.kind().name().toLowerCase())));
    public static final Pattern RENDER_SUBSTITUTION_RE = Pattern.compile("\\{(?<idx>\\d+)(?<iter>\\+)?(:(?<attr>\\w+))?}");

    public Option<Id> id();

    default public boolean isId(Id id) {
        return this.id().getOrNull() == id;
    }

    public SrcElement<S, T> element();

    public Seq<Message<S, T>> origins();

    public String message();

    public Seq<SrcElement<S, T>> conflicts();

    public boolean languageError();

    default public String renderMessage(Function<? super S, ? extends CharSequence> elementRenderer) {
        return Message.defaultRenderMessage(this, elementRenderer);
    }

    public static <S, T> SimpleMessage<S, T> conflictingCompositionRoles(SrcElement<S, T> element, Seq<SrcElement<S, T>> conflicts) {
        return SimpleMessage.of(Id.ConflictingCompositionRoles, element, "Conflicting composition roles", conflicts);
    }

    public static <S, T> SimpleMessage<S, T> conflictingOverride(SrcElement<S, T> element, Seq<SrcElement<S, T>> conflicts) {
        return SimpleMessage.of(Id.ConflictingOverride, element, "Composition roles in conflict with inherited roles", conflicts);
    }

    public static <S, T> SimpleMessage<S, T> objectOverride(SrcElement<S, T> element) {
        return SimpleMessage.of(Id.ObjectOverride, element, "Standard Object methods cannot be used for composition");
    }

    public static <S, T> SimpleMessage<S, T> typeNotExtendable(SrcElement<S, T> element, SrcElement<S, T> type) {
        String why = "not extendable";
        if (type.isFinal()) {
            why = "final";
        } else if (type.isSealed()) {
            why = "sealed";
        }
        return SimpleMessage.of(Id.TypeNotExtendable, element, "Type {1:name} is " + why, type);
    }

    public static <S, T> SimpleMessage<S, T> illegalFeatureClass(SrcElement<S, T> element) {
        return SimpleMessage.of(Id.IllegalFeatureClass, element, "Enums, records and annotation types cannot be features or configurations");
    }

    public static <S, T> SimpleMessage<S, T> nonOverridableMethod(SrcElement<S, T> element) {
        return SimpleMessage.of(Id.NonOverridableMethod, element, "Composition methods cannot be final, native or static or private");
    }

    public static <S, T> SimpleMessage<S, T> provisionOverrideMissing(SrcElement<S, T> element, SrcElement<S, T> conflict) {
        return SimpleMessage.of(Id.ProvisionOverrideMissing, element, "Non-singleton provision overriding singleton provision must specify override=true (overrides {1})", conflict);
    }

    public static <S, T> SimpleMessage<S, T> unresolvedProvision(SrcElement<S, T> element, SrcElement<S, T> conflict) {
        return SimpleMessage.of(Id.UnresolvedProvision, element, "Unresolved provision '{1:name}'", conflict);
    }

    public static <S, T> SimpleMessage<S, T> incompatibleProvisionTypes(SrcElement<S, T> element, SrcElement<S, T> provision, SrcElement<S, T> implementation, Option<SrcElement<S, T>> implementationVia) {
        return SimpleMessage.of(Id.IncompatibleProvisionTypes, element, "Provision '{1:name}' has incompatible type (using {2:className}::{2:name}" + (String)implementationVia.map(v -> " mounted from {3:name}").getOrElse((Object)"") + ")", List.of((Object[])new Option[]{Option.some(provision), Option.some(implementation), implementationVia}).flatMap(Value::toStream));
    }

    public static <S, T> SimpleMessage<S, T> incompatibleProvisionThrows(SrcElement<S, T> element, SrcElement<S, T> provision, SrcElement<S, T> exception) {
        return SimpleMessage.of(Id.IncompatibleProvisionThrows, element, "Incompatible throws clause for provision '{1:name}', implementing method throws {2}", provision, exception);
    }

    public static <S, T> SimpleMessage<S, T> conflictingProvisions(SrcElement<S, T> element, Seq<SrcElement<S, T>> conflicts) {
        return SimpleMessage.of(Id.ConflictingProvisions, element, "Conflicting provisions for '{1:name}'; conflicts with {1+:className}", conflicts);
    }

    public static <S, T> SimpleMessage<S, T> mountedProvisionOverridesMethod(SrcElement<S, T> element, SrcElement<S, T> method, SrcElement<S, T> mount) {
        return SimpleMessage.of(Id.MountedProvisionOverridesMethod, element, "Method '{1:name}' conflicts with mounted provision(s) from '{2:name}'", method, mount);
    }

    public static <S, T> SimpleMessage<S, T> elementNotAccessible(SrcElement<S, T> element, SrcElement<S, T> conflict) {
        if (!element.equals(conflict)) {
            return SimpleMessage.of(Id.ElementNotAccessible, element, "{1:Kind} {1:name} not accessible", conflict);
        }
        return SimpleMessage.of(Id.ElementNotAccessible, element, "{1:Kind} not accessible", conflict);
    }

    public static <S, T> SimpleMessage<S, T> abstractMethodWillNotBeImplemented(SrcElement<S, T> element, SrcElement<S, T> conflict) {
        return SimpleMessage.of(Id.AbstractMethodWillNotBeImplemented, element, "Abstract method {1} will not be implemented by the configuration", conflict);
    }

    public static <S, T> SimpleMessage<S, T> noParametersAllowed(SrcElement<S, T> element) {
        return SimpleMessage.of(Id.NoParametersAllowed, element, "Method must not take any parameters");
    }

    public static <S, T> SimpleMessage<S, T> mustReturnReference(SrcElement<S, T> element) {
        return SimpleMessage.of(Id.MustReturnReference, element, "Method must return a reference type");
    }

    public static <S, T> SimpleMessage<S, T> mountMethodMustBeAbstract(SrcElement<S, T> element) {
        return SimpleMessage.of(Id.MountMethodMustBeAbstract, element, "Mount methods must be abstract");
    }

    public static <S, T> SimpleMessage<S, T> mountMethodsAllowedInConfigurationsOnly(SrcElement<S, T> element) {
        return SimpleMessage.of(Id.MountMethodsAllowedInConfigurationsOnly, element, "Mount methods are allowed in configurations only");
    }

    public static <S, T> SimpleMessage<S, T> mountMethodMustReturnFeature(SrcElement<S, T> element, SrcElement<S, T> conflict) {
        return SimpleMessage.of(Id.MountMethodMustReturnFeature, element, "Mount methods must return a @" + Feature.class.getSimpleName() + " or @" + Configuration.class.getSimpleName(), conflict);
    }

    public static <S, T> SimpleMessage<S, T> mountAttributeClassMustNotBeParametrized(SrcElement<S, T> element, SrcElement<S, T> conflict) {
        return SimpleMessage.of(Id.MountAttributeClassMustNotBeParametrized, element, "Mounted class '{1:name}' must not be parametrized", conflict);
    }

    public static <S, T> SimpleMessage<S, T> missingNoArgsConstructor(SrcElement<S, T> type) {
        return Message.missingNoArgsConstructor(type, type);
    }

    public static <S, T> SimpleMessage<S, T> missingNoArgsConstructor(SrcElement<S, T> elem, SrcElement<S, T> type) {
        if (elem.kind() == SrcElement.Kind.METHOD) {
            return SimpleMessage.of(Id.MissingNoArgsConstructor, elem, "Illegal return type: class has no accessible no-arg constructor", type);
        }
        return SimpleMessage.of(Id.MissingNoArgsConstructor, elem, "Class has no accessible no-arg constructor", type);
    }

    public static <S, T> SimpleMessage<S, T> illegalInnerClass(SrcElement<S, T> type) {
        return Message.illegalInnerClass(type, type);
    }

    public static <S, T> SimpleMessage<S, T> illegalInnerClass(SrcElement<S, T> elem, SrcElement<S, T> type) {
        if (elem.kind() == SrcElement.Kind.METHOD) {
            return SimpleMessage.of(Id.IllegalInnerClass, elem, "Illegal return type: features and configurations must be top-level or nested classes");
        }
        return SimpleMessage.of(Id.IllegalInnerClass, elem, "Illegal inner class: features and configurations must be top-level or nested classes");
    }

    public static <S, T> SimpleMessage<S, T> extensionPointReturnRecommended(SrcElement<S, T> element, SrcElement<S, T> conflict) {
        return SimpleMessage.of(Id.ExtensionPointReturnRecommended, element, "Extension point provisions should return a type annotated with @" + ExtensionPoint.class.getSimpleName(), conflict);
    }

    public static <S, T> SimpleMessage<S, T> returnValueIgnored(SrcElement<S, T> element) {
        return SimpleMessage.of(Id.ReturnValueIgnored, element, "Return value ignored");
    }

    public static <S, T> SimpleMessage<S, T> meldAnnotationOutsideFeature(SrcElement<S, T> element) {
        return SimpleMessage.of(Id.MeldAnnotationOutsideFeature, element, "Meld annotation outside feature");
    }

    public static <S, T> SimpleMessage<S, T> typesafeConfigNotOnClasspath(SrcElement<S, T> element) {
        return SimpleMessage.of(Id.TypesafeConfigNotOnClasspath, element, "Typesafe config is not on classpath, configuration not supported");
    }

    public static <S, T> SimpleMessage<S, T> configTypeNotSupported(SrcElement<S, T> element) {
        return SimpleMessage.of(Id.ConfigTypeNotSupported, element, "Type not supported for configuration");
    }

    public static <S, T> SimpleMessage<S, T> unresolvedExtensionPoint(SrcElement<S, T> epConsumer, SrcElement<S, T> epType) {
        return SimpleMessage.of(Id.UnresolvedExtensionPoint, epConsumer, "Unresolved extension point {1}", epType);
    }

    public static <S, T> SimpleMessage<S, T> unresolvedExtensionPoint(SrcElement<S, T> source, SrcElement<S, T> epConsumer, SrcElement<S, T> epType) {
        SimpleMessage<S, T> origin = Message.unresolvedExtensionPoint(epConsumer, epType);
        origin = origin.withMessage(origin.message());
        return Message.unresolvedExtensionPoint(source, epType).withOrigins((Seq<Message<S, T>>)List.of(origin));
    }

    public static <S, T> SimpleMessage<S, T> conflictingExtensionPoints(SrcElement<S, T> element, Seq<SrcElement<S, T>> conflicts) {
        return SimpleMessage.of(Id.ConflictingExtensionPoints, element, "Conflicting extension points", conflicts);
    }

    public static <S, T> SimpleMessage<S, T> missingFeatureImportAnnotation(SrcElement<S, T> element, SrcElement<S, T> superType) {
        return SimpleMessage.of(Id.MissingFeatureImportAnnotation, element, "Class extends/implements non-feature class {1} without `@Feature.Import` annotation", superType);
    }

    public static <S, T> SimpleMessage<S, T> featureInterfacesShouldDeclareProvisionsOnly(SrcElement<S, T> methodElement, SrcElement<S, T> typeElement) {
        Option<SrcElement<S, T>> declaringType = methodElement.findClass();
        String baseMsg = "Feature interfaces should declare provisions only";
        if (declaringType.equals((Object)Option.some(typeElement))) {
            return SimpleMessage.of(Id.FeatureInterfacesShouldDeclareProvisionsOnly, methodElement, baseMsg);
        }
        if (declaringType.isDefined()) {
            return SimpleMessage.of(Id.FeatureInterfacesShouldDeclareProvisionsOnly, typeElement, "Feature interfaces should declare provisions only (method {1:name} inherited from {2:name})", methodElement, (SrcElement)declaringType.get());
        }
        return SimpleMessage.of(Id.FeatureInterfacesShouldDeclareProvisionsOnly, typeElement, "Feature interfaces should declare provisions only (inherited method {1:name})", methodElement);
    }

    public static <S, T> String defaultRenderMessage(Message<S, T> msg, Function<? super S, ? extends CharSequence> elementRenderer) {
        Seq args = msg.conflicts().prepend(msg.element());
        StringBuilder result = new StringBuilder();
        int start = 0;
        Matcher matcher = RENDER_SUBSTITUTION_RE.matcher(msg.message());
        while (matcher.find()) {
            int index = Integer.parseInt(matcher.group("idx"));
            int endIndex = matcher.group("iter") == null ? index + 1 : args.length();
            List elements = index < args.length() ? args.subSequence(index, endIndex) : List.empty();
            String attr = matcher.group("attr");
            result.append(msg.message(), start, matcher.start());
            Seq rendered = attr == null ? elements.map(SrcElement::source).map(elementRenderer).map(Object::toString).map(Option::some) : (Seq)RENDER_ATTRIBUTE_EXTRACTORS.get((Object)attr).map(arg_0 -> ((Seq)elements).map(arg_0)).getOrElse((Object)List.empty());
            if (rendered.isEmpty() || rendered.exists(Option::isEmpty)) {
                result.append("<?").append(matcher.group()).append(">");
            } else {
                result.append(rendered.map(Option::get).mkString((CharSequence)", "));
            }
            start = matcher.end();
        }
        result.append(msg.message(), start, msg.message().length());
        return result.toString();
    }

    public static enum Id {
        ConflictingCompositionRoles,
        ConflictingOverride,
        ObjectOverride,
        TypeNotExtendable,
        IllegalFeatureClass,
        NonOverridableMethod,
        ProvisionOverrideMissing,
        UnresolvedProvision,
        IncompatibleProvisionTypes,
        IncompatibleProvisionThrows,
        ConflictingProvisions,
        MountedProvisionOverridesMethod,
        ElementNotAccessible,
        AbstractMethodWillNotBeImplemented,
        NoParametersAllowed,
        MustReturnReference,
        MountMethodMustBeAbstract,
        MountMethodsAllowedInConfigurationsOnly,
        MountMethodMustReturnFeature,
        MountAttributeClassMustNotBeParametrized,
        MissingNoArgsConstructor,
        IllegalInnerClass,
        TypesafeConfigNotOnClasspath,
        ConfigTypeNotSupported,
        UnresolvedExtensionPoint,
        ConflictingExtensionPoints,
        MissingFeatureImportAnnotation,
        ExtensionPointReturnRecommended(true),
        ReturnValueIgnored(true),
        MeldAnnotationOutsideFeature(true),
        FeatureInterfacesShouldDeclareProvisionsOnly(true);

        private static final Map<String, Id> BY_NAME;
        private final boolean warning;

        private Id() {
            this(false);
        }

        private Id(boolean warning) {
            this.warning = warning;
        }

        public static Option<Id> forName(String name) {
            return BY_NAME.get((Object)name);
        }

        public boolean warning() {
            return this.warning;
        }

        static {
            BY_NAME = (Map)Stream.of(Id.values()).collect(HashMap.collector(Enum::name));
        }
    }

    public static final class Suppression {
        private Suppression() {
        }

        public static String prefix() {
            return "meld";
        }

        public static String all() {
            return "all";
        }

        public static String meldId(String str) {
            if (str.equals(Suppression.all())) {
                return Suppression.all();
            }
            int index = str.indexOf(46);
            if (index <= 0) {
                return "";
            }
            String prefix = str.substring(0, index).trim();
            String id = str.substring(index + 1).trim();
            if (!prefix.equals(Suppression.prefix())) {
                return "";
            }
            return Id.BY_NAME.containsKey((Object)id) ? id : "";
        }
    }
}

