/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.processor;

import ch.raffael.meldioc.model.messages.Message;
import io.vavr.API;
import io.vavr.Tuple2;
import io.vavr.control.Option;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Diagnostics {
    public static final String MESSAGE_ID_PREFIX = "#MID:";
    private static final Pattern MSG_ID_RE = Pattern.compile("(" + Pattern.quote("#MID:") + "(\\p{Alnum}+)\\s+)(.*)", 40);

    private Diagnostics() {
    }

    public static Tuple2<Option<Message.Id>, String> extractMessageId(String message) {
        Matcher m = MSG_ID_RE.matcher(message);
        if (m.matches()) {
            Message.Id id;
            try {
                id = Message.Id.valueOf((String)m.group(2));
            }
            catch (IllegalArgumentException e) {
                return API.Tuple((Object)API.None(), (Object)message);
            }
            return API.Tuple((Object)API.Some((Object)id), (Object)m.group(3));
        }
        return API.Tuple((Object)API.None(), (Object)message);
    }

    public static StringBuilder appendMessageId(StringBuilder target, Message<?, ?> msg) {
        msg.id().forEach(id -> target.append(MESSAGE_ID_PREFIX).append(id).append(' '));
        return target;
    }
}

