/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.processor;

import ch.raffael.meldioc.Configuration;
import ch.raffael.meldioc.meta.Generated;
import ch.raffael.meldioc.model.AccessPolicy;
import ch.raffael.meldioc.model.ClassRef;
import ch.raffael.meldioc.model.ConfigRef;
import ch.raffael.meldioc.model.ModelMethod;
import ch.raffael.meldioc.model.ModelType;
import ch.raffael.meldioc.model.config.ConfigurationConfig;
import ch.raffael.meldioc.model.config.ProvisionConfig;
import ch.raffael.meldioc.processor.CatchHelper;
import ch.raffael.meldioc.processor.MemberNames;
import ch.raffael.meldioc.processor.TypeRef;
import ch.raffael.meldioc.processor.Version;
import ch.raffael.meldioc.processor.env.Environment;
import ch.raffael.meldioc.processor.env.KnownElements;
import ch.raffael.meldioc.processor.util.Elements;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import com.squareup.javapoet.WildcardTypeName;
import io.vavr.API;
import io.vavr.Function3;
import io.vavr.Tuple2;
import io.vavr.Tuple3;
import io.vavr.collection.Seq;
import io.vavr.collection.Traversable;
import java.io.Serializable;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;

public class Generator {
    public static final String CONFIG_FIELD_NAME = "config";
    public static final String DISPATCHER_CLASS_NAME = "Dispatcher";
    public static final String DISPATCHER_FIELD_NAME = "dispatcher";
    public static final String BUILDER_CLASS_NAME = "Builder";
    public static final String BUILDER_METHOD_NAME = "builder";
    public static final String BUILD_METHOD_NAME = "build";
    public static final String NEW_DISPATCHER_METHOD = "newDispatcher";
    public static final String SETUP_METHOD = "setup";
    public static final String BUILD_NEW_SHELL_METHOD = "newShell";
    public static final String CATCH_EXCEPTION = "ex";
    public static final String DISAMBIGUATION_PREFIX = "$MeldIoC_";
    public static final String SHARED_CLASS_NAME = "$MeldIoC_Shared";
    public static final String SHARED_GETTER_NAME = "getSneakyRethrowing";
    public static final String PROVIDER_CLASS_NAME = "$MeldIoC_Provider";
    private final Class<?> generatorClass;
    private final Environment env;
    private final TypeElement sourceElement;
    private final DeclaredType sourceType;
    private final ModelType<Element, TypeRef> sourceModel;
    private final ConfigurationConfig<Element> configurationConfig;
    private final ClassName shellClassName;
    private final TypeSpec.Builder shellBuilder;
    private final ClassName builderClassName;
    private final ClassName dispatcherClassName;
    private final TypeSpec.Builder dispatcherBuilder;
    private final ClassName sharedClassName;
    private final ClassName providerClassName;
    private boolean generateShared = false;
    private Seq<Tuple3<TypeName, String, String>> shellParameters = API.Seq((Object)API.Tuple((Object)KnownElements.CONFIG_TYPE, (Object)"config", (Object)"config"));

    Generator(Class<?> generatorClass, Environment env, TypeElement sourceElement) {
        this.generatorClass = generatorClass;
        this.env = env;
        this.sourceElement = sourceElement;
        this.sourceType = (DeclaredType)sourceElement.asType();
        this.sourceModel = env.model().modelOf((Object)env.typeRef(this.sourceType));
        this.configurationConfig = (ConfigurationConfig)this.sourceModel.element().configurationConfigOption().getOrElseThrow(() -> new IllegalStateException(sourceElement + " not annotated with " + Configuration.class.getSimpleName()));
        ClassRef targetRef = this.configurationConfig.shellClassRef(env.elements().getPackageOf(sourceElement).getQualifiedName().toString(), sourceElement.getSimpleName().toString());
        this.shellClassName = ClassName.get((String)targetRef.packageName(), (String)targetRef.className(), (String[])new String[0]);
        this.shellBuilder = TypeSpec.classBuilder((ClassName)this.shellClassName);
        this.builderClassName = this.shellClassName.nestedClass(BUILDER_CLASS_NAME);
        this.sharedClassName = this.shellClassName.nestedClass(SHARED_CLASS_NAME);
        this.providerClassName = this.shellClassName.nestedClass(PROVIDER_CLASS_NAME);
        this.dispatcherClassName = this.shellClassName.nestedClass(DISPATCHER_CLASS_NAME);
        this.dispatcherBuilder = TypeSpec.classBuilder((ClassName)this.dispatcherClassName);
    }

    TypeElement sourceElement() {
        return this.sourceElement;
    }

    public DeclaredType sourceType() {
        return this.sourceType;
    }

    String targetClassName() {
        return this.shellClassName.toString();
    }

    int errorCount() {
        return this.env.adaptor().errorCount();
    }

    int warningCount() {
        return this.env.adaptor().warningCount();
    }

    String generate() {
        Instant timestamp = Instant.now().truncatedTo(ChronoUnit.MILLIS);
        this.shellBuilder.addModifiers(new Modifier[]{Modifier.FINAL});
        if (!this.configurationConfig.packageLocal()) {
            this.shellBuilder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        }
        this.shellBuilder.addAnnotation(AnnotationSpec.builder(Generated.class).addMember("timestamp", "$S", new Object[]{DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(timestamp.atZone(ZoneId.systemDefault()))}).addMember("version", "$S", new Object[]{Version.version()}).build());
        this.env.known().javaxGenerated().forEach(at -> this.shellBuilder.addAnnotation(AnnotationSpec.builder((ClassName)ClassName.get(javax.annotation.processing.Generated.class)).addMember("value", "$S", new Object[]{this.generatorClass.getCanonicalName()}).addMember("date", "$S", new Object[]{DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(timestamp.atZone(ZoneId.systemDefault()))}).build()));
        this.shellBuilder.addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"all"}).build());
        Seq<TypeSpec.Builder> mounts = this.generateMountClasses();
        this.sourceModel.mountMethods().filter(m -> !m.element().mountConfig().injected()).forEach(m -> {
            ClassName className = this.shellClassName.nestedClass(MemberNames.forMountClass(m.element()));
            this.shellBuilder.addField(FieldSpec.builder((TypeName)className, (String)MemberNames.forMount(m.element()), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer("new $T()", new Object[]{className}).build());
        });
        this.shellParameters = this.shellParameters.appendAll((Iterable)this.sourceModel.mountMethods().filter(m -> m.element().mountConfig().injected()).map(m -> API.Tuple((Object)TypeName.get((TypeMirror)Elements.asDeclaredType(((TypeRef)m.element().type()).mirror())), (Object)MemberNames.forMount(m.element()), (Object)MemberNames.forMount(m.element()))));
        this.shellParameters.forEach(tpl -> tpl.apply((Function3 & Serializable)(t, n, __) -> this.shellBuilder.addField(FieldSpec.builder((TypeName)t, (String)n, (Modifier[])new Modifier[]{Modifier.FINAL}).addModifiers(this.conditionalModifiers(true, Modifier.PRIVATE)).build())));
        this.shellBuilder.addField(FieldSpec.builder((TypeName)this.dispatcherClassName, (String)DISPATCHER_FIELD_NAME, (Modifier[])new Modifier[]{Modifier.FINAL}).addModifiers(this.conditionalModifiers(true, Modifier.PRIVATE)).build());
        this.shellBuilder.addMethod(MethodSpec.methodBuilder((String)BUILDER_METHOD_NAME).addModifiers(new Modifier[]{Modifier.STATIC}).addModifiers(this.conditionalModifiers(!this.configurationConfig.packageLocal(), Modifier.PUBLIC)).returns((TypeName)this.builderClassName).addCode(CodeBlock.builder().addStatement("return new $T()", new Object[]{this.builderClassName}).build()).build());
        this.shellBuilder.addMethod(MethodSpec.methodBuilder((String)NEW_DISPATCHER_METHOD).addModifiers(this.conditionalModifiers(true, Modifier.PRIVATE)).returns((TypeName)this.dispatcherClassName).addCode(CodeBlock.builder().addStatement("return new $T()", new Object[]{this.dispatcherClassName}).build()).build());
        Traversable<DeclaredType> throwing = this.generateSetupMethod(this.shellBuilder);
        this.shellBuilder.addMethod(this.generateShellConstructor(throwing));
        this.generateBuilder(throwing);
        this.generateDispatcher();
        this.shellBuilder.addType(this.dispatcherBuilder.build());
        mounts.map(TypeSpec.Builder::build).forEach(arg_0 -> ((TypeSpec.Builder)this.shellBuilder).addType(arg_0));
        if (this.generateShared) {
            this.generateProvider();
            this.generateShared();
        }
        this.shellBuilder.alwaysQualify(new String[]{"Shared"});
        JavaFile.Builder fileBuilder = JavaFile.builder((String)this.shellClassName.packageName(), (TypeSpec)this.shellBuilder.build()).addFileComment("Generated by ch.raffael.meldioc, " + new Date(timestamp.toEpochMilli()), new Object[0]);
        return fileBuilder.build().toString();
    }

    @Nonnull
    private MethodSpec generateShellConstructor(Traversable<DeclaredType> throwing) {
        MethodSpec.Builder builder = MethodSpec.constructorBuilder().addModifiers(this.conditionalModifiers(true, Modifier.PRIVATE));
        throwing.forEach(e -> builder.addException(TypeName.get((TypeMirror)e)));
        CodeBlock.Builder code = CodeBlock.builder();
        this.shellParameters.forEach(tpl -> tpl.apply((Function3 & Serializable)(t, n, m) -> {
            builder.addParameter(t, n, new Modifier[0]);
            Object statement = "this.$L = $T.requireNonNull($L, $S)";
            if (n.equals(CONFIG_FIELD_NAME)) {
                statement = (String)statement + ".resolve()";
            }
            builder.addStatement((String)statement, new Object[]{n, Objects.class, n, n + " is null"});
            return null;
        }));
        code.addStatement("$L = $L()", new Object[]{DISPATCHER_FIELD_NAME, NEW_DISPATCHER_METHOD});
        code.addStatement("$L()", new Object[]{SETUP_METHOD});
        builder.addCode(code.build());
        return builder.build();
    }

    private void generateBuilder(Traversable<DeclaredType> throwing) {
        TypeSpec.Builder builder = TypeSpec.classBuilder((ClassName)this.builderClassName);
        builder.addModifiers(new Modifier[]{Modifier.STATIC});
        builder.addModifiers(this.conditionalModifiers(true, Modifier.FINAL));
        builder.addModifiers(this.conditionalModifiers(!this.configurationConfig.packageLocal(), Modifier.PUBLIC));
        this.shellParameters.forEach(f -> builder.addField((TypeName)f._1, (String)f._2, this.conditionalModifiers(true, Modifier.PRIVATE)));
        builder.addMethod(MethodSpec.constructorBuilder().addModifiers(this.conditionalModifiers(true, Modifier.PRIVATE)).build());
        this.shellParameters.forEach(f -> f.apply((Function3 & Serializable)(t, n, bn) -> builder.addMethod(MethodSpec.methodBuilder((String)bn).addModifiers(this.conditionalModifiers(!this.configurationConfig.packageLocal(), Modifier.PUBLIC)).addParameter(t, bn, new Modifier[0]).returns((TypeName)this.builderClassName).addCode(CodeBlock.builder().addStatement("this.$L = $L", new Object[]{n, bn}).addStatement("return this", new Object[0]).build()).build())));
        MethodSpec.Builder buildBuilder = MethodSpec.methodBuilder((String)BUILD_METHOD_NAME).addModifiers(this.conditionalModifiers(!this.configurationConfig.packageLocal(), Modifier.PUBLIC)).returns(ClassName.get((TypeMirror)this.sourceType));
        throwing.forEach(e -> buildBuilder.addException(TypeName.get((TypeMirror)e)));
        this.shellParameters.map(Tuple3::_2).forEach(f -> buildBuilder.addStatement("if ($L == null) throw new $T($S)", new Object[]{f, IllegalStateException.class, f + " is not set"}));
        buildBuilder.addStatement("return $L().$L", new Object[]{BUILD_NEW_SHELL_METHOD, DISPATCHER_FIELD_NAME});
        builder.addMethod(buildBuilder.build());
        MethodSpec.Builder newShellBuilder = MethodSpec.methodBuilder((String)BUILD_NEW_SHELL_METHOD).addModifiers(this.conditionalModifiers(true, Modifier.PRIVATE)).returns((TypeName)this.shellClassName).addCode(CodeBlock.builder().addStatement(this.shellParameters.map(f -> "$L").mkString((CharSequence)"return new $T(", (CharSequence)", ", (CharSequence)")"), API.Seq((Object)this.shellClassName).appendAll((Iterable)this.shellParameters.map(Tuple3::_2)).toJavaArray()).build());
        throwing.forEach(e -> newShellBuilder.addException(TypeName.get((TypeMirror)e)));
        builder.addMethod(newShellBuilder.build());
        this.shellBuilder.addType(builder.build());
    }

    void generateDispatcher() {
        this.dispatcherBuilder.superclass(TypeName.get((TypeMirror)this.sourceElement.asType())).addModifiers(this.conditionalModifiers(true, Modifier.PRIVATE, Modifier.FINAL));
        this.generateDispatcherMembers(this.dispatcherBuilder);
    }

    private void generateDispatcherMembers(TypeSpec.Builder builder) {
        this.generateDispatcherConstructor(builder);
        this.generateSelfProvisions(builder, this.sourceModel);
        this.generateForwardedProvisions(builder, this.sourceModel);
        this.generateMountMethods(builder);
        this.generateParameterMethods(builder, this.sourceModel);
    }

    private void generateDispatcherConstructor(TypeSpec.Builder builder) {
        builder.addMethod(MethodSpec.constructorBuilder().addModifiers(this.conditionalModifiers(true, Modifier.PRIVATE)).build());
    }

    private Traversable<DeclaredType> generateSetupMethod(TypeSpec.Builder builder) {
        CodeBlock.Builder code = CodeBlock.builder();
        CatchHelper catchHelper = new CatchHelper(this.env);
        if (this.sourceModel.setupMethods().nonEmpty()) {
            this.sourceModel.setupMethods().forEach(cm -> ((Tuple2)cm.via().fold(() -> {
                catchHelper.add(((ExecutableElement)cm.element().source(ExecutableElement.class)).getThrownTypes().stream());
                return API.Tuple((Object)"$T.this.$L.$L", (Object)API.Seq((Object[])new Comparable[]{this.shellClassName, DISPATCHER_FIELD_NAME, cm.element().name()}));
            }, via -> {
                catchHelper.add(Elements.asExecutableType(this.env.types().asMemberOf(Elements.asDeclaredType(((TypeRef)via.element().type()).mirror()), (Element)cm.element().source())).getThrownTypes().stream());
                return API.Tuple((Object)"$T.this.$L.$L", (Object)API.Seq((Object[])new Comparable[]{this.shellClassName, MemberNames.forMount(via.element()), cm.element().name()}));
            })).apply((call, callArgs) -> {
                ArrayList args = new ArrayList(callArgs.asJava());
                String pattern = cm.arguments().map(e -> (String)e.fold(method -> (String)method.via().map(via -> {
                    args.add(this.shellClassName);
                    args.add(MemberNames.forMount(via.element()));
                    args.add(method.element().name());
                    return "$T.this.$L.$L()";
                }).getOrElse(() -> {
                    args.add(this.shellClassName);
                    args.add(DISPATCHER_FIELD_NAME);
                    args.add(method.element().name());
                    return "$T.this.$L.$L()";
                }), builtin -> {
                    switch (builtin) {
                        case CONFIG: {
                            args.add(this.shellClassName);
                            args.add(CONFIG_FIELD_NAME);
                            return "$T.this.$L";
                        }
                    }
                    args.add("$error");
                    return "$L";
                })).mkString((CharSequence)(call + "(\n"), (CharSequence)",\n", (CharSequence)")");
                code.addStatement(pattern, args.toArray(new Object[args.size()]));
                return null;
            }));
        }
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)SETUP_METHOD).addModifiers(this.conditionalModifiers(true, Modifier.PRIVATE));
        catchHelper.checked().forEach(e -> methodBuilder.addException(TypeName.get((TypeMirror)e)));
        builder.addMethod(methodBuilder.addCode(code.build()).build());
        return catchHelper.checked();
    }

    private void generateForwardedProvisions(TypeSpec.Builder builder, ModelType<Element, TypeRef> model) {
        Seq allProvisions = model.provisionMethods().appendAll((Iterable)model.extensionPointMethods());
        allProvisions.map(m -> m.via().map(v -> API.Tuple((Object)m, (Object)v))).flatMap(Function.identity()).forEach(tp -> tp.apply((m, via) -> builder.addMethod(MethodSpec.overriding((ExecutableElement)((ExecutableElement)m.element().source(ExecutableElement.class)), (DeclaredType)Elements.asDeclaredType(((TypeRef)model.type()).mirror()), (Types)this.env.types()).addAnnotations(this.generatedAnnotations((ModelMethod<Element, ?>)m)).addStatement("return $T.this.$L.$L()", new Object[]{this.shellClassName, MemberNames.forMount(via.element()), m.element().name()}).build())));
    }

    private void generateSelfProvisions(TypeSpec.Builder builder, ModelType<Element, TypeRef> model) {
        model.provisionMethods().appendAll((Iterable)model.extensionPointMethods()).filter(m -> !m.element().isAbstract()).filter(m -> m.via().isEmpty()).forEach(m -> {
            MethodSpec.Builder methodBuilder = MethodSpec.overriding((ExecutableElement)((ExecutableElement)m.element().source(ExecutableElement.class)), (DeclaredType)Elements.asDeclaredType(((TypeRef)model.type()).mirror()), (Types)this.env.types()).addAnnotations(this.generatedAnnotations((ModelMethod<Element, ?>)m));
            if (((Boolean)m.element().provisionConfigOption().map(ProvisionConfig::shared).getOrElse((Object)true)).booleanValue()) {
                this.generateShared = true;
                builder.addField(FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)this.sharedClassName, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)((TypeRef)m.element().type()).mirror())}), (String)m.element().name(), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer("new $T<>(() -> super.$L())", new Object[]{this.sharedClassName, m.element().name()}).build());
                methodBuilder.addStatement("return $L.$L()", new Object[]{m.element().name(), SHARED_GETTER_NAME});
            } else {
                methodBuilder.addStatement("return super.$L()", new Object[]{m.element().name()});
            }
            builder.addMethod(methodBuilder.build());
        });
    }

    private Seq<AnnotationSpec> generatedAnnotations(ModelMethod<Element, ?> method) {
        return API.Seq();
    }

    private void generateMountMethods(TypeSpec.Builder builder) {
        this.sourceModel.mountMethods().reject(m -> m.element().synthetic()).forEach(m -> {
            MethodSpec.Builder mb = MethodSpec.overriding((ExecutableElement)((ExecutableElement)m.element().source(ExecutableElement.class)), (DeclaredType)this.sourceType, (Types)this.env.types()).addAnnotations(this.generatedAnnotations((ModelMethod<Element, ?>)m));
            if (m.element().mountConfig().injected()) {
                mb.addStatement("return $T.this.$L", new Object[]{this.shellClassName, MemberNames.forMount(m.element())});
            } else {
                mb.addStatement("return $L", new Object[]{MemberNames.forMount(m.element())});
            }
            builder.addMethod(mb.build());
        });
    }

    private Seq<TypeSpec.Builder> generateMountClasses() {
        return this.sourceModel.mountMethods().filter(m -> !m.element().mountConfig().injected()).map(mount -> {
            TypeSpec.Builder builder = TypeSpec.classBuilder((ClassName)this.shellClassName.nestedClass(MemberNames.forMountClass(mount.element()))).addModifiers(this.conditionalModifiers(true, Modifier.PRIVATE, Modifier.FINAL)).addModifiers(new Modifier[0]);
            if (Elements.asDeclaredType(((TypeRef)mount.element().type()).mirror()).asElement().getKind() == ElementKind.INTERFACE) {
                builder.addSuperinterface(TypeName.get((TypeMirror)((TypeRef)mount.element().type()).mirror()));
            } else {
                builder.superclass(TypeName.get((TypeMirror)((TypeRef)mount.element().type()).mirror()));
            }
            ModelType mountedModel = this.env.model().modelOf((Object)this.env.typeRef(Elements.asDeclaredType(((TypeRef)mount.element().type()).mirror())));
            mountedModel.mountMethods().appendAll((Iterable)mountedModel.provisionMethods()).appendAll((Iterable)mountedModel.extensionPointMethods()).filter(m -> m.element().isAbstract()).forEach(m -> builder.addMethod(MethodSpec.overriding((ExecutableElement)((ExecutableElement)m.element().source(ExecutableElement.class)), (DeclaredType)Elements.asDeclaredType(((TypeRef)mountedModel.type()).mirror()), (Types)this.env.types()).addAnnotations(this.generatedAnnotations((ModelMethod<Element, ?>)m)).addStatement("return $T.this.$L.$L()", new Object[]{this.shellClassName, DISPATCHER_FIELD_NAME, m.element().name()}).build()));
            this.generateSelfProvisions(builder, (ModelType<Element, TypeRef>)mountedModel);
            this.generateParameterMethods(builder, (ModelType<Element, TypeRef>)mountedModel);
            this.generateSetupExposureOverrides(builder, (ModelType<Element, TypeRef>)mountedModel);
            return builder;
        });
    }

    private void generateParameterMethods(TypeSpec.Builder builder, ModelType<Element, TypeRef> model) {
        model.parameterMethods().filter(m -> m.via().isEmpty()).forEach(cm -> {
            MethodSpec.Builder mbuilder = MethodSpec.overriding((ExecutableElement)((ExecutableElement)cm.element().source(ExecutableElement.class)), (DeclaredType)Elements.asDeclaredType(((TypeRef)model.type()).mirror()), (Types)this.env.types());
            mbuilder.addAnnotations(this.generatedAnnotations((ModelMethod<Element, ?>)cm));
            ConfigRef configRef = (ConfigRef)model.model().configSupportedTypeOption((Object)((TypeRef)cm.element().type())).getOrNull();
            if (configRef == null) {
                return;
            }
            String n = cm.element().parameterConfig().fullPath(cm.element());
            if (n.equals("*")) {
                mbuilder.addStatement("return $T.this.$L", new Object[]{this.shellClassName, CONFIG_FIELD_NAME});
            } else {
                if (!cm.element().isAbstract()) {
                    mbuilder.beginControlFlow("if ($T.this.$L.hasPath($S))", new Object[]{this.shellClassName, CONFIG_FIELD_NAME, n});
                }
                if (configRef.targetTypeArgument() != null) {
                    mbuilder.addStatement("return $T.this.$L.$L($T.class, $S)", new Object[]{this.shellClassName, CONFIG_FIELD_NAME, configRef.configMethodName(), ((TypeRef)configRef.targetTypeArgument()).mirror(), n});
                } else {
                    mbuilder.addStatement("return $T.this.$L.$L($S)", new Object[]{this.shellClassName, CONFIG_FIELD_NAME, configRef.configMethodName(), n});
                }
                if (!cm.element().isAbstract()) {
                    mbuilder.endControlFlow();
                    mbuilder.beginControlFlow("else", new Object[0]);
                    mbuilder.addStatement("return super.$L()", new Object[]{cm.element().name()});
                    mbuilder.endControlFlow();
                }
            }
            builder.addMethod(mbuilder.build());
        });
    }

    private void generateSetupExposureOverrides(TypeSpec.Builder builder, ModelType<Element, TypeRef> model) {
        PackageElement pkg = this.env.elements().getPackageOf(Elements.asDeclaredType(((TypeRef)model.type()).mirror()).asElement());
        if (!pkg.getQualifiedName().toString().equals(this.shellClassName.packageName())) {
            model.setupMethods().filter(m -> m.element().accessPolicy() == AccessPolicy.PROTECTED).forEach(sm -> {
                ExecutableElement elem = (ExecutableElement)sm.element().source(ExecutableElement.class);
                MethodSpec.Builder mbuilder = MethodSpec.overriding((ExecutableElement)elem, (DeclaredType)Elements.asDeclaredType(((TypeRef)model.type()).mirror()), (Types)this.env.types());
                mbuilder.addStatement((elem.getReturnType().getKind() == TypeKind.VOID ? "" : "return ") + "super.$L($L)", new Object[]{elem.getSimpleName().toString(), elem.getParameters().stream().map(p -> p.getSimpleName().toString()).collect(Collectors.joining(", "))});
                builder.addMethod(mbuilder.build());
            });
        }
    }

    private Tuple3<MethodSpec.Builder, ExecutableType, List<? extends VariableElement>> methodWithSignatureFrom(ModelMethod<Element, TypeRef> m) {
        MethodSpec.Builder mb = MethodSpec.methodBuilder((String)m.element().name());
        ExecutableType exec = Elements.asExecutableType(this.env.types().asMemberOf(Elements.asDeclaredType(((TypeRef)m.modelType().type()).mirror()), (Element)m.element().source()));
        mb.returns(TypeName.get((TypeMirror)exec.getReturnType()));
        List<? extends VariableElement> params = ((ExecutableElement)m.element().source(ExecutableElement.class)).getParameters();
        List<? extends TypeMirror> paramTypes = exec.getParameterTypes();
        for (int i = 0; i < params.size(); ++i) {
            mb.addParameter(TypeName.get((TypeMirror)paramTypes.get(i)), params.get(i).getSimpleName().toString(), new Modifier[0]);
        }
        exec.getThrownTypes().stream().map(TypeName::get).forEach(arg_0 -> ((MethodSpec.Builder)mb).addException(arg_0));
        return API.Tuple((Object)mb, (Object)exec, params);
    }

    private Modifier[] conditionalModifiers(boolean condition, Modifier ... modifiers) {
        return condition ? modifiers : new Modifier[]{};
    }

    private void generateProvider() {
        TypeVariableName typeVar = TypeVariableName.get((String)"T");
        TypeSpec.Builder type = TypeSpec.interfaceBuilder((ClassName)this.providerClassName).addTypeVariable(typeVar).addAnnotation(ClassName.get((String)"java.lang", (String)"FunctionalInterface", (String[])new String[0])).addModifiers(new Modifier[]{Modifier.STATIC, Modifier.PRIVATE});
        type.addMethod(MethodSpec.methodBuilder((String)"get").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addException(TypeName.get((TypeMirror)this.env.known().throwable())).returns((TypeName)typeVar).build());
        this.shellBuilder.addType(type.build());
    }

    private void generateShared() {
        ClassName objects = ClassName.get((String)"java.util", (String)"Objects", (String[])new String[0]);
        TypeVariableName typeVar = TypeVariableName.get((String)"T");
        TypeSpec.Builder type = TypeSpec.classBuilder((ClassName)this.sharedClassName).addTypeVariable(typeVar).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL});
        type.addField(FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)this.providerClassName, (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf((TypeName)typeVar)}), (String)"provider", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.VOLATILE}).build());
        type.addField(FieldSpec.builder((TypeName)typeVar, (String)"value", (Modifier[])new Modifier[]{Modifier.PRIVATE}).build());
        type.addMethod(MethodSpec.constructorBuilder().addParameter((TypeName)ParameterizedTypeName.get((ClassName)this.providerClassName, (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf((TypeName)typeVar)}), "provider", new Modifier[0]).addStatement("this.provider = $T.requireNonNull(provider, $S)", new Object[]{objects, "provider"}).build());
        type.addMethod(MethodSpec.methodBuilder((String)SHARED_GETTER_NAME).returns((TypeName)typeVar).addCode(CodeBlock.builder().beginControlFlow("if (provider != null)", new Object[0]).beginControlFlow("synchronized (this)", new Object[0]).beginControlFlow("if (provider != null)", new Object[0]).beginControlFlow("try", new Object[0]).addStatement("value = $T.requireNonNull(provider.get(), $S)", new Object[]{objects, "provider.get()"}).addStatement("provider = null", new Object[0]).nextControlFlow("catch ($T e)", new Object[]{this.env.known().throwable()}).addStatement("sneakyThrow(e)", new Object[0]).endControlFlow().endControlFlow().endControlFlow().endControlFlow().addStatement("return value", new Object[0]).build()).addJavadoc("This sneakyThrows any exceptions thrown in the provider. \nThe user is responsible for declaring checked exceptions. \nCalling generated code <em>will</em> redeclare all declared exceptions, \nso undeclared checked exceptions are only thrown, when the user does so \nin his code.", new Object[0]).build());
        TypeVariableName excpetionTypeVar = TypeVariableName.get((String)"E");
        type.addMethod(MethodSpec.methodBuilder((String)"sneakyThrow").addAnnotation(this.suppressUnchecked()).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).addParameter(TypeName.get((TypeMirror)this.env.known().throwable()), CATCH_EXCEPTION, new Modifier[0]).addTypeVariable(excpetionTypeVar.withBounds(new TypeName[]{TypeName.get((TypeMirror)this.env.known().throwable())})).addException((TypeName)excpetionTypeVar).addStatement("throw ($T)$L", new Object[]{excpetionTypeVar, CATCH_EXCEPTION}).build());
        this.shellBuilder.addType(type.build());
    }

    private AnnotationSpec suppressUnchecked() {
        return AnnotationSpec.builder((ClassName)ClassName.get((String)"java.lang", (String)"SuppressWarnings", (String[])new String[0])).addMember("value", "$S", new Object[]{"unchecked"}).build();
    }

    public String toString() {
        return "Generator{sourceElement=" + this.sourceElement + "}";
    }
}

