/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.processor.env;

import ch.raffael.meldioc.model.AccessPolicy;
import ch.raffael.meldioc.model.CElement;
import ch.raffael.meldioc.model.ClassRef;
import ch.raffael.meldioc.model._CElement;
import ch.raffael.meldioc.model.config.ConfigurationConfig;
import ch.raffael.meldioc.model.config.ExtensionPointAcceptorConfig;
import ch.raffael.meldioc.model.config.ExtensionPointConfig;
import ch.raffael.meldioc.model.config.FeatureConfig;
import ch.raffael.meldioc.model.config.MountConfig;
import ch.raffael.meldioc.model.config.ParameterConfig;
import ch.raffael.meldioc.model.config.ParameterPrefixConfig;
import ch.raffael.meldioc.model.config.ProvisionConfig;
import ch.raffael.meldioc.model.config.SetupConfig;
import ch.raffael.meldioc.model.messages.Message;
import ch.raffael.meldioc.model.messages.MessageSink;
import ch.raffael.meldioc.processor.Diagnostics;
import ch.raffael.meldioc.processor.TypeRef;
import ch.raffael.meldioc.processor.env.Environment;
import ch.raffael.meldioc.processor.util.Elements;
import io.vavr.Tuple;
import io.vavr.collection.Iterator;
import io.vavr.collection.Seq;
import io.vavr.collection.Vector;
import io.vavr.control.Option;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.tools.Diagnostic;

public final class Adaptor
extends Environment.WithEnv
implements ch.raffael.meldioc.model.Adaptor<Element, TypeRef>,
MessageSink<Element, TypeRef> {
    private static final Pattern INIT_RE = Pattern.compile("<(cl)?init>");
    private static final String CONSTRUCTOR_NAME = "<init>";
    private final boolean includeMessageId;
    private final TypeRef noneTypeRef;
    private int errorCount = 0;
    private int warningCount = 0;

    Adaptor(Environment env, boolean includeMessageId) {
        super(env);
        this.includeMessageId = includeMessageId;
        this.noneTypeRef = this.typeRef(env.types().getNoType(TypeKind.NONE));
    }

    public int errorCount() {
        return this.errorCount;
    }

    public int warningCount() {
        return this.warningCount;
    }

    public boolean isSubtypeOf(TypeRef left, TypeRef right) {
        if (left.mirror().getKind().isPrimitive() || right.mirror().getKind().isPrimitive()) {
            return left.mirror().getKind() == right.mirror().getKind();
        }
        return this.env.types().isSubtype(left.mirror(), right.mirror());
    }

    public boolean isReference(TypeRef type) {
        return type.mirror() instanceof DeclaredType || type.mirror() instanceof TypeVariable;
    }

    public boolean isInterface(TypeRef type) {
        if (type.mirror() instanceof DeclaredType) {
            return ((DeclaredType)type.mirror()).asElement().getKind() == ElementKind.INTERFACE;
        }
        return false;
    }

    public boolean hasTypeParameters(TypeRef type) {
        if (this.isNoType(type)) {
            return false;
        }
        return type.mirror() instanceof DeclaredType && !((TypeElement)((DeclaredType)type.mirror()).asElement()).getTypeParameters().isEmpty();
    }

    public boolean isPrimitive(TypeRef type) {
        return type.mirror() instanceof PrimitiveType;
    }

    public boolean isEnumType(TypeRef type) {
        TypeMirror mirror = this.env.types().erasure(type.mirror());
        TypeMirror e = this.env.types().erasure(this.env.known().enumeration());
        return this.env.types().isSubtype(mirror, e) && !e.equals(mirror);
    }

    public TypeRef typeOf(ClassRef ref) {
        if (ref.isPrimitive()) {
            switch (ref.className()) {
                case "int": {
                    return this.typeRef(this.env.types().getPrimitiveType(TypeKind.INT));
                }
                case "long": {
                    return this.typeRef(this.env.types().getPrimitiveType(TypeKind.LONG));
                }
                case "short": {
                    return this.typeRef(this.env.types().getPrimitiveType(TypeKind.SHORT));
                }
                case "byte": {
                    return this.typeRef(this.env.types().getPrimitiveType(TypeKind.BYTE));
                }
                case "double": {
                    return this.typeRef(this.env.types().getPrimitiveType(TypeKind.DOUBLE));
                }
                case "float": {
                    return this.typeRef(this.env.types().getPrimitiveType(TypeKind.FLOAT));
                }
                case "char": {
                    return this.typeRef(this.env.types().getPrimitiveType(TypeKind.CHAR));
                }
                case "boolean": {
                    return this.typeRef(this.env.types().getPrimitiveType(TypeKind.BOOLEAN));
                }
                case "void": {
                    return this.typeRef(this.env.types().getPrimitiveType(TypeKind.VOID));
                }
            }
            return this.noneTypeRef;
        }
        return (TypeRef)Option.of((Object)this.env.elements().getTypeElement(ref.canonicalName())).map(Element::asType).map(this::typeRef).getOrElse(() -> this.noneTypeRef);
    }

    @Nonnull
    private TypeRef typeRef(TypeMirror t) {
        return this.env.typeRef(t);
    }

    public CElement<Element, TypeRef> classElement(TypeRef type) {
        DeclaredType declaredType = Elements.asDeclaredType(type.mirror());
        TypeElement element = Elements.asElement(declaredType);
        CElement.Builder<Element, TypeRef> classElem = this.celement(_CElement.Kind.CLASS, declaredType, element);
        if (element.getEnclosingElement() instanceof TypeElement) {
            classElem.parent(this.classElement(this.typeRef(element.getEnclosingElement().asType())));
        } else if (element.getEnclosingElement() instanceof ExecutableElement) {
            classElem.parent(this.methodCElement(Elements.asDeclaredType(element.getEnclosingElement().getEnclosingElement().asType()), (ExecutableElement)((Object)element)));
        }
        return classElem.build();
    }

    public Seq<? extends TypeRef> superTypes(TypeRef type) {
        return Vector.ofAll(this.env.types().directSupertypes(type.mirror())).map(this::typeRef);
    }

    public Seq<CElement<Element, TypeRef>> declaredMethods(TypeRef type) {
        return this.executables(type, e -> !INIT_RE.matcher(e.getSimpleName().toString()).matches());
    }

    public Seq<CElement<Element, TypeRef>> constructors(TypeRef type) {
        return this.executables(type, e -> e.getSimpleName().toString().equals(CONSTRUCTOR_NAME)).map(m -> m.withType((Object)this.noneTypeRef));
    }

    private Seq<CElement<Element, TypeRef>> executables(TypeRef type, Predicate<? super ExecutableElement> filter) {
        DeclaredType declaredType = Elements.asDeclaredType(type.mirror());
        return (Seq)declaredType.asElement().getEnclosedElements().stream().filter(ExecutableElement.class::isInstance).map(Elements::asExecutableElement).filter(filter).map(e -> this.methodCElement(declaredType, (ExecutableElement)e)).collect(Vector.collector());
    }

    public String packageOf(CElement<Element, TypeRef> element) {
        return this.env.elements().getPackageOf((Element)element.source()).getQualifiedName().toString();
    }

    public TypeRef iterableOf(TypeRef componentType) {
        return this.typeRef(this.env.types().getDeclaredType(Elements.asTypeElement(this.env.known().iterable().asElement()), componentType.mirror()));
    }

    public TypeRef collectionOf(TypeRef componentType) {
        return this.typeRef(this.env.types().getDeclaredType(Elements.asTypeElement(this.env.known().collection().asElement()), componentType.mirror()));
    }

    public TypeRef listOf(TypeRef componentType) {
        return this.typeRef(this.env.types().getDeclaredType(Elements.asTypeElement(this.env.known().list().asElement()), componentType.mirror()));
    }

    public TypeRef componentTypeOfIterable(TypeRef iterableType) {
        return (TypeRef)Option.some((Object)iterableType.mirror()).filter(DeclaredType.class::isInstance).map(DeclaredType.class::cast).flatMap(this::findIterable).map(t -> this.typeRef(t.getTypeArguments().get(0))).getOrElse(() -> this.noneTypeRef);
    }

    public TypeRef noType() {
        return this.noneTypeRef;
    }

    public void message(Message<Element, TypeRef> message) {
        this.message(0, message);
    }

    private void message(int depth, Message<Element, TypeRef> message) {
        StringBuilder buf = new StringBuilder();
        if (this.includeMessageId) {
            Diagnostics.appendMessageId(buf, message);
        }
        if (depth == 1) {
            buf.append("Origin of previous message: ");
        } else if (depth > 1) {
            buf.append("Origin (").append(depth).append(") of previous message: ");
        }
        buf.append(message.renderMessage(Object::toString));
        Iterator.unfoldLeft((Object)((Element)message.element().source()), e -> {
            if (e == null) {
                return Option.none();
            }
            if (e instanceof TypeElement) {
                buf.append("\nClass: ").append(((TypeElement)e).getQualifiedName());
                return Option.none();
            }
            if (e instanceof ExecutableElement) {
                buf.append("\nMethod: ").append(e.getSimpleName()).append("()");
            } else if (e instanceof VariableElement) {
                buf.append("\nParameter: ").append(e.getSimpleName());
            }
            return Option.some((Object)Tuple.of((Object)e.getEnclosingElement(), (Object)e));
        });
        Diagnostic.Kind diagnosticKind = (Diagnostic.Kind)((Object)message.id().map(id -> id.warning() ? Diagnostic.Kind.WARNING : Diagnostic.Kind.ERROR).getOrElse((Object)Diagnostic.Kind.OTHER));
        if (diagnosticKind == Diagnostic.Kind.ERROR) {
            ++this.errorCount;
        } else if (diagnosticKind == Diagnostic.Kind.WARNING || diagnosticKind == Diagnostic.Kind.MANDATORY_WARNING) {
            ++this.warningCount;
        }
        this.env.procEnv().getMessager().printMessage(diagnosticKind, buf, (Element)message.element().source());
        message.origins().forEach(o -> this.message(depth + 1, (Message<Element, TypeRef>)o));
    }

    private Option<DeclaredType> findIterable(DeclaredType from) {
        if (this.env.types().erasure(from).equals(this.env.types().erasure(this.env.known().iterable()))) {
            return Option.some((Object)from);
        }
        Vector superTypes = Vector.ofAll(this.env.types().directSupertypes(from)).map(Elements::asDeclaredType);
        return superTypes.reject(t -> t.equals(this.env.known().object())).filter(t -> this.env.types().erasure((TypeMirror)t).equals(this.env.types().erasure(this.env.known().iterable()))).map(Elements::asDeclaredType).headOption().orElse(() -> (Option)superTypes.map(this::findIterable).filter(Option::isDefined).headOption().getOrElse((Object)Option.none()));
    }

    private CElement<Element, TypeRef> methodCElement(DeclaredType enclosing, ExecutableElement element) {
        ExecutableType methodType = Elements.isStatic(element) ? Elements.asExecutableType(element.asType()) : Elements.asExecutableType(this.env.types().asMemberOf(enclosing, element));
        return (CElement)Option.some(this.celement(_CElement.Kind.METHOD, methodType.getReturnType(), element)).peek(e -> e.parent(this.classElement(this.typeRef(enclosing)))).map(CElement.Builder::build).map(m -> m.withParameters((Seq)Vector.ofAll(methodType.getParameterTypes()).zip(element.getParameters()).map(t -> this.celement(_CElement.Kind.PARAMETER, (TypeMirror)t._1(), (Element)t._2())).map(CElement.Builder::build))).get();
    }

    private CElement.Builder<Element, TypeRef> celement(_CElement.Kind kind, TypeMirror type, Element element) {
        CElement.Builder builder = CElement.builder().kind(kind).source((Object)element).type((Object)this.typeRef(type));
        if (kind == _CElement.Kind.CLASS) {
            builder.name(Iterator.unfoldLeft((Object)element, e -> Option.some((Object)e).filter(TypeElement.class::isInstance).map(e2 -> Tuple.of((Object)e.getEnclosingElement(), (Object)e2.getSimpleName().toString()))).mkString((CharSequence)"."));
        } else {
            builder.name(element.getSimpleName().toString());
        }
        this.celementModifiers((CElement.Builder<Element, TypeRef>)builder, element);
        this.celementConfigs((CElement.Builder<Element, TypeRef>)builder, element);
        return builder;
    }

    private CElement.Builder<Element, TypeRef> celementModifiers(CElement.Builder<Element, TypeRef> builder, Element element) {
        Set<Modifier> mods = element.getModifiers();
        if (mods.contains((Object)Modifier.PRIVATE)) {
            builder.accessPolicy(AccessPolicy.PRIVATE);
        } else if (mods.contains((Object)Modifier.PROTECTED)) {
            builder.accessPolicy(AccessPolicy.PROTECTED);
        } else if (mods.contains((Object)Modifier.PUBLIC)) {
            builder.accessPolicy(AccessPolicy.PUBLIC);
        } else {
            builder.accessPolicy(AccessPolicy.LOCAL);
        }
        builder.isStatic(mods.contains((Object)Modifier.STATIC));
        builder.isFinal(mods.contains((Object)Modifier.FINAL) || mods.contains((Object)Modifier.NATIVE));
        builder.isAbstract(mods.contains((Object)Modifier.ABSTRACT));
        return builder;
    }

    private void celementConfigs(CElement.Builder<Element, TypeRef> builder, Element element) {
        element.getAnnotationMirrors().stream().map(a -> {
            SetupConfig config = null;
            Map<? extends ExecutableElement, ? extends AnnotationValue> v = this.env.elements().getElementValuesWithDefaults((AnnotationMirror)a);
            Element t = a.getAnnotationType().asElement();
            if (t.equals(this.env.known().configuration().asElement())) {
                config = ConfigurationConfig.builder().source((Object)element).mount(this.requireListArg(v, this.env.known().configurationMount(), TypeMirror.class).map(this.env::classRef)).packageLocal(((Boolean)this.requireArg(v, this.env.known().configurationPackageLocal())).booleanValue()).shellName((String)this.requireArg(v, this.env.known().configurationShellName())).build();
            } else if (t.equals(this.env.known().setup().asElement())) {
                config = SetupConfig.builder().source((Object)element).build();
            } else if (t.equals(this.env.known().parameter().asElement())) {
                config = ParameterConfig.builder().source((Object)element).value((String)this.requireArg(v, this.env.known().parameterValue())).absolute(((Boolean)this.requireArg(v, this.env.known().parameterAbsolute())).booleanValue()).build();
            } else if (t.equals(this.env.known().parameterPrefix().asElement())) {
                config = ParameterPrefixConfig.builder().source((Object)element).value((String)this.requireArg(v, this.env.known().parameterPrefixValue())).build();
            } else if (t.equals(this.env.known().extensionPointAcceptor().asElement())) {
                config = ExtensionPointAcceptorConfig.builder().source((Object)element).build();
            } else if (t.equals(this.env.known().extensionPoint().asElement())) {
                config = ExtensionPointConfig.builder().source((Object)element).build();
            } else if (t.equals(this.env.known().feature().asElement())) {
                config = FeatureConfig.builder().source((Object)element).build();
            } else if (t.equals(this.env.known().featureMount().asElement())) {
                config = MountConfig.builder().source((Object)element).injected(((Boolean)this.requireArg(v, this.env.known().featureMountInjected())).booleanValue()).build();
            } else if (t.equals(this.env.known().provision().asElement())) {
                config = ProvisionConfig.builder().source((Object)element).shared(((Boolean)this.requireArg(v, this.env.known().provisionShared())).booleanValue()).override(((Boolean)this.requireArg(v, this.env.known().provisionOverride())).booleanValue()).build();
            }
            return Option.of((Object)config);
        }).forEach(o -> o.forEach(arg_0 -> ((CElement.Builder)builder).addConfigs(arg_0)));
    }

    private Object requireArg(Map<? extends ExecutableElement, ? extends AnnotationValue> values, ExecutableElement arg) {
        return Objects.requireNonNull(values.get(arg), "values.get(" + arg + ")").getValue();
    }

    private <T> Seq<T> requireListArg(Map<? extends ExecutableElement, ? extends AnnotationValue> values, ExecutableElement arg, Class<T> elementType) {
        return (Seq)((List)Objects.requireNonNull(values.get(arg), "values.get(" + arg + ")").getValue()).stream().map(v -> elementType.cast(Objects.requireNonNull(v.getValue(), "v.getValue()"))).collect(Vector.collector());
    }
}

