/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.processor.env;

import ch.raffael.meldioc.model.ClassRef;
import ch.raffael.meldioc.model.Model;
import ch.raffael.meldioc.model._ClassRef;
import ch.raffael.meldioc.processor.TypeRef;
import ch.raffael.meldioc.processor.env.Adaptor;
import ch.raffael.meldioc.processor.env.KnownElements;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public final class Environment {
    private final ProcessingEnvironment procEnv;
    private final KnownElements known;
    private final Adaptor adaptor;
    private final Model<Element, TypeRef> model;

    public Environment(ProcessingEnvironment procEnv, boolean includeMessageId) {
        this.procEnv = procEnv;
        this.known = new KnownElements(this);
        this.adaptor = new Adaptor(this, includeMessageId);
        this.model = Model.create((ch.raffael.meldioc.model.Adaptor)this.adaptor);
    }

    public ProcessingEnvironment procEnv() {
        return this.procEnv;
    }

    public KnownElements known() {
        return this.known;
    }

    public Adaptor adaptor() {
        return this.adaptor;
    }

    public Elements elements() {
        return this.procEnv().getElementUtils();
    }

    public Types types() {
        return this.procEnv().getTypeUtils();
    }

    public Model<Element, TypeRef> model() {
        return this.model;
    }

    public TypeRef typeRef(TypeMirror mirror) {
        return new TypeRef(this.types(), mirror);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ClassRef classRef(TypeMirror mirror) {
        switch (mirror.getKind()) {
            case BOOLEAN: {
                return _ClassRef.Primitives.BOOLEAN;
            }
            case BYTE: {
                return _ClassRef.Primitives.BYTE;
            }
            case SHORT: {
                return _ClassRef.Primitives.SHORT;
            }
            case INT: {
                return _ClassRef.Primitives.INT;
            }
            case LONG: {
                return _ClassRef.Primitives.LONG;
            }
            case CHAR: {
                return _ClassRef.Primitives.CHAR;
            }
            case FLOAT: {
                return _ClassRef.Primitives.FLOAT;
            }
            case DOUBLE: {
                return _ClassRef.Primitives.DOUBLE;
            }
            case VOID: {
                return _ClassRef.Primitives.VOID;
            }
            case ARRAY: {
                return this.classRef(((ArrayType)mirror).getComponentType()).asArray();
            }
            case DECLARED: 
            case ERROR: {
                TypeElement e = (TypeElement)((DeclaredType)mirror).asElement();
                StringBuilder n = new StringBuilder();
                while (true) {
                    if (n.length() > 0) {
                        n.insert(0, '.');
                    }
                    n.insert(0, e.getSimpleName());
                    if (e.getEnclosingElement() == null || e.getEnclosingElement() instanceof PackageElement) return ClassRef.of((String)this.elements().getPackageOf(e).getQualifiedName().toString(), (String)n.toString());
                    if (!(e.getEnclosingElement() instanceof TypeElement)) throw new IllegalStateException("Unexpected enclosing element: " + e.getEnclosingElement());
                    e = (TypeElement)e.getEnclosingElement();
                }
            }
        }
        throw new IllegalArgumentException("Cannot build ClassRef from type " + mirror);
    }

    public static abstract class WithEnv {
        protected final Environment env;

        protected WithEnv(Environment env) {
            this.env = env;
        }
    }
}

