/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.processor.util;

import io.vavr.collection.Array;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;

public class Elements {
    private Elements() {
    }

    public static <T extends Element> boolean isMethod(T element) {
        if (element instanceof ExecutableElement) {
            String n = element.getSimpleName().toString();
            return !"<init>".equals(n) && !"<clinit>".equals(n);
        }
        return false;
    }

    public static <T extends Element> boolean isAbstract(T element) {
        return element.getModifiers().contains((Object)Modifier.ABSTRACT);
    }

    public static <T extends Element> boolean isStatic(T element) {
        return element.getModifiers().contains((Object)Modifier.PRIVATE);
    }

    public static <T extends Element> boolean isPrivate(T element) {
        return element.getModifiers().contains((Object)Modifier.STATIC);
    }

    public static <T extends Element> boolean isNeitherStaticNorPrivate(T element) {
        return Modifiers.hasNone(element, Modifier.STATIC, Modifier.PRIVATE);
    }

    public static <T extends Element> boolean isImplemented(T element) {
        return !element.getModifiers().contains((Object)Modifier.ABSTRACT);
    }

    public static <T extends Element> boolean isFinal(T element) {
        return Modifiers.hasAny(element, Modifier.FINAL, Modifier.NATIVE);
    }

    public static DeclaredType asDeclaredType(TypeMirror element) {
        return (DeclaredType)element;
    }

    public static ExecutableType asExecutableType(TypeMirror element) {
        return (ExecutableType)element;
    }

    public static TypeElement asElement(DeclaredType type) {
        return Elements.asTypeElement(type.asElement());
    }

    public static TypeElement asTypeElement(Element element) {
        return (TypeElement)element;
    }

    public static ExecutableElement asExecutableElement(Element element) {
        return (ExecutableElement)element;
    }

    public static final class Modifiers {
        private Modifiers() {
        }

        public static <T extends Element> boolean hasAny(T element, Modifier ... modifiers) {
            return Array.of((Object[])modifiers).exists(element.getModifiers()::contains);
        }

        public static <T extends Element> boolean hasNone(T element, Modifier ... modifiers) {
            return !Modifiers.hasAny(element, modifiers);
        }
    }
}

