/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.processor;

import ch.raffael.meldioc.processor.env.Environment;
import ch.raffael.meldioc.processor.util.Elements;
import io.vavr.collection.LinkedHashSet;
import io.vavr.collection.List;
import io.vavr.collection.Set;
import io.vavr.collection.Traversable;
import io.vavr.control.Option;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

final class CatchHelper
extends Environment.WithEnv {
    private Set<DeclaredType> declared = LinkedHashSet.empty();
    private boolean catchAll = false;

    CatchHelper(Environment env) {
        super(env);
    }

    CatchHelper add(Stream<? extends TypeMirror> add) {
        add.forEach(this::add);
        return this;
    }

    CatchHelper add(TypeMirror add) {
        if (!(add instanceof DeclaredType)) {
            throw new IllegalArgumentException("Executable type expected: add=" + String.valueOf(add));
        }
        if (this.catchAll) {
            return this;
        }
        if (this.env.types().isSameType(add, this.env.known().throwable())) {
            this.catchAll = true;
            this.declared = LinkedHashSet.of((Object)this.env.known().throwable());
            return this;
        }
        if (this.isUnchecked(Elements.asDeclaredType(add))) {
            return this;
        }
        this.declared = this.declared.reject(t -> this.env.types().isSubtype((TypeMirror)t, add));
        if (!this.declared.exists(t -> this.env.types().isSubtype(add, (TypeMirror)t))) {
            this.declared = this.declared.add((Object)Elements.asDeclaredType(add));
        }
        return this;
    }

    boolean catchAll() {
        return this.catchAll;
    }

    CatchHelper withChecked(Consumer<? super Traversable<? super DeclaredType>> consumer) {
        if (this.declared.nonEmpty()) {
            consumer.accept((Traversable<? super DeclaredType>)this.declared);
        }
        return this;
    }

    CatchHelper forEachChecked(Consumer<? super DeclaredType> consumer) {
        this.declared.forEach(consumer);
        return this;
    }

    CatchHelper withUnchecked(Consumer<? super Traversable<? super DeclaredType>> consumer) {
        Option.of(this.unchecked()).filter(Traversable::nonEmpty).forEach(consumer);
        return this;
    }

    CatchHelper forEachUnchecked(Consumer<? super DeclaredType> consumer) {
        this.unchecked().forEach(consumer);
        return this;
    }

    CatchHelper withAll(Consumer<? super Traversable<? super DeclaredType>> consumer) {
        Option.of(this.all()).filter(Traversable::nonEmpty).forEach(consumer);
        return this;
    }

    CatchHelper forAll(Consumer<? super DeclaredType> consumer) {
        this.all().forEach(consumer);
        return this;
    }

    CatchHelper ifUnhandled(DeclaredType t, Runnable then) {
        if (!this.isUnchecked(t) || this.declared.exists(h -> this.env.types().isSubtype(t, (TypeMirror)h))) {
            then.run();
        }
        return this;
    }

    CatchHelper catchAll(Runnable then) {
        this.ifUnhandled(this.env.known().throwable(), then);
        return this;
    }

    Traversable<DeclaredType> checked() {
        return this.declared;
    }

    Traversable<DeclaredType> unchecked() {
        return List.of((Object[])new DeclaredType[]{this.env.known().runtimeException(), this.env.known().error()}).filter(t -> !this.declared.exists(h -> this.env.types().isSubtype((TypeMirror)t, (TypeMirror)h)));
    }

    Traversable<DeclaredType> all() {
        return this.declared.addAll(this.unchecked());
    }

    private boolean isUnchecked(DeclaredType t) {
        return this.env.types().isSubtype(t, this.env.known().runtimeException()) || this.env.types().isSubtype(t, this.env.known().error());
    }
}

