/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.processor;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

public class Debug {
    public static final boolean DEVEL_MODE = false;
    private static Path work;

    public static void main(String[] args) throws Exception {
        work = Paths.get(args[0].replace('/', File.separatorChar), new String[0]);
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
        String classOut = Debug.prepareOutput("classes");
        String srcOut = Debug.prepareOutput("gensrc");
        List<String> options = Arrays.asList("-d", classOut, "-s", srcOut, "-Ach.raffael.meldioc.generateOnErrors=true", "-cp", Files.lines(work.resolve("classpath.list")).map(String::trim).filter(l -> !l.isEmpty()).collect(Collectors.joining(System.getProperty("path.separator"))));
        Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromFiles(Files.lines(work.resolve("sources.list")).map(String::trim).filter(l -> !l.isEmpty()).map(File::new).collect(Collectors.toList()));
        compiler.getTask(null, fileManager, null, options, null, compilationUnits).call();
        fileManager.close();
    }

    private static String prepareOutput(String n) throws IOException {
        Path p = work.resolve(n);
        if (Files.exists(p, new LinkOption[0])) {
            Files.walkFileTree(p, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return super.visitFile(file, attrs);
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return super.postVisitDirectory(dir, exc);
                }
            });
        }
        Files.createDirectories(p, new FileAttribute[0]);
        return p.toString();
    }
}

