/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.processor;

import ch.raffael.meldioc.Configuration;
import ch.raffael.meldioc.ExtensionPoint;
import ch.raffael.meldioc.Feature;
import ch.raffael.meldioc.Parameter;
import ch.raffael.meldioc.Provision;
import ch.raffael.meldioc.Setup;
import ch.raffael.meldioc.meta.Generated;
import ch.raffael.meldioc.processor.Generator;
import ch.raffael.meldioc.processor.env.Environment;
import io.vavr.collection.List;
import io.vavr.collection.Set;
import io.vavr.control.Option;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Optional;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SupportedSourceVersion(value=SourceVersion.RELEASE_11)
@SupportedAnnotationTypes(value={"ch.raffael.meldioc.Configuration", "ch.raffael.meldioc.Feature", "ch.raffael.meldioc.Feature.Mount", "ch.raffael.meldioc.Feature.DependsOn", "ch.raffael.meldioc.Feature.Import", "ch.raffael.meldioc.Provision", "ch.raffael.meldioc.ExtensionPoint", "ch.raffael.meldioc.ExtensionPoint.Acceptor", "ch.raffael.meldioc.Setup", "ch.raffael.meldioc.Parameter", "ch.raffael.meldioc.Parameter.Prefix"})
@SupportedOptions(value={"ch.raffael.meldioc.includeMessageId"})
public class MeldProcessor
extends AbstractProcessor {
    public static final String OPT_INCLUDE_MSG_ID = "ch.raffael.meldioc.includeMessageId";
    public static final String OPT_GENERATE_ON_ERRORS = "ch.raffael.meldioc.generateOnErrors";
    public static final String OPT_VERBOSE = "ch.raffael.meldioc.verbose";
    private static final String LANG_VERSION_PREFIX = "RELEASE_";
    private static final Set<String> OLD_LANG_VERSIONS = List.rangeClosed((int)0, (int)10).map(v -> LANG_VERSION_PREFIX + v).toSet();
    private static final Set<String> KNOWN_LANG_VERSIONS = List.rangeClosed((int)11, (int)19).map(v -> LANG_VERSION_PREFIX + v).toSet();

    @Override
    public boolean process(@NotNull java.util.Set<? extends TypeElement> annotations, @NotNull RoundEnvironment roundEnv) {
        if (OLD_LANG_VERSIONS.contains((Object)this.processingEnv.getSourceVersion().name())) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Language version too old: " + String.valueOf(OLD_LANG_VERSIONS));
            return true;
        }
        if (!KNOWN_LANG_VERSIONS.contains((Object)this.processingEnv.getSourceVersion().name())) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Unknown language version " + this.processingEnv.getSourceVersion().name() + "; some constructs may cause unpredictable behaviour");
        }
        Environment env = new Environment(this.processingEnv, (Boolean)Option.of((Object)this.processingEnv.getOptions().get(OPT_INCLUDE_MSG_ID)).map(v -> v.equals(String.valueOf(true))).getOrElse((Object)false));
        Optional<TypeElement> configurationAnnotation = annotations.stream().filter(e -> e.getQualifiedName().toString().equals(Configuration.class.getCanonicalName())).findAny();
        this.validateParticipants(annotations, roundEnv, env, configurationAnnotation);
        configurationAnnotation.ifPresent(a -> roundEnv.getElementsAnnotatedWith((TypeElement)a).forEach(elem -> this.generateConfigurationShell(env, (Element)elem)));
        return true;
    }

    private Optional<TypeElement> findTypeElement(@Nullable Element elem) {
        while (elem != null && !(elem instanceof TypeElement)) {
            elem = elem.getEnclosingElement();
        }
        return Optional.ofNullable((TypeElement)elem);
    }

    private void validateParticipants(java.util.Set<? extends TypeElement> annotations, RoundEnvironment roundEnv, Environment env, Optional<? extends TypeElement> configurationAnnotation) {
        annotations.stream().filter(e -> configurationAnnotation.map(asm -> !asm.equals(e)).orElse(true)).flatMap(e -> roundEnv.getElementsAnnotatedWith((TypeElement)e).stream()).map(this::findTypeElement).flatMap(Optional::stream).filter(e -> configurationAnnotation.map(asm -> e.getAnnotationMirrors().stream().noneMatch(a -> asm.equals(e))).orElse(true)).distinct().forEach(e -> env.model().modelOf((Object)env.typeRef(e.asType())));
    }

    private void generateConfigurationShell(Environment env, Element element) {
        try {
            if (element instanceof TypeElement && element.getAnnotation(Generated.class) == null) {
                this.writeSourceFile(new Generator(MeldProcessor.class, env, (TypeElement)element));
            } else {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Expected a class", element);
            }
        }
        catch (Generator.Abort e) {
            if ("true".equals(this.processingEnv.getOptions().get(OPT_VERBOSE))) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "[meld] Code generation for " + String.valueOf(element) + " aborted: " + this.stackTrace(e));
            }
        }
        catch (AssertionError | Exception e) {
            this.reportFatal(element, (Throwable)e);
        }
    }

    private void writeSourceFile(Generator generator) {
        if (generator.errorCount() > 0) {
            if ("true".equals(this.processingEnv.getOptions().get(OPT_GENERATE_ON_ERRORS))) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "[meld] Generating " + generator.targetClassName() + " in spite of " + generator.errorCount() + " errors (and " + generator.warningCount() + " warnings): ch.raffael.meldioc.generateOnErrors is set to true");
            } else if ("true".equals(this.processingEnv.getOptions().get(OPT_VERBOSE))) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "[meld] Generating " + generator.targetClassName());
            } else {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "[meld] Not generating " + generator.targetClassName() + " because there were " + generator.errorCount() + " errors (and " + generator.warningCount() + " warnings)");
                return;
            }
        }
        try {
            String source = generator.generate();
            JavaFileObject out = this.processingEnv.getFiler().createSourceFile(generator.targetClassName(), generator.sourceElement());
            try (Writer writer = out.openWriter();){
                writer.write(source);
            }
        }
        catch (IOException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Cannot write source file for " + generator.targetClassName() + ": " + e.getLocalizedMessage());
        }
    }

    private void reportFatal(Element element, Throwable e) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Fatal: " + this.stackTrace(e), element);
    }

    private String stackTrace(Throwable e) {
        StringWriter out = new StringWriter();
        PrintWriter print = new PrintWriter(out);
        e.printStackTrace(print);
        print.close();
        return out.toString();
    }

    @Override
    public java.util.Set<String> getSupportedOptions() {
        return java.util.Set.of();
    }

    @Override
    public java.util.Set<String> getSupportedAnnotationTypes() {
        return java.util.Set.of(Configuration.class.getCanonicalName(), Setup.class.getCanonicalName(), Parameter.class.getCanonicalName(), Parameter.Prefix.class.getCanonicalName(), ExtensionPoint.class.getCanonicalName(), ExtensionPoint.class.getCanonicalName() + ".Acceptor", Feature.class.getCanonicalName(), Feature.Mount.class.getCanonicalName(), Feature.DependsOn.class.getCanonicalName(), Provision.class.getCanonicalName());
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }
}

