/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.processor.env;

import ch.raffael.meldioc.model.AccessPolicy;
import ch.raffael.meldioc.model.Adaptor;
import ch.raffael.meldioc.model.ClassRef;
import ch.raffael.meldioc.model.SrcElement;
import ch.raffael.meldioc.model.config.ConfigurationConfig;
import ch.raffael.meldioc.model.config.ExtensionPointConfig;
import ch.raffael.meldioc.model.config.FeatureConfig;
import ch.raffael.meldioc.model.config.MountConfig;
import ch.raffael.meldioc.model.config.ParameterConfig;
import ch.raffael.meldioc.model.config.ParameterPrefixConfig;
import ch.raffael.meldioc.model.config.ProvisionConfig;
import ch.raffael.meldioc.model.config.SetupConfig;
import ch.raffael.meldioc.model.messages.Message;
import ch.raffael.meldioc.model.messages.MessageSink;
import ch.raffael.meldioc.processor.Diagnostics;
import ch.raffael.meldioc.processor.TypeRef;
import ch.raffael.meldioc.processor.env.Environment;
import ch.raffael.meldioc.processor.util.Elements;
import io.vavr.CheckedFunction0;
import io.vavr.Tuple;
import io.vavr.Value;
import io.vavr.collection.Iterator;
import io.vavr.collection.Seq;
import io.vavr.collection.Traversable;
import io.vavr.collection.Vector;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.tools.Diagnostic;

public final class Adaptor
extends Environment.WithEnv
implements ch.raffael.meldioc.model.Adaptor<Element, TypeRef>,
MessageSink<Element, TypeRef> {
    private static final Pattern INIT_RE = Pattern.compile("<(cl)?init>");
    private static final String CONSTRUCTOR_NAME = "<init>";
    private static final Option<ElementKind> RECORD_ELEMENT_KIND = (Option)Try.of((CheckedFunction0 & Serializable)() -> Option.some((Object)((Object)ElementKind.valueOf("RECORD")))).recover(IllegalArgumentException.class, (Object)Option.none()).get();
    private static final Option<Modifier> OPT_MOD_SEALED = (Option)Try.of((CheckedFunction0 & Serializable)() -> Option.some((Object)((Object)Modifier.valueOf("SEALED")))).recover(IllegalArgumentException.class, (Object)Option.none()).get();
    private final boolean includeMessageId;
    private final TypeRef noneTypeRef;
    private int errorCount = 0;
    private int warningCount = 0;

    Adaptor(Environment env, boolean includeMessageId) {
        super(env);
        this.includeMessageId = includeMessageId;
        this.noneTypeRef = this.typeRef(env.types().getNoType(TypeKind.NONE));
    }

    public int errorCount() {
        return this.errorCount;
    }

    public int warningCount() {
        return this.warningCount;
    }

    public boolean isSubtypeOf(TypeRef left, TypeRef right) {
        if (left.mirror().getKind().isPrimitive() || right.mirror().getKind().isPrimitive()) {
            return left.mirror().getKind() == right.mirror().getKind();
        }
        return this.env.types().isSubtype(left.mirror(), right.mirror());
    }

    public boolean isReference(TypeRef type) {
        return type.mirror() instanceof DeclaredType || type.mirror() instanceof TypeVariable;
    }

    public boolean isInterface(TypeRef type) {
        if (type.mirror() instanceof DeclaredType) {
            return ((DeclaredType)type.mirror()).asElement().getKind() == ElementKind.INTERFACE;
        }
        return false;
    }

    public boolean hasTypeParameters(TypeRef type) {
        if (this.isNoType(type)) {
            return false;
        }
        return type.mirror() instanceof DeclaredType && !((TypeElement)((DeclaredType)type.mirror()).asElement()).getTypeParameters().isEmpty();
    }

    public boolean isPrimitive(TypeRef type) {
        return type.mirror() instanceof PrimitiveType;
    }

    public boolean isEnumType(TypeRef type) {
        return this.isElementKind(type, ElementKind.ENUM);
    }

    public boolean isAnnotationType(TypeRef type) {
        return this.isElementKind(type, ElementKind.ANNOTATION_TYPE);
    }

    public boolean isRecordType(TypeRef type) {
        return (Boolean)RECORD_ELEMENT_KIND.map(k -> this.isElementKind(type, (ElementKind)((Object)k))).getOrElse((Object)false);
    }

    private boolean isElementKind(TypeRef type, ElementKind kind) {
        TypeMirror mirror = this.env.types().erasure(type.mirror());
        if (!(mirror instanceof DeclaredType)) {
            return false;
        }
        return ((DeclaredType)mirror).asElement().getKind() == kind;
    }

    public TypeRef typeOf(ClassRef ref) {
        if (ref.isPrimitive()) {
            switch (ref.className()) {
                case "int": {
                    return this.typeRef(this.env.types().getPrimitiveType(TypeKind.INT));
                }
                case "long": {
                    return this.typeRef(this.env.types().getPrimitiveType(TypeKind.LONG));
                }
                case "short": {
                    return this.typeRef(this.env.types().getPrimitiveType(TypeKind.SHORT));
                }
                case "byte": {
                    return this.typeRef(this.env.types().getPrimitiveType(TypeKind.BYTE));
                }
                case "double": {
                    return this.typeRef(this.env.types().getPrimitiveType(TypeKind.DOUBLE));
                }
                case "float": {
                    return this.typeRef(this.env.types().getPrimitiveType(TypeKind.FLOAT));
                }
                case "char": {
                    return this.typeRef(this.env.types().getPrimitiveType(TypeKind.CHAR));
                }
                case "boolean": {
                    return this.typeRef(this.env.types().getPrimitiveType(TypeKind.BOOLEAN));
                }
                case "void": {
                    return this.typeRef(this.env.types().getPrimitiveType(TypeKind.VOID));
                }
            }
            return this.noneTypeRef;
        }
        return (TypeRef)Option.of((Object)this.env.elements().getTypeElement(ref.canonicalName())).map(Element::asType).map(this::typeRef).getOrElse(() -> this.noneTypeRef);
    }

    private TypeRef typeRef(TypeMirror t) {
        return this.env.typeRef(t);
    }

    public SrcElement<Element, TypeRef> classElement(TypeRef type) {
        DeclaredType declaredType = Elements.asDeclaredType(type.mirror());
        TypeElement element = Elements.asElement(declaredType);
        SrcElement.Builder<Element, TypeRef> classElem = this.srcElement(SrcElement.Kind.CLASS, declaredType, element);
        if (element.getEnclosingElement() instanceof TypeElement) {
            classElem.parent(this.classElement(this.typeRef(element.getEnclosingElement().asType())));
        } else if (element.getEnclosingElement() instanceof ExecutableElement) {
            classElem.parent(this.methodSrcElement(Elements.asDeclaredType(element.getEnclosingElement().getEnclosingElement().asType()), (ExecutableElement)((Object)element)));
        }
        return classElem.build();
    }

    public Seq<Adaptor.SuperType<TypeRef>> superTypes(TypeRef type) {
        return Vector.ofAll(this.env.types().directSupertypes(type.mirror())).map(t -> {
            List<? extends AnnotationMirror> annotations = t.getAnnotationMirrors();
            return new Adaptor.SuperType((Object)this.typeRef((TypeMirror)t), annotations.stream().anyMatch(a -> this.env.types().isSameType(a.getAnnotationType(), this.env.known().importAnnotation())), annotations.stream().anyMatch(a -> this.env.types().isSameType(a.getAnnotationType(), this.env.known().dependsOnAnnotation())));
        });
    }

    public Seq<SrcElement<Element, TypeRef>> declaredMethods(TypeRef type) {
        return this.executables(type, e -> !INIT_RE.matcher(e.getSimpleName().toString()).matches());
    }

    public Seq<SrcElement<Element, TypeRef>> constructors(TypeRef type) {
        return this.executables(type, e -> e.getSimpleName().toString().equals(CONSTRUCTOR_NAME)).map(m -> m.withType((Object)this.noneTypeRef));
    }

    private Seq<SrcElement<Element, TypeRef>> executables(TypeRef type, Predicate<? super ExecutableElement> filter) {
        DeclaredType declaredType = Elements.asDeclaredType(type.mirror());
        return (Seq)declaredType.asElement().getEnclosedElements().stream().filter(ExecutableElement.class::isInstance).map(Elements::asExecutableElement).filter(filter).map(e -> this.methodSrcElement(declaredType, (ExecutableElement)e)).collect(Vector.collector());
    }

    public String packageOf(SrcElement<Element, TypeRef> element) {
        return this.env.elements().getPackageOf((Element)element.source()).getQualifiedName().toString();
    }

    public TypeRef iterableOf(TypeRef componentType) {
        return this.typeRef(this.env.types().getDeclaredType(Elements.asTypeElement(this.env.known().iterable().asElement()), componentType.mirror()));
    }

    public TypeRef collectionOf(TypeRef componentType) {
        return this.typeRef(this.env.types().getDeclaredType(Elements.asTypeElement(this.env.known().collection().asElement()), componentType.mirror()));
    }

    public TypeRef listOf(TypeRef componentType) {
        return this.typeRef(this.env.types().getDeclaredType(Elements.asTypeElement(this.env.known().list().asElement()), componentType.mirror()));
    }

    public TypeRef componentTypeOfIterable(TypeRef iterableType) {
        return (TypeRef)Option.some((Object)iterableType.mirror()).filter(DeclaredType.class::isInstance).map(DeclaredType.class::cast).flatMap(this::findIterable).map(t -> this.typeRef(t.getTypeArguments().get(0))).getOrElse(() -> this.noneTypeRef);
    }

    public TypeRef noType() {
        return this.noneTypeRef;
    }

    public void message(Message<Element, TypeRef> message) {
        this.message(0, message);
    }

    private void message(int depth, Message<Element, TypeRef> message) {
        if (this.isSuppressed(message)) {
            return;
        }
        StringBuilder buf = new StringBuilder();
        if (this.includeMessageId) {
            Diagnostics.appendMessageId(buf, message);
        }
        if (depth == 1) {
            buf.append("Origin of previous message: ");
        } else if (depth > 1) {
            buf.append("Origin (").append(depth).append(") of previous message: ");
        }
        buf.append(message.renderMessage((Function<Element, CharSequence>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Ljavax/lang/model/element/Element;)Ljava/lang/CharSequence;)()));
        Iterator.unfoldLeft((Object)((Element)message.element().source()), e -> {
            if (e == null) {
                return Option.none();
            }
            if (e instanceof TypeElement) {
                buf.append("\nClass: ").append(((TypeElement)e).getQualifiedName());
                return Option.none();
            }
            if (e instanceof ExecutableElement) {
                buf.append("\nMethod: ").append(e.getSimpleName()).append("()");
            } else if (e instanceof VariableElement) {
                buf.append("\nParameter: ").append(e.getSimpleName());
            }
            return Option.some((Object)Tuple.of((Object)e.getEnclosingElement(), (Object)e));
        });
        Diagnostic.Kind diagnosticKind = (Diagnostic.Kind)((Object)message.id().map(id -> id.warning() ? Diagnostic.Kind.WARNING : Diagnostic.Kind.ERROR).getOrElse((Object)Diagnostic.Kind.OTHER));
        if (diagnosticKind == Diagnostic.Kind.ERROR) {
            ++this.errorCount;
        } else if (diagnosticKind == Diagnostic.Kind.WARNING || diagnosticKind == Diagnostic.Kind.MANDATORY_WARNING) {
            ++this.warningCount;
        }
        this.env.procEnv().getMessager().printMessage(diagnosticKind, buf, (Element)message.element().source());
        message.origins().forEach(o -> this.message(depth + 1, (Message<Element, TypeRef>)o));
    }

    private Option<DeclaredType> findIterable(DeclaredType from) {
        if (this.env.types().erasure(from).equals(this.env.types().erasure(this.env.known().iterable()))) {
            return Option.some((Object)from);
        }
        Vector superTypes = Vector.ofAll(this.env.types().directSupertypes(from)).map(Elements::asDeclaredType);
        return superTypes.reject(t -> t.equals(this.env.known().object())).filter(t -> this.env.types().erasure((TypeMirror)t).equals(this.env.types().erasure(this.env.known().iterable()))).map(Elements::asDeclaredType).headOption().orElse(() -> (Option)superTypes.map(this::findIterable).filter(Option::isDefined).headOption().getOrElse((Object)Option.none()));
    }

    private SrcElement<Element, TypeRef> methodSrcElement(DeclaredType enclosing, ExecutableElement element) {
        ExecutableType methodType = Elements.isStatic(element) ? Elements.asExecutableType(element.asType()) : Elements.asExecutableType(this.env.types().asMemberOf(enclosing, element));
        return (SrcElement)Option.some(this.srcElement(SrcElement.Kind.METHOD, methodType.getReturnType(), element)).peek(e -> e.parent(this.classElement(this.typeRef(enclosing)))).peek(e -> e.exceptions((Seq)element.getThrownTypes().stream().map(t -> new TypeRef(this.env.types(), (TypeMirror)t)).collect(io.vavr.collection.List.collector()))).map(rec$ -> ((SrcElement.Builder)rec$).build()).map(m -> m.withParameters((Seq)Vector.ofAll(methodType.getParameterTypes()).zip(element.getParameters()).map(t -> this.srcElement(SrcElement.Kind.PARAMETER, (TypeMirror)t._1(), (Element)t._2())).map(rec$ -> ((SrcElement.Builder)rec$).build()))).get();
    }

    private SrcElement.Builder<Element, TypeRef> srcElement(SrcElement.Kind kind, TypeMirror type, Element element) {
        SrcElement.Builder builder = SrcElement.builder().kind(kind).source((Object)element).type((Object)this.typeRef(type));
        if (kind == SrcElement.Kind.CLASS) {
            builder.name(Iterator.unfoldLeft((Object)element, e -> Option.some((Object)e).filter(TypeElement.class::isInstance).map(e2 -> Tuple.of((Object)e.getEnclosingElement(), (Object)e2.getSimpleName().toString()))).mkString((CharSequence)"."));
        } else {
            builder.name(element.getSimpleName().toString());
        }
        this.srcElementModifiers((SrcElement.Builder<Element, TypeRef>)builder, element);
        this.srcElementConfigs((SrcElement.Builder<Element, TypeRef>)builder, element);
        return builder;
    }

    private SrcElement.Builder<Element, TypeRef> srcElementModifiers(SrcElement.Builder<Element, TypeRef> builder, Element element) {
        Set<Modifier> mods = element.getModifiers();
        if (mods.contains((Object)Modifier.PRIVATE)) {
            builder.accessPolicy(AccessPolicy.PRIVATE);
        } else if (mods.contains((Object)Modifier.PROTECTED)) {
            builder.accessPolicy(AccessPolicy.PROTECTED);
        } else if (mods.contains((Object)Modifier.PUBLIC)) {
            builder.accessPolicy(AccessPolicy.PUBLIC);
        } else {
            builder.accessPolicy(AccessPolicy.LOCAL);
        }
        builder.isStatic(mods.contains((Object)Modifier.STATIC));
        builder.isFinal(mods.contains((Object)Modifier.FINAL) || mods.contains((Object)Modifier.NATIVE));
        builder.isSealed(((Boolean)OPT_MOD_SEALED.map(mods::contains).getOrElse((Object)false)).booleanValue());
        builder.isAbstract(mods.contains((Object)Modifier.ABSTRACT));
        return builder;
    }

    private void srcElementConfigs(SrcElement.Builder<Element, TypeRef> builder, Element element) {
        io.vavr.collection.List allConfigs = (io.vavr.collection.List)element.getAnnotationMirrors().stream().map(a -> {
            SetupConfig config = null;
            Map<? extends ExecutableElement, ? extends AnnotationValue> v = this.env.elements().getElementValuesWithDefaults((AnnotationMirror)a);
            Element t = a.getAnnotationType().asElement();
            if (t.equals(this.env.known().configuration().asElement())) {
                config = ConfigurationConfig.builder().source((Object)element).mount(this.requireListArg(v, this.env.known().configurationMount(), TypeMirror.class).map(this.env::classRef)).packageLocal(((Boolean)this.requireArg(v, this.env.known().configurationPackageLocal())).booleanValue()).shellName((String)this.requireArg(v, this.env.known().configurationShellName())).build();
            } else if (t.equals(this.env.known().setup().asElement())) {
                config = SetupConfig.builder().source((Object)element).build();
            } else if (t.equals(this.env.known().parameter().asElement())) {
                config = ParameterConfig.builder().source((Object)element).value((String)this.requireArg(v, this.env.known().parameterValue())).absolute(((Boolean)this.requireArg(v, this.env.known().parameterAbsolute())).booleanValue()).build();
            } else if (t.equals(this.env.known().parameterPrefix().asElement())) {
                config = ParameterPrefixConfig.builder().source((Object)element).value((String)this.requireArg(v, this.env.known().parameterPrefixValue())).build();
            } else if (t.equals(this.env.known().extensionPointAcceptor().map(DeclaredType::asElement).getOrNull())) {
                config = ExtensionPointConfig.builder().source((Object)element).fromAcceptorAnnotation(true).build();
            } else if (t.equals(this.env.known().extensionPoint().asElement())) {
                config = ExtensionPointConfig.builder().source((Object)element).fromAcceptorAnnotation(false).build();
            } else if (t.equals(this.env.known().feature().asElement())) {
                config = FeatureConfig.builder().source((Object)element).build();
            } else if (t.equals(this.env.known().featureMount().asElement())) {
                config = MountConfig.builder().source((Object)element).injected(((Boolean)this.requireArg(v, this.env.known().featureMountInjected())).booleanValue()).build();
            } else if (t.equals(this.env.known().provision().asElement())) {
                config = ProvisionConfig.builder().source((Object)element).singleton(((Boolean)this.requireArg(v, this.env.known().provisionSingleton())).booleanValue()).override(((Boolean)this.requireArg(v, this.env.known().provisionOverride())).booleanValue()).build();
            }
            return Option.of((Object)config);
        }).flatMap(Value::toJavaStream).collect(io.vavr.collection.List.collector());
        allConfigs = (io.vavr.collection.List)ExtensionPointConfig.removeFromAcceptorIfApplicable((Traversable)allConfigs);
        builder.addAllConfigs((Iterable)allConfigs);
    }

    private Object requireArg(Map<? extends ExecutableElement, ? extends AnnotationValue> values, ExecutableElement arg) {
        return Objects.requireNonNull(values.get(arg), "values.get(" + String.valueOf(arg) + ")").getValue();
    }

    private <T> Seq<T> requireListArg(Map<? extends ExecutableElement, ? extends AnnotationValue> values, ExecutableElement arg, Class<T> elementType) {
        return (Seq)((List)Objects.requireNonNull(values.get(arg), "values.get(" + String.valueOf(arg) + ")").getValue()).stream().map(v -> elementType.cast(Objects.requireNonNull(v.getValue(), "v.getValue()"))).collect(Vector.collector());
    }

    private boolean isSuppressed(Message<Element, TypeRef> message) {
        if (message.id().isEmpty() || !((Message.Id)message.id().get()).warning()) {
            return false;
        }
        return this.isSuppressed((Message.Id)message.id().get(), (Element)message.element().source());
    }

    private boolean isSuppressed(Message.Id id, Element element) {
        boolean suppressed = element.getAnnotationMirrors().stream().filter(am -> am.getAnnotationType().equals(this.env.known().suppressWarnings())).map(am -> this.env.elements().getElementValuesWithDefaults((AnnotationMirror)am)).flatMap(v -> this.requireListArg((Map<? extends ExecutableElement, ? extends AnnotationValue>)v, this.env.known().suppressWarningsValue(), (Class)String.class).toJavaStream()).map(Message.Suppression::meldId).anyMatch(v -> Message.Suppression.all().equals(v) || id.equals(Message.Id.forName((String)v).getOrNull()));
        if (suppressed) {
            return true;
        }
        if (element.getKind() == ElementKind.PACKAGE) {
            return false;
        }
        Element enclosing = element.getEnclosingElement();
        return enclosing != null && this.isSuppressed(id, enclosing);
    }
}

