/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.util;

import io.vavr.API;
import io.vavr.Tuple2;
import io.vavr.control.Option;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Arrays;
import java.util.function.BiFunction;

public class IOStreams {
    public static final int DEFAULT_BUFFER_SIZE = 8192;

    private IOStreams() {
    }

    public static ByteArrayOutputStream readFully(InputStream stream, ByteArrayOutputStream target, byte[] readBuffer) throws IOException {
        int c;
        while ((c = stream.read(readBuffer)) >= 0) {
            target.write(readBuffer, 0, c);
        }
        return target;
    }

    public static byte[] readFully(InputStream stream, int bufferSize) throws IOException {
        return IOStreams.readFully(stream, new ByteArrayOutputStream(), new byte[bufferSize]).toByteArray();
    }

    public static byte[] readFully(InputStream stream) throws IOException {
        return IOStreams.readFully(stream, 8192);
    }

    public static <R> Tuple2<Option<R>, InputStream> probe(InputStream stream, byte[] buffer, int probeSize, BiFunction<? super byte[], Integer, ? extends R> probeFun) throws IOException {
        int c;
        if (probeSize < buffer.length) {
            throw new IllegalArgumentException("Probe size " + probeSize + " is less than buffer size" + buffer.length);
        }
        int read = 0;
        Option.None probeResult = API.None();
        while ((c = stream.read(buffer, read, buffer.length - read)) >= 0) {
            if ((read += c) < probeSize) continue;
            probeResult = API.Some(probeFun.apply((byte[])buffer, read));
        }
        byte[] head = Arrays.copyOf(buffer, read);
        return API.Tuple((Object)probeResult, (Object)new SequenceInputStream(new ByteArrayInputStream(head), stream));
    }

    public static <R> Tuple2<Option<R>, InputStream> probe(InputStream stream, int probeSize, BiFunction<? super byte[], Integer, ? extends R> probeFun) throws IOException {
        return IOStreams.probe(stream, new byte[8192], probeSize, probeFun);
    }

    public static <R> Tuple2<Option<R>, InputStream> probe(InputStream stream, int bufferSize, int probeSize, BiFunction<? super byte[], Integer, ? extends R> probeFun) throws IOException {
        return IOStreams.probe(stream, new byte[bufferSize], probeSize, probeFun);
    }

    public static <R> Tuple2<Option<R>, InputStream> probe(InputStream stream, Option<R> declared, int probeSize, BiFunction<? super byte[], Integer, ? extends R> probeFun) throws IOException {
        return IOStreams.probe(stream, declared, 8192, probeSize, probeFun);
    }

    public static <R> Tuple2<Option<R>, InputStream> probe(InputStream stream, Option<R> declared, int bufferSize, int probeSize, BiFunction<? super byte[], Integer, ? extends R> probeFun) throws IOException {
        return IOStreams.probe(stream, declared, new byte[bufferSize], probeSize, probeFun);
    }

    public static <R> Tuple2<Option<R>, InputStream> probe(InputStream stream, Option<R> declared, byte[] buffer, int probeSize, BiFunction<? super byte[], Integer, ? extends R> probeFun) throws IOException {
        if (declared.isDefined()) {
            return API.Tuple(declared, (Object)stream);
        }
        return IOStreams.probe(stream, buffer, probeSize, probeFun);
    }
}

