/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.util;

import io.vavr.collection.List;
import io.vavr.collection.Seq;
import java.util.function.UnaryOperator;

public class Strings {
    private Strings() {
    }

    public static String capitalize(CharSequence input) {
        return Strings.changeFirstLetter(input, Character::toUpperCase);
    }

    public static String uncapitalize(CharSequence input) {
        return Strings.changeFirstLetter(input, Character::toLowerCase);
    }

    private static String changeFirstLetter(CharSequence input, UnaryOperator<Character> operator) {
        if (input.length() <= 0) {
            return input.toString();
        }
        return new StringBuilder(input.length()).append(operator.apply(Character.valueOf(input.charAt(0)))).append(input.subSequence(1, input.length())).toString();
    }

    public static Seq<String> camelCaseWords(String string) {
        return CamelCaseWords.split(string);
    }

    private static final class CamelCaseWords {
        private CamelCaseWords() {
        }

        private static Seq<String> split(String str) {
            Seq<String> words = List.empty();
            int start = CamelCaseWords.skipIgnorable(0, str);
            if (CamelCaseWords.pastEnd(start, str)) {
                return words;
            }
            int pos = start;
            boolean digitMode = false;
            boolean upperMode = CamelCaseWords.upper(pos + 1, str);
            while (!CamelCaseWords.pastEnd(pos, str)) {
                if (CamelCaseWords.ignorable(pos, str)) {
                    words = CamelCaseWords.append(words, start, pos, str);
                    pos = start = CamelCaseWords.skipIgnorable(pos + 1, str);
                    continue;
                }
                if (CamelCaseWords.digit(pos, str)) {
                    upperMode = false;
                    digitMode = true;
                    ++pos;
                    continue;
                }
                if (digitMode) {
                    if (!CamelCaseWords.digit(pos, str)) {
                        words = CamelCaseWords.append(words, start, pos, str);
                        digitMode = false;
                        start = pos;
                        continue;
                    }
                    ++pos;
                    continue;
                }
                if (!upperMode && CamelCaseWords.upper(pos, str)) {
                    words = CamelCaseWords.append(words, start, pos, str);
                    start = pos++;
                    upperMode = CamelCaseWords.upper(pos, str);
                    continue;
                }
                if (upperMode && CamelCaseWords.lower(pos + 1, str)) {
                    words = CamelCaseWords.append(words, start, pos, str);
                    start = pos++;
                    upperMode = false;
                    continue;
                }
                ++pos;
            }
            return CamelCaseWords.append(words, start, str.length(), str);
        }

        private static boolean upper(int pos, String str) {
            return !CamelCaseWords.pastEnd(pos, str) && (Character.isUpperCase(str.charAt(pos)) || Character.isDigit(str.charAt(pos)));
        }

        private static boolean lower(int pos, String str) {
            return !CamelCaseWords.pastEnd(pos, str) && (Character.isLowerCase(str.charAt(pos)) || Character.isDigit(str.charAt(pos)));
        }

        private static boolean digit(int pos, String str) {
            return !CamelCaseWords.pastEnd(pos, str) && Character.isDigit(str.charAt(pos));
        }

        private static boolean ignorable(int pos, String str) {
            return !CamelCaseWords.pastEnd(pos, str) && !Character.isLetterOrDigit(str.charAt(pos));
        }

        private static int skipIgnorable(int pos, String str) {
            while (CamelCaseWords.ignorable(pos, str)) {
                ++pos;
            }
            return pos;
        }

        private static boolean pastEnd(int pos, String str) {
            return pos >= str.length();
        }

        private static Seq<String> append(Seq<String> words, int start, int end, String str) {
            String word = str.substring(start, end);
            return word.isEmpty() ? words : words.append((Object)word);
        }
    }
}

