/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.util.concurrent;

import ch.raffael.meldioc.util.concurrent.SecureExecutorServiceWrapper;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;

public abstract class DecoratingExecutorService<D extends ExecutorService>
extends SecureExecutorServiceWrapper<D> {
    protected DecoratingExecutorService(D delegate) {
        super(delegate);
    }

    protected abstract Runnable decorateRunnable(Runnable var1);

    protected abstract <T> Callable<T> decorateCallable(Callable<? extends T> var1);

    @Override
    public void execute(Runnable command) {
        this.delegate.execute(this.decorateRunnable(command));
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.delegate.submit(this.decorateCallable(task));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.delegate.submit(this.decorateRunnable(task), result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.delegate.submit(this.decorateRunnable(task));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.delegate.invokeAll(tasks.stream().map(this::decorateCallable).collect(Collectors.toList()));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.invokeAll(tasks.stream().map(this::decorateCallable).collect(Collectors.toList()), timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.delegate.invokeAny(tasks.stream().map(this::decorateCallable).collect(Collectors.toList()));
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.delegate.invokeAny(tasks.stream().map(this::decorateCallable).collect(Collectors.toList()), timeout, unit);
    }
}

