/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.util.concurrent;

import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public class Disposer {
    private final Object lock;
    @Nullable
    private Runnable disposeRunnable = null;

    public Disposer() {
        this(null);
    }

    public Disposer(@Nullable Object lock) {
        this.lock = Objects.requireNonNullElse(lock, this);
    }

    public <T> T onDispose(T instance, Runnable onDispose) {
        this.onDispose(onDispose);
        return instance;
    }

    public <T> T onDispose(T instance, Consumer<? super T> onDispose) {
        this.onDispose(() -> onDispose.accept((Object)instance));
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDispose(Runnable onDispose) {
        Object object = this.lock;
        synchronized (object) {
            if (this.disposeRunnable == null) {
                this.disposeRunnable = onDispose;
            } else {
                Runnable prev = this.disposeRunnable;
                this.disposeRunnable = () -> {
                    prev.run();
                    onDispose.run();
                };
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.lock;
        synchronized (object) {
            if (this.disposeRunnable == null) {
                return;
            }
            Runnable r = this.disposeRunnable;
            this.disposeRunnable = null;
            r.run();
        }
    }

    public Object lock() {
        return this.lock;
    }
}

