/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.util.concurrent;

import ch.raffael.meldioc.util.concurrent.ImmediateFuture;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class SameThreadExecutorService
implements ExecutorService {
    private final AtomicReference<State> state = new AtomicReference<State>(new State(0, false));
    private final CountDownLatch shutdownLatch = new CountDownLatch(1);

    @Override
    public void execute(Runnable command) {
        this.beginExecution();
        try {
            command.run();
        }
        finally {
            this.endExecution();
        }
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        this.beginExecution();
        try {
            ImmediateFuture<T> immediateFuture = ImmediateFuture.ofCallable(task);
            return immediateFuture;
        }
        finally {
            this.endExecution();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Future<T> submit(Runnable task, @Nullable T result) {
        this.beginExecution();
        try {
            Future<Object> future = this.submit(() -> {
                task.run();
                return result;
            });
            return future;
        }
        finally {
            this.endExecution();
        }
    }

    @Override
    public Future<?> submit(Runnable task) {
        this.beginExecution();
        try {
            ImmediateFuture<Void> immediateFuture = ImmediateFuture.runRunnable(task);
            return immediateFuture;
        }
        finally {
            this.endExecution();
        }
    }

    private void beginExecution() {
        this.state.updateAndGet(rec$ -> ((State)rec$).beginExecution());
    }

    private void endExecution() {
        this.state.updateAndGet(rec$ -> ((State)rec$).endExecution());
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) {
        return tasks.stream().map(this::submit).collect(Collectors.toList());
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) {
        Duration timeoutDuration;
        switch (unit) {
            case NANOSECONDS: {
                timeoutDuration = Duration.ofNanos(timeout);
                break;
            }
            case MICROSECONDS: {
                timeoutDuration = Duration.ofNanos(unit.toNanos(timeout));
                break;
            }
            case MILLISECONDS: {
                timeoutDuration = Duration.ofMillis(timeout);
                break;
            }
            case SECONDS: {
                timeoutDuration = Duration.ofSeconds(timeout);
                break;
            }
            case MINUTES: {
                timeoutDuration = Duration.ofMinutes(timeout);
                break;
            }
            case HOURS: {
                timeoutDuration = Duration.ofHours(timeout);
                break;
            }
            case DAYS: {
                timeoutDuration = Duration.ofDays(timeout);
                break;
            }
            default: {
                timeoutDuration = Duration.ofMillis(timeout);
            }
        }
        Instant until = Instant.now().plus(timeoutDuration);
        return tasks.stream().map(t -> Instant.now().compareTo(until) <= 0 ? this.submit((Callable)t) : ImmediateFuture.cancelled()).collect(Collectors.toList());
    }

    @Override
    @Nullable
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) {
        return this.invokeAll(tasks).stream().map(f -> (ImmediateFuture)f).filter(f -> f.result().isSuccess()).findFirst().map(f -> f.result().get()).orElse(null);
    }

    @Override
    @Nullable
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) {
        return this.invokeAll(tasks, timeout, unit).stream().filter(f -> f instanceof ImmediateFuture && !f.isCancelled()).map(f -> (ImmediateFuture)f).filter(f -> f.result().isSuccess()).findFirst().map(f -> f.result().get()).orElse(null);
    }

    @Override
    public void shutdown() {
        this.state.updateAndGet(rec$ -> ((State)rec$).shutdown());
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.shutdown();
        return Collections.emptyList();
    }

    @Override
    public boolean isShutdown() {
        return this.state.get().shutdown;
    }

    @Override
    public boolean isTerminated() {
        return this.shutdownLatch.getCount() == 0L;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.shutdownLatch.await(timeout, unit);
    }

    private class State {
        private final int executing;
        private final boolean shutdown;

        private State(int executing, boolean shutdown) {
            this.executing = executing;
            this.shutdown = shutdown;
        }

        private State beginExecution() {
            if (this.shutdown) {
                throw new IllegalStateException(SameThreadExecutorService.this + " is shutting down");
            }
            return new State(this.executing + 1, false);
        }

        private State endExecution() {
            return new State(this.executing - 1, this.shutdown).checkShutdownComplete();
        }

        private State shutdown() {
            return (this.shutdown ? this : new State(this.executing, true)).checkShutdownComplete();
        }

        private State checkShutdownComplete() {
            if (this.shutdown && this.executing == 0) {
                SameThreadExecutorService.this.shutdownLatch.countDown();
            }
            return this;
        }
    }
}

