/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.util.concurrent;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

public abstract class SecureExecutorServiceWrapper<D extends ExecutorService>
implements ExecutorService {
    protected final D delegate;

    protected SecureExecutorServiceWrapper(D delegate) {
        this.delegate = delegate;
    }

    @Override
    public void shutdown() {
        AccessControlContext ctx = AccessController.getContext();
        AccessController.doPrivileged(() -> {
            this.delegate.shutdown();
            return null;
        }, ctx);
    }

    @Override
    public List<Runnable> shutdownNow() {
        AccessControlContext ctx = AccessController.getContext();
        return AccessController.doPrivileged(() -> this.delegate.shutdownNow(), ctx);
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }
}

