/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.util.advice;

import ch.raffael.meldioc.util.Exceptions;
import ch.raffael.meldioc.util.advice.AdviceException;
import javax.annotation.Nullable;

public interface AroundAdvice {
    public AdviceCloseable before();

    public static AroundAdvice nop() {
        return Nop.INSTANCE;
    }

    public static final class Nop
    implements AroundAdvice {
        private static final String NOP_TO_STRING = Nop.class.getCanonicalName();
        private static final AdviceCloseable CLOSEABLE = new AdviceCloseable(){

            @Override
            public void close() throws AdviceException {
            }

            public String toString() {
                return NOP_TO_STRING;
            }
        };
        private static final Nop INSTANCE = new Nop();

        private Nop() {
        }

        @Override
        public AdviceCloseable before() {
            return CLOSEABLE;
        }
    }

    public static abstract class Basic
    implements AroundAdvice {
        private final AdviceCloseable closeable = () -> this.after(null);

        protected Basic() {
        }

        @Override
        public AdviceCloseable before() {
            AdviceException throwing = null;
            try {
                this.beforeImpl();
            }
            catch (AdviceException e) {
                throwing = e;
            }
            catch (Throwable e) {
                Exceptions.rethrowIfFatal(e);
                throwing = AdviceException.onBefore(e);
            }
            if (throwing != null) {
                this.after(throwing);
                throw throwing;
            }
            return this.closeable;
        }

        private void after(@Nullable Throwable throwing) {
            try {
                this.afterImpl();
            }
            catch (AdviceException e) {
                if (throwing != null) {
                    throwing.addSuppressed(e);
                }
                throw e;
            }
            catch (Throwable e) {
                Exceptions.rethrowIfFatal(e, throwing);
                if (throwing != null) {
                    throwing.addSuppressed(AdviceException.onAfter(e));
                }
                throw AdviceException.onAfter(e);
            }
        }

        protected abstract void beforeImpl();

        protected abstract void afterImpl();
    }

    public static interface AdviceCloseable
    extends AutoCloseable {
        @Override
        public void close() throws AdviceException;
    }
}

