/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.util.advice;

import ch.raffael.meldioc.util.Exceptions;
import ch.raffael.meldioc.util.advice.AdviceException;
import ch.raffael.meldioc.util.advice.AroundAdvice;
import io.vavr.collection.List;
import io.vavr.collection.Seq;
import io.vavr.control.Option;
import java.util.function.Function;
import java.util.function.Supplier;

public class CompositeAroundAdvice
extends AroundAdvice.Basic {
    private final Runnable before;
    private final Runnable after;

    public CompositeAroundAdvice(Runnable before, Runnable after) {
        this.before = before;
        this.after = after;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected void beforeImpl() {
        this.before.run();
    }

    @Override
    protected void afterImpl() {
        this.after.run();
    }

    public static class Builder
    extends AbstractProfile<Builder> {
        @Override
        public CompositeAroundAdvice advice() {
            return super.advice();
        }
    }

    public static abstract class AbstractProfile<SELF> {
        private static final Runnable BEFORE_TERMINATOR = () -> {};
        private static final Function<Option<AdviceException>, Option<AdviceException>> AFTER_TERMINATOR = Function.identity();
        private Seq<Supplier<? extends Runnable>> before = List.of((Object[])new Supplier[0]);
        private Seq<Supplier<? extends Runnable>> after = List.of((Object[])new Supplier[0]);

        public SELF before(Supplier<? extends Runnable> hook) {
            this.before = this.before.append(hook);
            return this.self();
        }

        public SELF after(Supplier<? extends Runnable> hook) {
            this.after = this.after.append(hook);
            return this.self();
        }

        public SELF removeBefore(Supplier<? extends Runnable> hook) {
            this.before = this.before.remove(hook);
            return this.self();
        }

        public SELF removeAfter(Supplier<? extends Runnable> hook) {
            this.after = this.after.remove(hook);
            return this.self();
        }

        protected final SELF self() {
            return (SELF)this;
        }

        protected Seq<Supplier<? extends Runnable>> before() {
            return this.before;
        }

        protected Seq<Supplier<? extends Runnable>> after() {
            return this.after;
        }

        protected CompositeAroundAdvice advice() {
            return new CompositeAroundAdvice(this.beforeRunnable(), this.afterRunnable());
        }

        protected Runnable beforeRunnable() {
            return (Runnable)this.before.map(Supplier::get).foldLeft((Object)BEFORE_TERMINATOR, (n, r) -> () -> {
                n.run();
                try {
                    r.run();
                }
                catch (Throwable e) {
                    throw AdviceException.onBefore(e);
                }
            });
        }

        protected Runnable afterRunnable() {
            Function teardownChain = (Function)this.after.map(Supplier::get).foldRight(AFTER_TERMINATOR, (r, n) -> exc -> {
                exc = (Option)n.apply(exc);
                try {
                    r.run();
                    return exc;
                }
                catch (Throwable e) {
                    Exceptions.rethrowIfFatal(e, (Throwable)exc.getOrNull());
                    return exc.map(ae -> {
                        ae.addSuppressed(e);
                        return ae;
                    }).orElse(() -> Option.some((Object)AdviceException.onAfter(e)));
                }
            });
            return () -> ((Option)teardownChain.apply(Option.none())).forEach(e -> {
                throw e;
            });
        }
    }
}

