/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.util.concurrent;

import ch.raffael.meldioc.util.concurrent.SecureExecutorServiceWrapper;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;

public abstract class TaskDecoratingExecutorService<D extends ExecutorService>
extends SecureExecutorServiceWrapper<D> {
    protected TaskDecoratingExecutorService(D delegate) {
        super(delegate);
    }

    protected abstract Runnable decorate(Runnable var1);

    protected abstract <T> Callable<T> decorate(Callable<? extends T> var1);

    protected <T> Collection<? extends Callable<T>> decorateAll(Collection<? extends Callable<T>> tasks) {
        return tasks.stream().map(this::decorate).collect(Collectors.toList());
    }

    @Override
    public void execute(Runnable task) {
        this.delegate.execute(this.decorate(task));
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.delegate.submit(this.decorate(task));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.delegate.submit(this.decorate(task), result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.delegate.submit(this.decorate(task));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.delegate.invokeAll(this.decorateAll(tasks));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.invokeAll(this.decorateAll(tasks), timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.delegate.invokeAny(this.decorateAll(tasks));
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.delegate.invokeAny(this.decorateAll(tasks), timeout, unit);
    }
}

