/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.util.concurrent;

import io.vavr.CheckedFunction0;
import io.vavr.CheckedRunnable;
import io.vavr.control.Try;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public final class ImmediateFuture<T>
implements Future<T> {
    private static final Cancelled<?> CANCELLED = new Cancelled();
    private final Try<T> result;

    private ImmediateFuture(Try<T> result) {
        this.result = result;
    }

    public static <T> ImmediateFuture<T> of(Try<T> result) {
        return new ImmediateFuture<T>(result);
    }

    public static <T> ImmediateFuture<T> of(CheckedFunction0<T> supplier) {
        return new ImmediateFuture<T>(Try.of(supplier));
    }

    public static ImmediateFuture<Void> run(CheckedRunnable runnable) {
        return new ImmediateFuture<Void>(Try.run((CheckedRunnable)runnable));
    }

    public static ImmediateFuture<Void> runRunnable(Runnable runnable) {
        return new ImmediateFuture<Void>(Try.runRunnable((Runnable)runnable));
    }

    public static <T> ImmediateFuture<T> ofCallable(Callable<T> callable) {
        return new ImmediateFuture<T>(Try.ofCallable(callable));
    }

    public static <T> Cancelled<T> cancelled() {
        return CANCELLED;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return true;
    }

    @Override
    public T get() throws ExecutionException {
        if (this.result.isFailure()) {
            throw new ExecutionException(this.result.getCause());
        }
        return (T)this.result.get();
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws ExecutionException {
        return this.get();
    }

    public Try<T> result() {
        return this.result;
    }

    public static final class Cancelled<T>
    implements Future<T> {
        private Cancelled() {
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return true;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public T get() {
            throw new CancellationException();
        }

        @Override
        public T get(long timeout, TimeUnit unit) {
            return this.get();
        }
    }
}

