/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.util;

import ch.raffael.meldioc.util.IllegalFlow;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public final class Exceptions {
    private Exceptions() {
    }

    public static boolean isFatal(Throwable exception) {
        return exception instanceof VirtualMachineError || exception instanceof LinkageError;
    }

    public static <E extends Throwable> E rethrowIfFatal(E exception) {
        return Exceptions.rethrowIfFatal(exception, null);
    }

    public static <E extends Throwable> E rethrowIfFatal(E exception, @Nullable Throwable previous) {
        if (Exceptions.isFatal(exception)) {
            if (previous != null && previous != exception) {
                exception.addSuppressed(previous);
            }
            throw (Error)exception;
        }
        return exception;
    }

    public static <E extends Throwable, T extends Throwable> E rethrowIfChecked(E exception, Class<T> t) throws T {
        if (t.isInstance(Exceptions.rethrowIfFatal(exception))) {
            throw (Throwable)t.cast(exception);
        }
        return exception;
    }

    public static <E extends Throwable, T1 extends Throwable, T2 extends Throwable> E rethrowIfChecked(E exception, Class<T1> t1, Class<T2> t2) throws T1, T2 {
        if (t1.isInstance(Exceptions.rethrowIfFatal(exception))) {
            throw (Throwable)t1.cast(exception);
        }
        if (t2.isInstance(exception)) {
            throw (Throwable)t2.cast(exception);
        }
        return exception;
    }

    public static <E extends Throwable, T1 extends Throwable, T2 extends Throwable, T3 extends Throwable> E rethrowIfChecked(E exception, Class<T1> t1, Class<T2> t2, Class<T3> t3) throws T1, T2, T3 {
        if (t1.isInstance(Exceptions.rethrowIfFatal(exception))) {
            throw (Throwable)t1.cast(exception);
        }
        if (t2.isInstance(exception)) {
            throw (Throwable)t2.cast(exception);
        }
        if (t3.isInstance(exception)) {
            throw (Throwable)t3.cast(exception);
        }
        return exception;
    }

    public static <E extends Throwable> E rethrowIfUnchecked(E exception) throws RuntimeException, Error {
        if (Exceptions.rethrowIfFatal(exception) instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        if (exception instanceof Error) {
            throw (Error)exception;
        }
        return exception;
    }

    public static IllegalFlow alwaysRethrow(Throwable exception) {
        throw IllegalFlow.unexpectedException(Exceptions.rethrowIfUnchecked(exception));
    }

    public static <T extends Throwable> IllegalFlow alwaysRethrow(Throwable exception, Class<T> t) throws T {
        throw Exceptions.alwaysRethrow(Exceptions.rethrowIfChecked(exception, t));
    }

    public static <T1 extends Throwable, T2 extends Throwable> IllegalFlow alwaysRethrow(Throwable exception, Class<T1> t1, Class<T2> t2) throws T1, T2 {
        throw Exceptions.alwaysRethrow(Exceptions.rethrowIfChecked(exception, t1, t2));
    }

    public static <T1 extends Throwable, T2 extends Throwable, T3 extends Throwable> IllegalFlow alwaysRethrow(Throwable exception, Class<T1> t1, Class<T2> t2, Class<T3> t3) throws T1, T2, T3 {
        throw Exceptions.alwaysRethrow(Exceptions.rethrowIfChecked(exception, t1, t2, t3));
    }

    public static <T extends Throwable> IllegalFlow alwaysRethrow(Throwable exception, Class<T> t, Function<? super Throwable, ? extends T> wrapper) throws T {
        Exceptions.rethrowIfChecked(exception, t);
        throw (Throwable)wrapper.apply(exception);
    }

    public static <T1 extends Throwable, T2 extends Throwable> IllegalFlow alwaysRethrow(Throwable exception, Class<T1> t1, Class<T2> t2, Function<? super Throwable, ? extends T1> wrapper) throws T1, T2 {
        Exceptions.rethrowIfChecked(exception, t1, t2);
        throw (Throwable)wrapper.apply(exception);
    }

    public static <T1 extends Throwable, T2 extends Throwable, T3 extends Throwable> IllegalFlow alwaysRethrow(Throwable exception, Class<T1> t1, Class<T2> t2, Class<T3> t3, Function<? super Throwable, ? extends T1> wrapper) throws T1, T2, T3 {
        Exceptions.rethrowIfChecked(exception, t1, t2, t3);
        throw (Throwable)wrapper.apply(exception);
    }

    public static String toString(Throwable e) {
        return Exceptions.toString(e, true);
    }

    public static String toString(Throwable e, boolean stackTrace) {
        if (stackTrace) {
            StringWriter string = new StringWriter();
            PrintWriter print = new PrintWriter(string);
            e.printStackTrace(print);
            print.flush();
            return string.toString();
        }
        return e.toString();
    }

    @Deprecated
    public static Throwable accumulate(Option<Throwable> current, Throwable exception) {
        return Exceptions.accumulate((Throwable)current.getOrNull(), exception);
    }

    public static Throwable accumulate(@Nullable Throwable current, Throwable exception) {
        if (current == null) {
            return exception;
        }
        if (Exceptions.isFatal(exception) && !Exceptions.isFatal(current)) {
            exception.addSuppressed(current);
            return exception;
        }
        current.addSuppressed(exception);
        return current;
    }

    public static <T> Try<T> accumulate(Try<T> t, Throwable exception) {
        if (t.isFailure()) {
            t.getCause().addSuppressed(exception);
            return t;
        }
        return Try.failure((Throwable)exception);
    }

    public static <E extends Exception> AutoCloser<E> autoClose(AutoCloser<E> autoCloser) {
        return autoCloser;
    }

    @FunctionalInterface
    public static interface AutoCloser<E extends Exception>
    extends AutoCloseable {
        @Override
        public void close() throws E;
    }
}

