/*
 * Decompiled with CFR 0.152.
 */
package ch.raffael.meldioc.util.advice;

import ch.raffael.meldioc.util.Exceptions;

public class AdviceException
extends RuntimeException {
    public AdviceException() {
    }

    public AdviceException(String message) {
        super(message);
    }

    public AdviceException(String message, Throwable cause) {
        super(message, cause);
    }

    public AdviceException(Throwable cause) {
        super(cause);
    }

    public static AdviceException onBefore(Throwable cause) {
        return AdviceException.create("Exception on before advice", cause);
    }

    public static AdviceException onAfter(Throwable cause) {
        return AdviceException.create("Exception on after advice", cause);
    }

    private static AdviceException create(String msg, Throwable cause) {
        Exceptions.rethrowIfFatal(cause);
        return new AdviceException(msg + ": " + String.valueOf(cause), cause);
    }
}

