/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.embeddedtc;

import ch.ralscha.embeddedtc.AllArtifact;
import ch.ralscha.embeddedtc.Artifact;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.LogManager;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.deploy.ContextEnvironment;
import org.apache.catalina.deploy.ContextResource;
import org.apache.catalina.session.StandardManager;
import org.apache.catalina.startup.Tomcat;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EmbeddedTomcat {
    private static final Log log = LogFactory.getLog(EmbeddedTomcat.class);
    private static final String SHUTDOWN_COMMAND = "EMBEDDED_TC_SHUTDOWN";
    private String contextPath;
    private Integer port;
    private Integer shutdownPort;
    private int secondsToWaitBeforePortBecomesAvailable;
    private String tempDirectory;
    private String contextDirectory;
    private boolean removeDefaultServlet;
    private boolean privileged;
    private boolean silent;
    private List<Artifact> resourceArtifacts;
    private Map<Class<? extends ServletContainerInitializer>, Set<Class<?>>> initializers;
    private List<ContextEnvironment> contextEnvironments;
    private List<ContextResource> contextResources;
    private File pomFile;
    private File m2Directory;
    private Tomcat tomcat;

    public static void main(String[] args) {
        new EmbeddedTomcat().startAndWait();
    }

    public EmbeddedTomcat() {
        this("/", 8080);
    }

    public EmbeddedTomcat(int port) {
        this("/", port);
    }

    public EmbeddedTomcat(String contextPath) {
        this(contextPath, 8080);
    }

    public EmbeddedTomcat(String contextPath, int port) {
        if (contextPath != null && !contextPath.startsWith("/")) {
            throw new IllegalArgumentException("contextPath does not start with /");
        }
        this.pomFile = null;
        this.m2Directory = null;
        this.contextEnvironments = new ArrayList<ContextEnvironment>();
        this.contextResources = new ArrayList<ContextResource>();
        this.initializers = new HashMap();
        this.resourceArtifacts = new ArrayList<Artifact>();
        this.contextDirectory = null;
        this.tempDirectory = null;
        this.removeDefaultServlet = false;
        this.port = port;
        this.shutdownPort = port + 1000;
        this.secondsToWaitBeforePortBecomesAvailable = 10;
        this.privileged = false;
        this.silent = false;
        this.tomcat = null;
        this.contextPath = contextPath != null ? contextPath : "/";
    }

    public void setContextDirectory(String contextDirectory) {
        this.contextDirectory = contextDirectory;
    }

    public void setTempDirectory(File tempDirectory) {
        this.tempDirectory = tempDirectory.getAbsolutePath();
    }

    public void setTempDirectoryName(String name) {
        this.tempDirectory = System.getProperty("java.io.tmpdir") + "/" + name;
    }

    public void setPomFile(File pomFile) {
        this.pomFile = pomFile;
    }

    public void setM2Directory(File m2Directory) {
        this.m2Directory = m2Directory;
    }

    public void removeDefaultServlet() {
        this.removeDefaultServlet = true;
    }

    public void dontAddShutdownHook() {
        this.shutdownPort = null;
    }

    public void setSecondsToWaitBeforePortBecomesAvailable(int seconds) {
        this.secondsToWaitBeforePortBecomesAvailable = seconds;
    }

    public void setShutdownPort(int shutdownPort) {
        this.shutdownPort = shutdownPort;
    }

    public void setPrivileged(boolean privileged) {
        this.privileged = privileged;
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
    }

    public void addAllDependenciesAsResourceJar() {
        this.resourceArtifacts.add(new AllArtifact());
    }

    public void addDependencyAsResourceJar(String groupId, String artifact) {
        this.resourceArtifacts.add(new Artifact(groupId, artifact));
    }

    public void addInitializer(Class<? extends ServletContainerInitializer> containerInitializer, Class<?> handlesClass) {
        Set<Class<?>> classes = this.initializers.get(containerInitializer);
        if (classes == null) {
            classes = new HashSet();
            this.initializers.put(containerInitializer, classes);
        }
        classes.add(handlesClass);
    }

    public void addContextEnvironment(ContextEnvironment env) {
        this.contextEnvironments.add(env);
    }

    public void addContextResource(ContextResource res) {
        this.contextResources.add(res);
    }

    public void addContextEnvironment(String name, String value, String type) {
        ContextEnvironment env = new ContextEnvironment();
        env.setType(type);
        env.setName(name);
        env.setValue(value);
        this.addContextEnvironment(env);
    }

    public void addContextEnvironmentString(String name, String value) {
        this.addContextEnvironment(name, value, "java.lang.String");
    }

    public void start() {
        this.start(false);
    }

    public void startAndWait() {
        this.start(true);
    }

    private void start(boolean await) {
        Context ctx;
        this.sendShutdownCommand();
        try {
            ServerSocket srv = new ServerSocket(this.port);
            srv.close();
        }
        catch (IOException e) {
            log.error((Object)("PORT " + this.port + " ALREADY IN USE"));
            return;
        }
        EmbeddedTomcat.installSlf4jBridge();
        this.tomcat = new Tomcat();
        this.tomcat.setPort(this.port.intValue());
        if (this.tempDirectory == null) {
            File tempdir = new File(System.getProperty("java.io.tmpdir"));
            this.tempDirectory = new File(tempdir, "/tomcat." + this.port).getAbsolutePath();
        }
        this.tomcat.setBaseDir(this.tempDirectory);
        if (this.silent) {
            this.tomcat.setSilent(true);
        }
        if (this.shutdownPort != null) {
            this.tomcat.getServer().setPort(this.shutdownPort.intValue());
            this.tomcat.getServer().setShutdown(SHUTDOWN_COMMAND);
        }
        this.tomcat.getConnector().setURIEncoding("UTF-8");
        String contextDir = this.contextDirectory;
        if (contextDir == null) {
            contextDir = new File(".").getAbsolutePath() + "/src/main/webapp";
        }
        try {
            ctx = this.tomcat.addWebapp(this.contextPath, contextDir);
        }
        catch (ServletException e) {
            throw new RuntimeException(e);
        }
        if (this.privileged) {
            ctx.setPrivileged(true);
        }
        if (!this.contextEnvironments.isEmpty() || !this.contextResources.isEmpty()) {
            this.tomcat.enableNaming();
        }
        for (ContextEnvironment contextEnvironment : this.contextEnvironments) {
            ctx.getNamingResources().addEnvironment(contextEnvironment);
        }
        for (ContextResource contextResource : this.contextResources) {
            ctx.getNamingResources().addResource(contextResource);
        }
        if (this.removeDefaultServlet) {
            ctx.addLifecycleListener(new LifecycleListener(){

                public void lifecycleEvent(LifecycleEvent event) {
                    if ("before_start".equals(event.getType())) {
                        ctx.removeServletMapping("/");
                    }
                }
            });
        }
        if (!this.resourceArtifacts.isEmpty()) {
            List<URL> resourceUrls;
            try {
                resourceUrls = this.findResourceUrls();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new RuntimeException(parserConfigurationException);
            }
            catch (SAXException sAXException) {
                throw new RuntimeException(sAXException);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            for (URL url : resourceUrls) {
                ctx.addResourceJarUrl(url);
            }
        }
        if (!this.initializers.isEmpty()) {
            for (Map.Entry entry : this.initializers.entrySet()) {
                try {
                    ctx.addServletContainerInitializer((ServletContainerInitializer)((Class)entry.getKey()).newInstance(), (Set)entry.getValue());
                }
                catch (InstantiationException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        try {
            this.tomcat.start();
        }
        catch (LifecycleException e) {
            throw new RuntimeException(e);
        }
        ((StandardManager)ctx.getManager()).setPathname("");
        if (await) {
            this.tomcat.getServer().await();
        }
    }

    public void stop() {
        if (this.tomcat != null) {
            try {
                this.tomcat.stop();
            }
            catch (LifecycleException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void sendShutdownCommand() {
        if (this.shutdownPort != null) {
            try {
                Socket socket = new Socket("localhost", (int)this.shutdownPort);
                OutputStream stream = socket.getOutputStream();
                for (int i = 0; i < SHUTDOWN_COMMAND.length(); ++i) {
                    stream.write(SHUTDOWN_COMMAND.charAt(i));
                }
                stream.flush();
                stream.close();
                socket.close();
            }
            catch (UnknownHostException e) {
                if (!this.silent) {
                    log.info((Object)e);
                }
                return;
            }
            catch (IOException e) {
                if (!this.silent) {
                    log.info((Object)e);
                }
                return;
            }
            for (int count = 0; count < this.secondsToWaitBeforePortBecomesAvailable * 2; ++count) {
                try {
                    ServerSocket srv = new ServerSocket(this.port);
                    srv.close();
                    return;
                }
                catch (IOException e) {
                    try {
                        TimeUnit.MILLISECONDS.sleep(500L);
                        continue;
                    }
                    catch (InterruptedException e2) {
                        return;
                    }
                }
            }
        }
    }

    private static void installSlf4jBridge() {
        try {
            Class<?> clazz = Class.forName("org.slf4j.bridge.SLF4JBridgeHandler");
            LogManager.getLogManager().reset();
            Method method = clazz.getMethod("install", new Class[]{null});
            method.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException e) {
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private List<URL> findResourceUrls() throws ParserConfigurationException, SAXException, IOException {
        Node node;
        int i;
        File m2Dir = this.m2Directory;
        if (m2Dir == null) {
            File homeDir = new File(System.getProperty("user.home"));
            m2Dir = new File(homeDir, ".m2/repository/");
        }
        ArrayList<URL> jars = new ArrayList<URL>();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        File pom = this.pomFile;
        if (pom == null) {
            pom = new File("./pom.xml");
        }
        Document doc = db.parse(pom);
        HashMap<String, String> properties = new HashMap<String, String>();
        NodeList propertiesNodeList = doc.getElementsByTagName("properties");
        if (propertiesNodeList != null && propertiesNodeList.item(0) != null) {
            NodeList propertiesChildren = propertiesNodeList.item(0).getChildNodes();
            for (i = 0; i < propertiesChildren.getLength(); ++i) {
                node = propertiesChildren.item(i);
                if (!(node instanceof Element)) continue;
                properties.put("${" + node.getNodeName() + "}", this.stripWhitespace(node.getTextContent()));
            }
        }
        NodeList nodeList = doc.getElementsByTagName("dependency");
        for (i = 0; i < nodeList.getLength(); ++i) {
            node = (Element)nodeList.item(i);
            String groupId = node.getElementsByTagName("groupId").item(0).getTextContent();
            String artifact = node.getElementsByTagName("artifactId").item(0).getTextContent();
            String version = node.getElementsByTagName("version").item(0).getTextContent();
            groupId = this.stripWhitespace(groupId);
            artifact = this.stripWhitespace(artifact);
            version = this.stripWhitespace(version);
            groupId = this.resolveProperty(groupId, properties);
            artifact = this.resolveProperty(artifact, properties);
            version = this.resolveProperty(version, properties);
            if (!this.isIncluded(groupId, artifact)) continue;
            String scope = null;
            NodeList scopeNode = node.getElementsByTagName("scope");
            if (scopeNode != null && scopeNode.item(0) != null) {
                scope = this.stripWhitespace(scopeNode.item(0).getTextContent());
            }
            if (scope != null && scope.equals("provided")) continue;
            groupId = groupId.replace(".", "/");
            String artifactFileName = groupId + "/" + artifact + "/" + version + "/" + artifact + "-" + version + ".jar";
            String pathName = new File(m2Dir, artifactFileName).getPath();
            jars.add(new URL("jar:file:/" + pathName + "!/"));
        }
        return jars;
    }

    private boolean isIncluded(String groupId, String artifactId) {
        for (Artifact artifact : this.resourceArtifacts) {
            if (!artifact.is(groupId, artifactId)) continue;
            return true;
        }
        return false;
    }

    private String stripWhitespace(String orig) {
        if (orig != null) {
            return orig.replace("\r", "").replace("\n", "").replace("\t", "").trim();
        }
        return orig;
    }

    private String resolveProperty(String orig, Map<String, String> properties) {
        String property = properties.get(orig);
        if (property != null) {
            return property;
        }
        return orig;
    }
}

