/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.api;

import ch.ralscha.extdirectspring.annotation.ExtDirectMethod;
import ch.ralscha.extdirectspring.annotation.ExtDirectMethodType;
import ch.ralscha.extdirectspring.api.ApiCache;
import ch.ralscha.extdirectspring.api.ApiCacheKey;
import ch.ralscha.extdirectspring.api.PollingProvider;
import ch.ralscha.extdirectspring.api.RemotingApi;
import ch.ralscha.extdirectspring.util.ExtDirectSpringUtil;
import ch.ralscha.extdirectspring.util.JsonHandler;
import ch.ralscha.extdirectspring.util.MethodInfo;
import ch.ralscha.extdirectspring.util.ParameterInfo;
import ch.ralscha.extdirectspring.util.SupportedParameterTypes;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Controller
public class ApiController {
    private ApplicationContext context;
    private JsonHandler jsonHandler;

    @Autowired
    public ApiController(ApplicationContext context, JsonHandler jsonHandler) {
        this.context = context;
        this.jsonHandler = jsonHandler;
    }

    @RequestMapping(value={"/api.js", "/api-debug.js"}, method={RequestMethod.GET})
    public void api(@RequestParam(value="apiNs", required=false, defaultValue="Ext.app") String apiNs, @RequestParam(value="actionNs", required=false) String actionNs, @RequestParam(value="remotingApiVar", required=false, defaultValue="REMOTING_API") String remotingApiVar, @RequestParam(value="pollingUrlsVar", required=false, defaultValue="POLLING_URLS") String pollingUrlsVar, @RequestParam(value="group", required=false) String group, @RequestParam(value="fullRouterUrl", required=false, defaultValue="false") boolean fullRouterUrl, @RequestParam(value="format", required=false) String format, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (format == null) {
            response.setContentType("application/x-javascript");
            String requestUrlString = fullRouterUrl ? request.getRequestURL().toString() : request.getRequestURI();
            boolean debug = requestUrlString.contains("api-debug.js");
            ApiCacheKey apiKey = new ApiCacheKey(apiNs, actionNs, remotingApiVar, pollingUrlsVar, group, debug);
            String apiString = ApiCache.INSTANCE.get(apiKey);
            if (apiString == null) {
                String basePollUrl;
                String routerUrl;
                if (!debug) {
                    routerUrl = requestUrlString.replace("api.js", "router");
                    basePollUrl = requestUrlString.replace("api.js", "poll");
                } else {
                    routerUrl = requestUrlString.replace("api-debug.js", "router");
                    basePollUrl = requestUrlString.replace("api-debug.js", "poll");
                }
                apiString = this.buildApiString(apiNs, actionNs, remotingApiVar, pollingUrlsVar, routerUrl, basePollUrl, group, debug);
                ApiCache.INSTANCE.put(apiKey, apiString);
            }
            response.getOutputStream().write(apiString.getBytes());
        } else {
            response.setContentType("application/json");
            String requestUrlString = request.getRequestURL().toString();
            boolean debug = requestUrlString.contains("api-debug.js");
            String routerUrl = !debug ? requestUrlString.replace("api.js", "router") : requestUrlString.replace("api-debug.js", "router");
            String apiString = this.buildApiJson(apiNs, actionNs, remotingApiVar, routerUrl, group, debug);
            response.getOutputStream().write(apiString.getBytes());
        }
    }

    private String buildApiString(String apiNs, String actionNs, String remotingApiVar, String pollingUrlsVar, String routerUrl, String basePollUrl, String group, boolean debug) {
        List<PollingProvider> pollingProviders;
        RemotingApi remotingApi = new RemotingApi(routerUrl, actionNs);
        this.scanForExtDirectMethods(remotingApi, group);
        StringBuilder sb = new StringBuilder();
        if (StringUtils.hasText((String)apiNs)) {
            sb.append("Ext.ns('");
            sb.append(apiNs);
            sb.append("');");
        }
        if (debug) {
            sb.append("\n\n");
        }
        if (StringUtils.hasText((String)actionNs)) {
            sb.append("Ext.ns('");
            sb.append(actionNs);
            sb.append("');");
            if (debug) {
                sb.append("\n\n");
            }
        }
        String jsonConfig = this.jsonHandler.writeValueAsString(remotingApi, debug);
        if (StringUtils.hasText((String)apiNs)) {
            sb.append(apiNs).append(".");
        }
        sb.append(remotingApiVar).append(" = ");
        sb.append(jsonConfig);
        sb.append(";");
        if (debug) {
            sb.append("\n\n");
        }
        if (!(pollingProviders = remotingApi.getPollingProviders()).isEmpty()) {
            if (StringUtils.hasText((String)apiNs)) {
                sb.append(apiNs).append(".");
            }
            sb.append(pollingUrlsVar).append(" = {");
            if (debug) {
                sb.append("\n");
            }
            for (int i = 0; i < pollingProviders.size(); ++i) {
                if (debug) {
                    sb.append("  ");
                }
                sb.append("\"");
                sb.append(pollingProviders.get(i).getEvent());
                sb.append("\"");
                sb.append(" : \"").append(basePollUrl).append("/");
                sb.append(pollingProviders.get(i).getBeanName());
                sb.append("/");
                sb.append(pollingProviders.get(i).getMethod());
                sb.append("/");
                sb.append(pollingProviders.get(i).getEvent());
                sb.append("\"");
                if (i >= pollingProviders.size() - 1) continue;
                sb.append(",");
                if (!debug) continue;
                sb.append("\n");
            }
            if (debug) {
                sb.append("\n");
            }
            sb.append("};");
        }
        return sb.toString();
    }

    private String buildApiJson(String apiNs, String actionNs, String remotingApiVar, String routerUrl, String group, boolean debug) {
        RemotingApi remotingApi = new RemotingApi(routerUrl, actionNs);
        if (StringUtils.hasText((String)apiNs)) {
            remotingApi.setDescriptor(apiNs + "." + remotingApiVar);
        } else {
            remotingApi.setDescriptor(remotingApiVar);
        }
        this.scanForExtDirectMethods(remotingApi, group);
        return this.jsonHandler.writeValueAsString(remotingApi, debug);
    }

    private void scanForExtDirectMethods(RemotingApi remotingApi, String group) {
        Map<String, Class<?>> beanDefinitions = this.getAllBeanClasses();
        for (Map.Entry<String, Class<?>> entry : beanDefinitions.entrySet()) {
            Method[] methods;
            Class<?> beanClass = entry.getValue();
            String beanName = entry.getKey();
            block8: for (Method method : methods = beanClass.getMethods()) {
                ExtDirectMethod annotation = (ExtDirectMethod)AnnotationUtils.findAnnotation((Method)method, ExtDirectMethod.class);
                if (annotation == null || !this.isSameGroup(group, annotation.group())) continue;
                ExtDirectMethodType type = annotation.value();
                switch (type) {
                    case SIMPLE: {
                        remotingApi.addAction(beanName, method.getName(), this.numberOfParameters(method));
                        continue block8;
                    }
                    case SIMPLE_NAMED: {
                        remotingApi.addAction(beanName, method.getName(), this.parameterNames(beanClass, method));
                        continue block8;
                    }
                    case FORM_LOAD: 
                    case STORE_READ: 
                    case STORE_MODIFY: 
                    case TREE_LOADER: 
                    case TREE_LOAD: {
                        remotingApi.addAction(beanName, method.getName(), 1);
                        continue block8;
                    }
                    case FORM_POST: {
                        if (this.isValidFormPostMethod(beanClass, method)) {
                            remotingApi.addAction(beanName, method.getName(), 0, true);
                            continue block8;
                        }
                        LogFactory.getLog(this.getClass()).warn((Object)("Method '" + beanName + "." + method.getName() + "' is annotated as a form post method but is not valid. " + "A form post method must be annotated with @RequestMapping and method=RequestMethod.POST. Method ignored."));
                        continue block8;
                    }
                    case POLL: {
                        remotingApi.addPollingProvider(beanName, method.getName(), annotation.event());
                    }
                }
            }
        }
    }

    private int numberOfParameters(Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        int paramLength = 0;
        for (Class<?> parameterType : parameterTypes) {
            if (SupportedParameterTypes.isSupported(parameterType)) continue;
            ++paramLength;
        }
        return paramLength;
    }

    private List<String> parameterNames(Class<?> beanClass, Method method) {
        MethodInfo methodInfo = new MethodInfo(beanClass, method);
        ArrayList<String> result = new ArrayList<String>();
        List<ParameterInfo> parameters = methodInfo.getParameters();
        for (ParameterInfo parameter : parameters) {
            if (parameter.isSupportedParameter()) continue;
            result.add(parameter.getName());
        }
        return result;
    }

    private boolean isSameGroup(String requestedGroup, String annotationGroup) {
        if (requestedGroup != null) {
            return ExtDirectSpringUtil.equal(requestedGroup, annotationGroup);
        }
        return true;
    }

    private boolean isValidFormPostMethod(Class<?> clazz, Method method) {
        if (AnnotationUtils.findAnnotation(clazz, Controller.class) == null) {
            return false;
        }
        RequestMapping methodAnnotation = (RequestMapping)AnnotationUtils.findAnnotation((Method)method, RequestMapping.class);
        if (methodAnnotation == null) {
            return false;
        }
        RequestMapping classAnnotation = (RequestMapping)AnnotationUtils.findAnnotation(clazz, RequestMapping.class);
        boolean hasValue = false;
        if (classAnnotation != null) {
            boolean bl = hasValue = classAnnotation.value() != null && classAnnotation.value().length > 0;
        }
        if (!hasValue) {
            hasValue = methodAnnotation.value() != null && methodAnnotation.value().length > 0;
        }
        return hasValue && this.hasPostMethod(methodAnnotation.method());
    }

    private boolean hasPostMethod(RequestMethod[] methods) {
        if (methods != null) {
            for (RequestMethod method : methods) {
                if (!method.equals((Object)RequestMethod.POST)) continue;
                return true;
            }
        }
        return false;
    }

    private Map<String, Class<?>> getAllBeanClasses() {
        HashMap beanClasses = new HashMap();
        ApplicationContext currentCtx = this.context;
        do {
            for (String beanName : currentCtx.getBeanDefinitionNames()) {
                beanClasses.put(beanName, currentCtx.getType(beanName));
            }
        } while ((currentCtx = currentCtx.getParent()) != null);
        return beanClasses;
    }
}

