/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.util;

import ch.ralscha.extdirectspring.annotation.ExtDirectMethod;
import ch.ralscha.extdirectspring.util.MethodInfo;
import ch.ralscha.extdirectspring.util.MethodInfoCache;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ReflectionUtils;

public class ExtDirectSpringUtil {
    private ExtDirectSpringUtil() {
    }

    public static boolean equal(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static MethodInfo findMethodInfo(ApplicationContext context, String beanName, String methodName) {
        if (context == null) {
            throw new IllegalArgumentException("ApplicatonContext cannot be null");
        }
        if (beanName == null) {
            throw new IllegalArgumentException("beanName cannot be null");
        }
        if (methodName == null) {
            throw new IllegalArgumentException("methodName cannot be null");
        }
        MethodInfo methodInfo = MethodInfoCache.INSTANCE.get(beanName, methodName);
        if (methodInfo != null) {
            return methodInfo;
        }
        Object bean = context.getBean(beanName);
        Method method = BeanUtils.findMethodWithMinimalParameters(bean.getClass(), (String)methodName);
        if (method != null) {
            if (AnnotationUtils.findAnnotation((Method)method, ExtDirectMethod.class) == null) {
                throw new IllegalArgumentException("Invalid remoting method '" + beanName + "." + methodName + "'. Missing ExtDirectMethod annotation");
            }
            return MethodInfoCache.INSTANCE.put(beanName, methodName, bean.getClass(), method);
        }
        throw new IllegalArgumentException("Method '" + beanName + "." + methodName + "' not found");
    }

    public static Object invoke(ApplicationContext context, String beanName, MethodInfo methodInfo, Object[] params) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object bean = context.getBean(beanName);
        Method handlerMethod = methodInfo.getMethod();
        ReflectionUtils.makeAccessible((Method)handlerMethod);
        return handlerMethod.invoke(bean, params);
    }
}

