/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.util;

import ch.ralscha.extdirectspring.annotation.ExtDirectMethod;
import ch.ralscha.extdirectspring.util.MethodInfo;
import ch.ralscha.extdirectspring.util.MethodInfoCache;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtDirectSpringUtil {
    private ExtDirectSpringUtil() {
    }

    public static boolean equal(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static MethodInfo findMethodInfo(ApplicationContext context, String beanName, String methodName) {
        if (context == null) {
            throw new IllegalArgumentException("ApplicatonContext cannot be null");
        }
        if (beanName == null) {
            throw new IllegalArgumentException("beanName cannot be null");
        }
        if (methodName == null) {
            throw new IllegalArgumentException("methodName cannot be null");
        }
        MethodInfo methodInfo = MethodInfoCache.INSTANCE.get(beanName, methodName);
        if (methodInfo != null) {
            return methodInfo;
        }
        Object bean = context.getBean(beanName);
        List<Method> methods = ExtDirectSpringUtil.findMethodsWithMinimalParameters(bean.getClass(), methodName);
        if (methods != null) {
            for (Method method : methods) {
                if (AnnotationUtils.findAnnotation((Method)method, ExtDirectMethod.class) == null) continue;
                return MethodInfoCache.INSTANCE.put(beanName, methodName, bean.getClass(), method);
            }
            throw new IllegalArgumentException("Invalid remoting method '" + beanName + "." + methodName + "'. Missing ExtDirectMethod annotation");
        }
        throw new IllegalArgumentException("Method '" + beanName + "." + methodName + "' not found");
    }

    public static Object invoke(ApplicationContext context, String beanName, MethodInfo methodInfo, Object[] params) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object bean = context.getBean(beanName);
        Method handlerMethod = methodInfo.getMethod();
        ReflectionUtils.makeAccessible((Method)handlerMethod);
        return handlerMethod.invoke(bean, params);
    }

    private static List<Method> findMethodsWithMinimalParameters(Class<?> clazz, String methodName) throws IllegalArgumentException {
        List<Method> targetMethod = ExtDirectSpringUtil.findMethodsWithMinimalParameters(clazz.getMethods(), methodName);
        if (targetMethod == null) {
            targetMethod = ExtDirectSpringUtil.findDeclaredMethodsWithMinimalParameters(clazz, methodName);
        }
        return targetMethod;
    }

    private static List<Method> findDeclaredMethodsWithMinimalParameters(Class<?> clazz, String methodName) throws IllegalArgumentException {
        List<Method> targetMethod = ExtDirectSpringUtil.findMethodsWithMinimalParameters(clazz.getDeclaredMethods(), methodName);
        if (targetMethod == null && clazz.getSuperclass() != null) {
            targetMethod = ExtDirectSpringUtil.findDeclaredMethodsWithMinimalParameters(clazz.getSuperclass(), methodName);
        }
        return targetMethod;
    }

    private static List<Method> findMethodsWithMinimalParameters(Method[] methods, String methodName) throws IllegalArgumentException {
        ArrayList<Method> targetMethods = null;
        for (Method method : methods) {
            if (!method.getName().equals(methodName)) continue;
            int numParams = method.getParameterTypes().length;
            if (targetMethods == null || numParams < ((Method)targetMethods.get(0)).getParameterTypes().length) {
                targetMethods = new ArrayList<Method>();
                targetMethods.add(method);
                continue;
            }
            if (((Method)targetMethods.get(0)).getParameterTypes().length != numParams) continue;
            targetMethods.add(method);
        }
        return targetMethods;
    }
}

