/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.util;

import ch.ralscha.extdirectspring.util.ExtDirectSpringUtil;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.type.TypeReference;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
public class JsonHandler {
    private ObjectMapper mapper = new ObjectMapper();
    private ObjectMapper indentMapper = new ObjectMapper();

    public JsonHandler() {
        this.indentMapper.getSerializationConfig().enable(SerializationConfig.Feature.INDENT_OUTPUT);
    }

    public void setMapper(ObjectMapper mapper) {
        if (mapper == null) {
            throw new IllegalArgumentException("ObjectMapper must not be null");
        }
        this.mapper = mapper;
    }

    public void setIndentMapper(ObjectMapper indentMapper) {
        if (indentMapper == null) {
            throw new IllegalArgumentException("ObjectMapper must not be null");
        }
        this.indentMapper = indentMapper;
    }

    public String writeValueAsString(Object obj) {
        return this.writeValueAsString(obj, false);
    }

    public String writeValueAsString(Object obj, boolean indent) {
        try {
            if (indent) {
                return this.indentMapper.writeValueAsString(obj);
            }
            return this.mapper.writeValueAsString(obj);
        }
        catch (Exception e) {
            LogFactory.getLog(ExtDirectSpringUtil.class).info((Object)"serialize object to json", (Throwable)e);
            return null;
        }
    }

    public <T> T readValue(String json, TypeReference<T> typeReference) {
        try {
            return (T)this.mapper.readValue(json, typeReference);
        }
        catch (Exception e) {
            LogFactory.getLog(ExtDirectSpringUtil.class).info((Object)"deserialize json to object", (Throwable)e);
            return null;
        }
    }

    public <T> T readValue(String json, Class<T> clazz) {
        try {
            return (T)this.mapper.readValue(json, clazz);
        }
        catch (Exception e) {
            LogFactory.getLog(ExtDirectSpringUtil.class).info((Object)"deserialize json to object", (Throwable)e);
            return null;
        }
    }

    public <T> T convertValue(Object object, Class<T> clazz) {
        return (T)this.mapper.convertValue(object, clazz);
    }
}

