/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.api;

import ch.ralscha.extdirectspring.api.Action;
import ch.ralscha.extdirectspring.api.PollingProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
class RemotingApi {
    private String descriptor = null;
    private final String url;
    private final String namespace;
    private final String type = "remoting";
    private final Map<String, List<Action>> actions = new HashMap<String, List<Action>>();
    private Integer timeout;
    private Integer maxRetries;
    private Object enableBuffer;
    private final List<PollingProvider> pollingProviders = new ArrayList<PollingProvider>();

    public RemotingApi(String url, String namespace) {
        this.url = url;
        this.namespace = StringUtils.hasText((String)namespace) ? namespace.trim() : null;
    }

    public Map<String, List<Action>> getActions() {
        return this.actions;
    }

    public String getType() {
        return "remoting";
    }

    public String getUrl() {
        return this.url;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(String descriptor) {
        this.descriptor = descriptor;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public Integer getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(Integer maxRetries) {
        this.maxRetries = maxRetries;
    }

    public Object getEnableBuffer() {
        return this.enableBuffer;
    }

    public void setEnableBuffer(Object enableBuffer) {
        this.enableBuffer = enableBuffer;
    }

    @JsonIgnore
    public List<PollingProvider> getPollingProviders() {
        return this.pollingProviders;
    }

    public void addAction(String beanName, String methodName, Integer len) {
        this.addAction(beanName, methodName, len, null, null);
    }

    public void addAction(String beanName, String methodName, List<String> parameterNames) {
        this.addAction(beanName, methodName, null, null, parameterNames);
    }

    public void addAction(String beanName, String methodName, Integer len, Boolean formHandler) {
        this.addAction(beanName, methodName, len, formHandler, null);
    }

    public void addAction(String beanName, String methodName, Integer len, Boolean formHandler, List<String> parameterNames) {
        Action action;
        List<Action> beanActions = this.actions.get(beanName);
        if (beanActions == null) {
            beanActions = new ArrayList<Action>();
            this.actions.put(beanName, beanActions);
        }
        if (!beanActions.contains(action = parameterNames == null ? new Action(methodName, len, formHandler) : new Action(methodName, parameterNames))) {
            beanActions.add(action);
        }
    }

    public void addPollingProvider(String beanName, String method, String event) {
        this.pollingProviders.add(new PollingProvider(beanName, method, event));
    }
}

