/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.util;

import ch.ralscha.extdirectspring.util.SupportedParameterTypes;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.GenericCollectionTypeResolver;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestParam;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterInfo {
    private Class<?> type;
    private Class<?> collectionType;
    private String name;
    private boolean hasRequestParamAnnotation;
    private boolean required;
    private String defaultValue;
    private TypeDescriptor typeDescriptor;
    private boolean supportedParameter;

    public ParameterInfo(Class<?> clazz, Method method, int paramIndex, Class<?> type, String paramName, Annotation[] paramAnnotations) {
        this.type = type;
        this.supportedParameter = SupportedParameterTypes.isSupported(type);
        this.name = paramName;
        MethodParameter methodParameter = new MethodParameter(method, paramIndex);
        this.typeDescriptor = new TypeDescriptor(methodParameter);
        if (Collection.class.isAssignableFrom(type)) {
            this.collectionType = this.getCollectionParameterType(clazz, method, paramIndex, methodParameter);
        }
        if (paramAnnotations != null) {
            for (Annotation paramAnn : paramAnnotations) {
                if (!RequestParam.class.isInstance(paramAnn)) continue;
                RequestParam requestParam = (RequestParam)paramAnn;
                if (StringUtils.hasText((String)requestParam.value())) {
                    this.name = requestParam.value();
                }
                this.required = requestParam.required();
                this.defaultValue = "\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(requestParam.defaultValue()) ? null : requestParam.defaultValue();
                this.hasRequestParamAnnotation = true;
                break;
            }
        }
    }

    public Class<?> getType() {
        return this.type;
    }

    public Class<?> getCollectionType() {
        return this.collectionType;
    }

    public String getName() {
        return this.name;
    }

    public boolean isHasRequestParamAnnotation() {
        return this.hasRequestParamAnnotation;
    }

    public boolean isRequired() {
        return this.required;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isSupportedParameter() {
        return this.supportedParameter;
    }

    public TypeDescriptor getTypeDescriptor() {
        return this.typeDescriptor;
    }

    private Class<?> getCollectionParameterType(Class<?> clazz, Method method, int paramIndex, MethodParameter methodParameter) {
        Class<?> paramType = GenericCollectionTypeResolver.getCollectionParameterType((MethodParameter)methodParameter);
        if (paramType == null) {
            Map<TypeVariable<?>, Class<?>> typeVarMap = this.getTypeVariableMap(clazz);
            paramType = this.getGenericCollectionParameterType(typeVarMap, method, paramIndex);
            for (Class<?> superClass = clazz.getSuperclass(); superClass != null && paramType == null; superClass = superClass.getSuperclass()) {
                try {
                    Method equivalentMethod = superClass.getDeclaredMethod(method.getName(), method.getParameterTypes());
                    paramType = GenericCollectionTypeResolver.getCollectionParameterType((MethodParameter)new MethodParameter(equivalentMethod, paramIndex));
                    if (paramType != null) continue;
                    paramType = this.getGenericCollectionParameterType(typeVarMap, equivalentMethod, paramIndex);
                    continue;
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
            }
        }
        return paramType;
    }

    private Class<?> getGenericCollectionParameterType(Map<TypeVariable<?>, Class<?>> typeVarMap, Method method, int paramIndex) {
        ParameterizedType parameterizedType;
        Type actualType;
        Type genericType;
        if (!typeVarMap.isEmpty() && (genericType = method.getGenericParameterTypes()[paramIndex]) instanceof ParameterizedType && (actualType = (parameterizedType = (ParameterizedType)genericType).getActualTypeArguments()[0]) instanceof TypeVariable) {
            return typeVarMap.get(actualType);
        }
        return null;
    }

    private Map<TypeVariable<?>, Class<?>> getTypeVariableMap(Class<?> c) {
        HashMap<TypeVariable<Object>, Class<Object>> varMap = new HashMap();
        Class<?> clazz = Proxy.isProxyClass(c) || AopUtils.isCglibProxyClass(c) ? c.getSuperclass() : c;
        Type genericSuperclassType = clazz.getGenericSuperclass();
        if (genericSuperclassType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericSuperclassType;
            Class[] typeArguments = GenericTypeResolver.resolveTypeArguments(clazz, clazz.getSuperclass());
            varMap = new HashMap();
            TypeVariable<Class<T>>[] typeVariables = ((Class)parameterizedType.getRawType()).getTypeParameters();
            for (int i = 0; i < typeVariables.length; ++i) {
                varMap.put(typeVariables[i], typeArguments[i]);
            }
        }
        return varMap;
    }
}

