/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.controller;

import ch.ralscha.extdirectspring.annotation.ExtDirectMethodType;
import ch.ralscha.extdirectspring.bean.ExtDirectFormLoadResult;
import ch.ralscha.extdirectspring.bean.ExtDirectPollResponse;
import ch.ralscha.extdirectspring.bean.ExtDirectRequest;
import ch.ralscha.extdirectspring.bean.ExtDirectResponse;
import ch.ralscha.extdirectspring.bean.ExtDirectStoreReadRequest;
import ch.ralscha.extdirectspring.bean.ExtDirectStoreResponse;
import ch.ralscha.extdirectspring.filter.Filter;
import ch.ralscha.extdirectspring.util.ExtDirectSpringUtil;
import ch.ralscha.extdirectspring.util.MethodInfo;
import ch.ralscha.extdirectspring.util.ParameterInfo;
import ch.ralscha.extdirectspring.util.SupportedParameterTypes;
import java.beans.PropertyDescriptor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.type.TypeReference;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.convert.support.ConversionServiceFactory;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class RouterController
implements ApplicationContextAware {
    private static final GenericConversionService genericConversionService = ConversionServiceFactory.createDefaultConversionService();
    private static final Log log = LogFactory.getLog(RouterController.class);
    private ApplicationContext context;

    public void setApplicationContext(ApplicationContext context) {
        this.context = context;
    }

    @RequestMapping(value={"/poll/{beanName}/{method}/{event}"})
    @ResponseBody
    public ExtDirectPollResponse poll(@PathVariable(value="beanName") String beanName, @PathVariable(value="method") String method, @PathVariable(value="event") String event, HttpServletRequest request, HttpServletResponse response, Locale locale) throws Exception {
        ExtDirectPollResponse directPollResponse = new ExtDirectPollResponse();
        directPollResponse.setName(event);
        try {
            MethodInfo methodInfo = ExtDirectSpringUtil.findMethodInfo(this.context, beanName, method);
            List<ParameterInfo> methodParameters = methodInfo.getParameters();
            Object[] parameters = null;
            if (!methodParameters.isEmpty()) {
                parameters = new Object[methodParameters.size()];
                for (int paramIndex = 0; paramIndex < methodParameters.size(); ++paramIndex) {
                    ParameterInfo methodParameter = methodParameters.get(paramIndex);
                    parameters[paramIndex] = methodParameter.isSupportedParameter() ? SupportedParameterTypes.resolveParameter(methodParameter.getType(), request, response, locale) : this.handleRequestParam(request, null, methodParameter);
                }
            }
            directPollResponse.setData(ExtDirectSpringUtil.invoke(this.context, beanName, methodInfo, parameters));
        }
        catch (Exception e) {
            log.error((Object)("Error on polling method '" + beanName + "." + method + "'"), (Throwable)e);
            directPollResponse.setType("exception");
            if (log.isDebugEnabled()) {
                directPollResponse.setMessage(e.getMessage());
                directPollResponse.setWhere(this.getStackTrace(e));
            }
            directPollResponse.setMessage("Server Error");
            directPollResponse.setWhere(null);
        }
        return directPollResponse;
    }

    @RequestMapping(value={"/router"}, method={RequestMethod.POST}, params={"extAction"})
    public String router(@RequestParam(value="extAction") String extAction, @RequestParam(value="extMethod") String extMethod) {
        MethodInfo methodInfo = ExtDirectSpringUtil.findMethodInfo(this.context, extAction, extMethod);
        if (methodInfo.getForwardPath() != null) {
            return methodInfo.getForwardPath();
        }
        throw new IllegalArgumentException("Invalid remoting form method: " + extAction + "." + extMethod);
    }

    @RequestMapping(value={"/router"}, method={RequestMethod.POST}, params={"!extAction"})
    @ResponseBody
    public List<ExtDirectResponse> router(HttpServletRequest request, HttpServletResponse response, Locale locale, @RequestBody String rawRequestString) {
        List<ExtDirectRequest> directRequests = this.getExtDirectRequests(rawRequestString);
        ArrayList<ExtDirectResponse> directResponses = new ArrayList<ExtDirectResponse>();
        for (ExtDirectRequest directRequest : directRequests) {
            ExtDirectResponse directResponse = new ExtDirectResponse(directRequest);
            try {
                MethodInfo methodInfo = ExtDirectSpringUtil.findMethodInfo(this.context, directRequest.getAction(), directRequest.getMethod());
                ExtDirectStoreResponse result = this.processRemotingRequest(request, response, locale, directRequest, methodInfo);
                if (result != null) {
                    if (methodInfo.isType(ExtDirectMethodType.FORM_LOAD)) {
                        if (!ExtDirectFormLoadResult.class.isAssignableFrom(result.getClass())) {
                            result = new ExtDirectFormLoadResult(result);
                        }
                    } else if (methodInfo.isType(ExtDirectMethodType.STORE_MODIFY) && !ExtDirectStoreResponse.class.isAssignableFrom(result.getClass())) {
                        result = new ExtDirectStoreResponse((Collection)((Object)result));
                    }
                }
                directResponse.setResult(result);
            }
            catch (Exception e) {
                log.error((Object)("Error on method: " + directRequest.getMethod()), (Throwable)e);
                directResponse.setType("exception");
                if (log.isDebugEnabled()) {
                    directResponse.setMessage(e.getMessage());
                    directResponse.setWhere(this.getStackTrace(e));
                }
                directResponse.setMessage("Server Error");
                directResponse.setWhere(null);
            }
            directResponses.add(directResponse);
        }
        return directResponses;
    }

    private String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        t.printStackTrace(pw);
        pw.flush();
        sw.flush();
        return sw.toString();
    }

    private Object processRemotingRequest(HttpServletRequest request, HttpServletResponse response, Locale locale, ExtDirectRequest directRequest, MethodInfo methodInfo) throws Exception {
        int jsonParamIndex = 0;
        Map<String, Object> remainingParameters = null;
        ExtDirectStoreReadRequest directStoreReadRequest = null;
        List<Object> directStoreModifyRecords = null;
        if (methodInfo.isType(ExtDirectMethodType.STORE_READ) || methodInfo.isType(ExtDirectMethodType.FORM_LOAD)) {
            if (directRequest.getData() != null && directRequest.getData().length > 0) {
                if (methodInfo.isType(ExtDirectMethodType.STORE_READ)) {
                    directStoreReadRequest = new ExtDirectStoreReadRequest();
                    remainingParameters = this.fillObjectFromMap(directStoreReadRequest, (Map)directRequest.getData()[0]);
                } else {
                    remainingParameters = (Map<String, Object>)directRequest.getData()[0];
                }
                jsonParamIndex = 1;
            }
        } else if (methodInfo.isType(ExtDirectMethodType.STORE_MODIFY)) {
            Class<?> directStoreEntryClass = methodInfo.getCollectionType();
            if (directRequest.getData() != null && directRequest.getData().length > 0) {
                LinkedHashMap jsonData = (LinkedHashMap)directRequest.getData()[0];
                ArrayList records = (ArrayList)jsonData.get("records");
                directStoreModifyRecords = this.convertObjectEntriesToType(records, directStoreEntryClass);
                jsonParamIndex = 1;
                remainingParameters = new HashMap<String, Object>();
                for (Map.Entry entry : jsonData.entrySet()) {
                    if ("records".equals(entry.getKey())) continue;
                    remainingParameters.put((String)entry.getKey(), entry.getValue());
                }
            }
        } else {
            if (methodInfo.isType(ExtDirectMethodType.POLL)) {
                throw new IllegalStateException("this controller does not handle poll calls");
            }
            if (methodInfo.isType(ExtDirectMethodType.FORM_POST)) {
                throw new IllegalStateException("this controller does not handle form posts");
            }
        }
        List<ParameterInfo> methodParameters = methodInfo.getParameters();
        Object[] parameters = null;
        if (!methodParameters.isEmpty()) {
            parameters = new Object[methodParameters.size()];
            for (int paramIndex = 0; paramIndex < methodParameters.size(); ++paramIndex) {
                ParameterInfo methodParameter = methodParameters.get(paramIndex);
                if (methodParameter.isSupportedParameter()) {
                    parameters[paramIndex] = SupportedParameterTypes.resolveParameter(methodParameter.getType(), request, response, locale);
                    continue;
                }
                if (ExtDirectStoreReadRequest.class.isAssignableFrom(methodParameter.getType())) {
                    parameters[paramIndex] = directStoreReadRequest;
                    continue;
                }
                if (directStoreModifyRecords != null && methodParameter.getCollectionType() != null) {
                    parameters[paramIndex] = directStoreModifyRecords;
                    continue;
                }
                if (methodParameter.isHasRequestParamAnnotation()) {
                    parameters[paramIndex] = this.handleRequestParam(null, remainingParameters, methodParameter);
                    continue;
                }
                if (directRequest.getData() != null && directRequest.getData().length > jsonParamIndex) {
                    Object jsonParam = directRequest.getData()[jsonParamIndex];
                    parameters[paramIndex] = methodParameter.getType().getClass().equals(String.class) ? ExtDirectSpringUtil.serializeObjectToJson(jsonParam) : (methodParameter.getType().isPrimitive() ? jsonParam : ExtDirectSpringUtil.deserializeJsonToObject(ExtDirectSpringUtil.serializeObjectToJson(jsonParam), methodParameter.getType()));
                    ++jsonParamIndex;
                    continue;
                }
                throw new IllegalArgumentException("Error, parameter mismatch. Please check your remoting method signature to ensure all supported parameters types are used.");
            }
        }
        return ExtDirectSpringUtil.invoke(this.context, directRequest.getAction(), methodInfo, parameters);
    }

    private Object handleRequestParam(HttpServletRequest request, Map<String, Object> valueContainer, ParameterInfo parameterInfo) {
        if (parameterInfo.getName() != null) {
            Object value = request != null ? request.getParameter(parameterInfo.getName()) : (valueContainer != null ? valueContainer.get(parameterInfo.getName()) : null);
            if (value == null) {
                value = parameterInfo.getDefaultValue();
            }
            if (value != null) {
                return genericConversionService.convert(value, parameterInfo.getType());
            }
            if (parameterInfo.isRequired()) {
                throw new IllegalArgumentException("Missing request parameter: " + parameterInfo.getName());
            }
        }
        return null;
    }

    private Map<String, Object> fillObjectFromMap(ExtDirectStoreReadRequest to, Map<String, Object> from) {
        HashSet<String> foundParameters = new HashSet<String>();
        for (Map.Entry<String, Object> entry : from.entrySet()) {
            if (entry.getKey().equals("filter")) {
                ArrayList<Filter> filters = new ArrayList<Filter>();
                List<Map<String, Object>> rawFilters = ExtDirectSpringUtil.deserializeJsonToObject((String)entry.getValue(), new TypeReference<List<Map<String, Object>>>(){});
                for (Map<String, Object> rawFilter : rawFilters) {
                    filters.add(Filter.createFilter(rawFilter));
                }
                to.setFilters(filters);
                foundParameters.add(entry.getKey());
                continue;
            }
            PropertyDescriptor descriptor = BeanUtils.getPropertyDescriptor(to.getClass(), (String)entry.getKey());
            if (descriptor == null || descriptor.getWriteMethod() == null) continue;
            try {
                descriptor.getWriteMethod().invoke((Object)to, genericConversionService.convert(entry.getValue(), descriptor.getPropertyType()));
                foundParameters.add(entry.getKey());
            }
            catch (IllegalArgumentException e) {
                log.error((Object)"fillObjectFromMap", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error((Object)"fillObjectFromMap", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                log.error((Object)"fillObjectFromMap", (Throwable)e);
            }
        }
        HashMap<String, Object> remainingParameters = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : from.entrySet()) {
            if (foundParameters.contains(entry.getKey())) continue;
            remainingParameters.put(entry.getKey(), entry.getValue());
        }
        return remainingParameters;
    }

    private List<Object> convertObjectEntriesToType(ArrayList<Object> records, Class<?> directStoreType) {
        if (records != null) {
            ArrayList<Object> convertedList = new ArrayList<Object>();
            for (Object record : records) {
                Object convertedObject = ExtDirectSpringUtil.deserializeJsonToObject(ExtDirectSpringUtil.serializeObjectToJson(record), directStoreType);
                convertedList.add(convertedObject);
            }
            return convertedList;
        }
        return null;
    }

    private List<ExtDirectRequest> getExtDirectRequests(String rawRequestString) {
        ArrayList<ExtDirectRequest> directRequests = new ArrayList<ExtDirectRequest>();
        if (rawRequestString.length() > 0 && rawRequestString.charAt(0) == '[') {
            directRequests.addAll((Collection<ExtDirectRequest>)ExtDirectSpringUtil.deserializeJsonToObject(rawRequestString, new TypeReference<List<ExtDirectRequest>>(){}));
        } else {
            ExtDirectRequest directRequest = ExtDirectSpringUtil.deserializeJsonToObject(rawRequestString, ExtDirectRequest.class);
            directRequests.add(directRequest);
        }
        return directRequests;
    }
}

