/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.api;

import ch.ralscha.extdirectspring.api.Action;
import ch.ralscha.extdirectspring.api.PollingProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.springframework.util.StringUtils;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
class RemotingApi {
    private String descriptor = null;
    private final String url;
    private final String namespace;
    private final String type = "remoting";
    private final Map<String, List<Action>> actions = new HashMap<String, List<Action>>();
    private final List<PollingProvider> pollingProviders = new ArrayList<PollingProvider>();

    public RemotingApi(String url, String namespace) {
        this.url = url;
        this.namespace = StringUtils.hasText((String)namespace) ? namespace.trim() : null;
    }

    public Map<String, List<Action>> getActions() {
        return this.actions;
    }

    public String getType() {
        return "remoting";
    }

    public String getUrl() {
        return this.url;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(String descriptor) {
        this.descriptor = descriptor;
    }

    @JsonIgnore
    public List<PollingProvider> getPollingProviders() {
        return this.pollingProviders;
    }

    public void addAction(String beanName, String methodName, int len) {
        this.addAction(beanName, methodName, len, null);
    }

    public void addAction(String beanName, String methodName, int len, Boolean formHandler) {
        List<Action> beanActions = this.actions.get(beanName);
        if (beanActions == null) {
            beanActions = new ArrayList<Action>();
            this.actions.put(beanName, beanActions);
        }
        beanActions.add(new Action(methodName, len, formHandler));
    }

    public void addPollingProvider(String beanName, String method, String event) {
        this.pollingProviders.add(new PollingProvider(beanName, method, event));
    }
}

