/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.util;

import ch.ralscha.extdirectspring.annotation.ExtDirectMethod;
import ch.ralscha.extdirectspring.annotation.ExtDirectMethodType;
import ch.ralscha.extdirectspring.util.ExtDirectSpringUtil;
import ch.ralscha.extdirectspring.util.ParameterInfo;
import ch.ralscha.extdirectspring.util.SupportedParameterTypes;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.core.GenericCollectionTypeResolver;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

public class MethodInfo {
    private static final LocalVariableTableParameterNameDiscoverer discoverer = new LocalVariableTableParameterNameDiscoverer();
    private List<ParameterInfo> parameters;
    private Method method;
    private String forwardPath;
    private ExtDirectMethodType type;
    private Class<?> collectionType;

    public MethodInfo(Method method) {
        ExtDirectMethod extDirectMethodAnnotation;
        this.method = method;
        RequestMapping methodAnnotation = (RequestMapping)AnnotationUtils.findAnnotation((Method)method, RequestMapping.class);
        if (methodAnnotation != null) {
            RequestMapping classAnnotation = (RequestMapping)AnnotationUtils.findAnnotation(method.getDeclaringClass(), RequestMapping.class);
            String path = null;
            if (this.hasValue(classAnnotation)) {
                path = classAnnotation.value()[0];
            }
            if (this.hasValue(methodAnnotation)) {
                String methodPath = methodAnnotation.value()[0];
                path = path != null ? path + methodPath : methodPath;
            }
            if (path != null) {
                if (path.charAt(0) == '/' && path.length() > 1) {
                    path = path.substring(1, path.length());
                }
                this.forwardPath = "forward:" + path;
            }
        }
        if ((extDirectMethodAnnotation = (ExtDirectMethod)AnnotationUtils.findAnnotation((Method)method, ExtDirectMethod.class)) != null) {
            this.type = extDirectMethodAnnotation.value();
        }
        this.parameters = MethodInfo.buildParameterList(method);
        for (ParameterInfo parameter : this.parameters) {
            if (parameter.getCollectionType() == null) continue;
            this.collectionType = parameter.getCollectionType();
            break;
        }
    }

    private boolean hasValue(RequestMapping requestMapping) {
        return requestMapping != null && requestMapping.value() != null && requestMapping.value().length > 0 && StringUtils.hasText((String)requestMapping.value()[0]);
    }

    private static List<ParameterInfo> buildParameterList(Method m) {
        ArrayList<ParameterInfo> params = new ArrayList<ParameterInfo>();
        Class<?>[] parameterTypes = m.getParameterTypes();
        Annotation[][] parameterAnnotations = null;
        String[] parameterNames = null;
        Method methodWithAnnotation = ExtDirectSpringUtil.findMethodWithAnnotation(m, ExtDirectMethod.class);
        if (methodWithAnnotation != null) {
            parameterAnnotations = methodWithAnnotation.getParameterAnnotations();
            parameterNames = discoverer.getParameterNames(methodWithAnnotation);
        }
        for (int paramIndex = 0; paramIndex < parameterTypes.length; ++paramIndex) {
            ParameterInfo parameterInfo = new ParameterInfo();
            parameterInfo.setType(parameterTypes[paramIndex]);
            parameterInfo.setSupportedParameter(SupportedParameterTypes.isSupported(parameterTypes[paramIndex]));
            if (parameterNames != null) {
                parameterInfo.setName(parameterNames[paramIndex]);
            }
            if (parameterAnnotations != null) {
                for (Annotation paramAnn : parameterAnnotations[paramIndex]) {
                    if (!RequestParam.class.isInstance(paramAnn)) continue;
                    RequestParam requestParam = (RequestParam)paramAnn;
                    if (StringUtils.hasText((String)requestParam.value())) {
                        parameterInfo.setName(requestParam.value());
                    }
                    parameterInfo.setRequired(requestParam.required());
                    parameterInfo.setDefaultValue("\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(requestParam.defaultValue()) ? null : requestParam.defaultValue());
                    parameterInfo.setHasRequestParamAnnotation(true);
                    break;
                }
            }
            if (Collection.class.isAssignableFrom(parameterTypes[paramIndex])) {
                parameterInfo.setCollectionType(GenericCollectionTypeResolver.getCollectionParameterType((MethodParameter)new MethodParameter(m, paramIndex)));
            }
            params.add(parameterInfo);
        }
        return params;
    }

    public Method getMethod() {
        return this.method;
    }

    public String getForwardPath() {
        return this.forwardPath;
    }

    public List<ParameterInfo> getParameters() {
        return this.parameters;
    }

    public Class<?> getCollectionType() {
        return this.collectionType;
    }

    public boolean isType(ExtDirectMethodType methodType) {
        return this.type == methodType;
    }
}

