/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.util;

import ch.ralscha.extdirectspring.util.ExtDirectSpringUtil;
import ch.ralscha.extdirectspring.util.MethodInfo;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public enum MethodInfoCache {
    INSTANCE;

    private final Map<Key, MethodInfo> cache = new ConcurrentHashMap<Key, MethodInfo>();

    public MethodInfo put(String beanName, String methodName, Method method) {
        if (method != null) {
            MethodInfo info = new MethodInfo(method);
            this.cache.put(new Key(beanName, methodName), info);
            return info;
        }
        return null;
    }

    public MethodInfo get(String beanName, String methodName) {
        return this.cache.get(new Key(beanName, methodName));
    }

    static final class Key {
        private final String beanName;
        private final String methodName;

        public Key(String beanName, String methodName) {
            this.beanName = beanName;
            this.methodName = methodName;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Key)) {
                return false;
            }
            Key other = (Key)o;
            return ExtDirectSpringUtil.equal(this.beanName, other.beanName) && ExtDirectSpringUtil.equal(this.methodName, other.methodName);
        }

        public int hashCode() {
            return Arrays.hashCode(new Object[]{this.beanName, this.methodName});
        }
    }
}

