/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.bean;

import ch.ralscha.extdirectspring.bean.Field;
import ch.ralscha.extdirectspring.bean.SortDirection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.map.annotate.JsonSerialize;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class MetaData {
    private final Map<String, Object> metaData = new LinkedHashMap<String, Object>();

    public MetaData() {
        this.metaData.put("root", "records");
        this.metaData.put("totalProperty", "total");
        this.metaData.put("successProperty", "success");
    }

    public void setPagingParameter(int start, int limit) {
        this.metaData.put("start", start);
        this.metaData.put("limit", limit);
    }

    public void setIdProperty(String idProperty) {
        this.metaData.put("idProperty", idProperty);
    }

    public void setSortInfo(String field, SortDirection direction) {
        LinkedHashMap<String, String> sortInfo = new LinkedHashMap<String, String>();
        sortInfo.put("field", field);
        sortInfo.put("direction", direction.getName());
        this.metaData.put("sortInfo", sortInfo);
    }

    public void addFields(List<Field> fields) {
        if (fields != null) {
            for (Field field : fields) {
                this.addField(field);
            }
        }
    }

    public void addField(Field field) {
        ArrayList<Map<String, Object>> fields = (ArrayList<Map<String, Object>>)this.metaData.get("fields");
        if (fields == null) {
            fields = new ArrayList<Map<String, Object>>();
            this.metaData.put("fields", fields);
        }
        fields.add(field.getFieldData());
    }

    public void addCustomProperty(String key, Object value) {
        this.metaData.put(key, value);
    }

    public Map<String, Object> getMetaData() {
        return Collections.unmodifiableMap(this.metaData);
    }
}

