/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.filter;

import ch.ralscha.extdirectspring.filter.BooleanFilter;
import ch.ralscha.extdirectspring.filter.Comparison;
import ch.ralscha.extdirectspring.filter.DateFilter;
import ch.ralscha.extdirectspring.filter.ListFilter;
import ch.ralscha.extdirectspring.filter.NumericFilter;
import ch.ralscha.extdirectspring.filter.StringFilter;
import java.util.Arrays;
import java.util.Map;
import org.springframework.core.convert.ConversionService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Filter {
    private final String field;

    public Filter(String field) {
        this.field = field;
    }

    public String getField() {
        return this.field;
    }

    public static Filter createFilter(Map<String, Object> jsonData, ConversionService conversionService) {
        String field = (String)jsonData.get("field");
        String type = (String)jsonData.get("type");
        if (type.equals("numeric")) {
            String comparison = (String)jsonData.get("comparison");
            Number value = (Number)conversionService.convert(jsonData.get("value"), Number.class);
            return new NumericFilter(field, value, Comparison.fromString(comparison));
        }
        if (type.equals("string")) {
            String value = (String)jsonData.get("value");
            return new StringFilter(field, value);
        }
        if (type.equals("date")) {
            String comparison = (String)jsonData.get("comparison");
            String value = (String)jsonData.get("value");
            return new DateFilter(field, value, Comparison.fromString(comparison));
        }
        if (type.equals("list")) {
            String value = (String)jsonData.get("value");
            String[] values = value.split(",");
            return new ListFilter(field, Arrays.asList(values));
        }
        if (type.equals("boolean")) {
            boolean value = (Boolean)jsonData.get("value");
            return new BooleanFilter(field, value);
        }
        return null;
    }
}

