/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.util;

import ch.ralscha.extdirectspring.annotation.ExtDirectMethod;
import ch.ralscha.extdirectspring.annotation.ExtDirectMethodType;
import ch.ralscha.extdirectspring.util.ExtDirectSpringUtil;
import ch.ralscha.extdirectspring.util.ParameterInfo;
import ch.ralscha.extdirectspring.util.SupportedParameterTypes;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.GenericCollectionTypeResolver;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodInfo {
    private static final LocalVariableTableParameterNameDiscoverer discoverer = new LocalVariableTableParameterNameDiscoverer();
    private List<ParameterInfo> parameters;
    private Method method;
    private String forwardPath;
    private ExtDirectMethodType type;
    private Class<?> collectionType;
    private boolean synchronizeOnSession;

    public MethodInfo(Class<?> clazz, Method method) {
        ExtDirectMethod extDirectMethodAnnotation;
        this.method = method;
        RequestMapping methodAnnotation = (RequestMapping)AnnotationUtils.findAnnotation((Method)method, RequestMapping.class);
        if (methodAnnotation != null) {
            RequestMapping classAnnotation = (RequestMapping)AnnotationUtils.findAnnotation(clazz, RequestMapping.class);
            String path = null;
            if (this.hasValue(classAnnotation)) {
                path = classAnnotation.value()[0];
            }
            if (this.hasValue(methodAnnotation)) {
                String methodPath = methodAnnotation.value()[0];
                path = path != null ? path + methodPath : methodPath;
            }
            if (path != null) {
                if (path.charAt(0) == '/' && path.length() > 1) {
                    path = path.substring(1, path.length());
                }
                this.forwardPath = "forward:" + path;
            }
        }
        if ((extDirectMethodAnnotation = (ExtDirectMethod)AnnotationUtils.findAnnotation((Method)method, ExtDirectMethod.class)) != null) {
            this.type = extDirectMethodAnnotation.value();
            this.synchronizeOnSession = extDirectMethodAnnotation.synchronizeOnSession();
        }
        this.parameters = MethodInfo.buildParameterList(clazz, method);
        for (ParameterInfo parameter : this.parameters) {
            if (parameter.getCollectionType() == null) continue;
            this.collectionType = parameter.getCollectionType();
            break;
        }
    }

    private boolean hasValue(RequestMapping requestMapping) {
        return requestMapping != null && requestMapping.value() != null && requestMapping.value().length > 0 && StringUtils.hasText((String)requestMapping.value()[0]);
    }

    private static List<ParameterInfo> buildParameterList(Class<?> clazz, Method method) {
        ArrayList<ParameterInfo> params = new ArrayList<ParameterInfo>();
        Class<?>[] parameterTypes = method.getParameterTypes();
        Annotation[][] parameterAnnotations = null;
        String[] parameterNames = null;
        Method methodWithAnnotation = ExtDirectSpringUtil.findMethodWithAnnotation(method, ExtDirectMethod.class);
        if (methodWithAnnotation != null) {
            parameterAnnotations = methodWithAnnotation.getParameterAnnotations();
            parameterNames = discoverer.getParameterNames(methodWithAnnotation);
        }
        for (int paramIndex = 0; paramIndex < parameterTypes.length; ++paramIndex) {
            ParameterInfo parameterInfo = new ParameterInfo();
            parameterInfo.setType(parameterTypes[paramIndex]);
            parameterInfo.setSupportedParameter(SupportedParameterTypes.isSupported(parameterTypes[paramIndex]));
            if (parameterNames != null) {
                parameterInfo.setName(parameterNames[paramIndex]);
            }
            if (parameterAnnotations != null) {
                for (Annotation paramAnn : parameterAnnotations[paramIndex]) {
                    if (!RequestParam.class.isInstance(paramAnn)) continue;
                    RequestParam requestParam = (RequestParam)paramAnn;
                    if (StringUtils.hasText((String)requestParam.value())) {
                        parameterInfo.setName(requestParam.value());
                    }
                    parameterInfo.setRequired(requestParam.required());
                    parameterInfo.setDefaultValue("\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(requestParam.defaultValue()) ? null : requestParam.defaultValue());
                    parameterInfo.setHasRequestParamAnnotation(true);
                    break;
                }
            }
            if (Collection.class.isAssignableFrom(parameterTypes[paramIndex])) {
                parameterInfo.setCollectionType(MethodInfo.getCollectionParameterType(clazz, method, paramIndex));
            }
            params.add(parameterInfo);
        }
        return params;
    }

    public Method getMethod() {
        return this.method;
    }

    public String getForwardPath() {
        return this.forwardPath;
    }

    public List<ParameterInfo> getParameters() {
        return this.parameters;
    }

    public Class<?> getCollectionType() {
        return this.collectionType;
    }

    public boolean isType(ExtDirectMethodType methodType) {
        return this.type == methodType;
    }

    public boolean isSynchronizeOnSession() {
        return this.synchronizeOnSession;
    }

    private static Class<?> getCollectionParameterType(Class<?> clazz, Method method, int paramIndex) {
        MethodParameter methodParameter = new MethodParameter(method, paramIndex);
        Class<?> paramType = GenericCollectionTypeResolver.getCollectionParameterType((MethodParameter)methodParameter);
        if (paramType == null) {
            Map<TypeVariable<?>, Class<?>> typeVarMap = MethodInfo.getTypeVariableMap(clazz);
            paramType = MethodInfo.getGenericCollectionParameterType(typeVarMap, method, paramIndex);
            for (Class<?> superClass = clazz.getSuperclass(); superClass != null && paramType == null; superClass = superClass.getSuperclass()) {
                try {
                    Method equivalentMethod = superClass.getDeclaredMethod(method.getName(), method.getParameterTypes());
                    paramType = GenericCollectionTypeResolver.getCollectionParameterType((MethodParameter)new MethodParameter(equivalentMethod, paramIndex));
                    if (paramType != null) continue;
                    paramType = MethodInfo.getGenericCollectionParameterType(typeVarMap, equivalentMethod, paramIndex);
                    continue;
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
            }
        }
        return paramType;
    }

    private static Class<?> getGenericCollectionParameterType(Map<TypeVariable<?>, Class<?>> typeVarMap, Method method, int paramIndex) {
        ParameterizedType parameterizedType;
        Type actualType;
        Type genericType;
        if (!typeVarMap.isEmpty() && (genericType = method.getGenericParameterTypes()[paramIndex]) instanceof ParameterizedType && (actualType = (parameterizedType = (ParameterizedType)genericType).getActualTypeArguments()[0]) instanceof TypeVariable) {
            return typeVarMap.get(actualType);
        }
        return null;
    }

    private static Map<TypeVariable<?>, Class<?>> getTypeVariableMap(Class<?> c) {
        HashMap<TypeVariable<Object>, Class<Object>> varMap = new HashMap();
        Class<?> clazz = Proxy.isProxyClass(c) || AopUtils.isCglibProxyClass(c) ? c.getSuperclass() : c;
        Type genericSuperclassType = clazz.getGenericSuperclass();
        if (genericSuperclassType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericSuperclassType;
            Class[] typeArguments = GenericTypeResolver.resolveTypeArguments(clazz, clazz.getSuperclass());
            varMap = new HashMap();
            TypeVariable<Class<T>>[] typeVariables = ((Class)parameterizedType.getRawType()).getTypeParameters();
            for (int i = 0; i < typeVariables.length; ++i) {
                varMap.put(typeVariables[i], typeArguments[i]);
            }
        }
        return varMap;
    }
}

