/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.annotation;

import ch.ralscha.extdirectspring.annotation.ExtDirectMethod;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ExtDirectMethodType {
    SIMPLE{

        @Override
        public boolean isValid(String methodName, Class<?> clazz, Method method) {
            Annotation[][] allParameterAnnotations;
            ExtDirectMethod extDirectMethodAnnotation = (ExtDirectMethod)AnnotationUtils.findAnnotation((Method)method, ExtDirectMethod.class);
            if (StringUtils.hasText((String)extDirectMethodAnnotation.event())) {
                log.warn((Object)("SIMPLE method '" + methodName + "' does not support event attribute of @ExtDirectMethod"));
            }
            if (extDirectMethodAnnotation.entryClass() != Object.class) {
                log.warn((Object)("SIMPLE method '" + methodName + "' does not support entryClass attribute of @ExtDirectMethod"));
            }
            Annotation[][] arr$ = allParameterAnnotations = method.getParameterAnnotations();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Annotation[] paramAnnotations;
                for (Annotation paramAnnotation : paramAnnotations = arr$[i$]) {
                    if (!RequestParam.class.isInstance(paramAnnotation)) continue;
                    log.error((Object)("SIMPLE method '" + methodName + "' contains a non supported parameter annotation @RequestParam"));
                    return false;
                }
            }
            return true;
        }
    }
    ,
    SIMPLE_NAMED{

        @Override
        public boolean isValid(String methodName, Class<?> clazz, Method method) {
            ExtDirectMethod extDirectMethodAnnotation = (ExtDirectMethod)AnnotationUtils.findAnnotation((Method)method, ExtDirectMethod.class);
            if (StringUtils.hasText((String)extDirectMethodAnnotation.event())) {
                log.warn((Object)("SIMPLE_NAMED method '" + methodName + "' does not support event attribute of @ExtDirectMethod"));
            }
            if (extDirectMethodAnnotation.entryClass() != Object.class) {
                log.warn((Object)("SIMPLE_NAMED method '" + methodName + "' does not support entryClass attribute of @ExtDirectMethod"));
            }
            return true;
        }
    }
    ,
    FORM_LOAD{

        @Override
        public boolean isValid(String methodName, Class<?> clazz, Method method) {
            ExtDirectMethod extDirectMethodAnnotation = (ExtDirectMethod)AnnotationUtils.findAnnotation((Method)method, ExtDirectMethod.class);
            if (StringUtils.hasText((String)extDirectMethodAnnotation.event())) {
                log.warn((Object)("FORM_LOAD method '" + methodName + "' does not support event attribute of @ExtDirectMethod"));
            }
            if (extDirectMethodAnnotation.entryClass() != Object.class) {
                log.warn((Object)("FORM_LOAD method '" + methodName + "' does not support entryClass attribute of @ExtDirectMethod"));
            }
            return true;
        }
    }
    ,
    STORE_READ{

        @Override
        public boolean isValid(String methodName, Class<?> clazz, Method method) {
            ExtDirectMethod extDirectMethodAnnotation = (ExtDirectMethod)AnnotationUtils.findAnnotation((Method)method, ExtDirectMethod.class);
            if (StringUtils.hasText((String)extDirectMethodAnnotation.event())) {
                log.warn((Object)("STORE_READ method '" + methodName + "' does not support event attribute of @ExtDirectMethod"));
            }
            if (extDirectMethodAnnotation.entryClass() != Object.class) {
                log.warn((Object)("STORE_READ method '" + methodName + "' does not support entryClass attribute of @ExtDirectMethod"));
            }
            return true;
        }
    }
    ,
    STORE_MODIFY{

        @Override
        public boolean isValid(String methodName, Class<?> clazz, Method method) {
            ExtDirectMethod extDirectMethodAnnotation = (ExtDirectMethod)AnnotationUtils.findAnnotation((Method)method, ExtDirectMethod.class);
            if (StringUtils.hasText((String)extDirectMethodAnnotation.event())) {
                log.warn((Object)("STORE_MODIFY method '" + methodName + "' does not support event attribute of @ExtDirectMethod"));
            }
            return true;
        }
    }
    ,
    FORM_POST{

        @Override
        public boolean isValid(String methodName, Class<?> clazz, Method method) {
            ExtDirectMethod extDirectMethodAnnotation;
            RequestMapping methodAnnotation;
            boolean isValid = true;
            if (!method.getReturnType().equals(Void.TYPE)) {
                log.error((Object)("FORM_POST method '" + methodName + "' must return void"));
                isValid = false;
            }
            if (AnnotationUtils.findAnnotation((Method)method, ResponseBody.class) != null) {
                log.warn((Object)("FORM_POST method '" + methodName + "' should not have a @ResponseBody annotation"));
            }
            if (AnnotationUtils.findAnnotation(clazz, Controller.class) == null) {
                log.error((Object)("FORM_POST method '" + methodName + "' must be a member of a @Controller bean"));
                isValid = false;
            }
            if ((methodAnnotation = (RequestMapping)AnnotationUtils.findAnnotation((Method)method, RequestMapping.class)) == null) {
                log.error((Object)("FORM_POST method '" + methodName + "' must be annotated with @RequestMapping"));
                isValid = false;
            }
            RequestMapping classAnnotation = (RequestMapping)AnnotationUtils.findAnnotation(clazz, RequestMapping.class);
            boolean hasValue = false;
            if (classAnnotation != null) {
                boolean bl = hasValue = classAnnotation.value() != null && classAnnotation.value().length > 0;
            }
            if (methodAnnotation != null && !hasValue) {
                boolean bl = hasValue = methodAnnotation.value() != null && methodAnnotation.value().length > 0;
            }
            if (!hasValue) {
                log.error((Object)("FORM_POST method '" + methodName + "' must have a @RequestMapping annotation with a value"));
                isValid = false;
            }
            if (methodAnnotation != null) {
                boolean hasPostRequestMethod = false;
                for (RequestMethod requestMethod : methodAnnotation.method()) {
                    if (!requestMethod.equals((Object)RequestMethod.POST)) continue;
                    hasPostRequestMethod = true;
                    break;
                }
                if (!hasPostRequestMethod) {
                    log.error((Object)("FORM_POST method '" + methodName + "' must have a @RequestMapping annotation with method = RequestMethod.POST"));
                    isValid = false;
                }
            }
            if (StringUtils.hasText((String)(extDirectMethodAnnotation = (ExtDirectMethod)AnnotationUtils.findAnnotation((Method)method, ExtDirectMethod.class)).event())) {
                log.warn((Object)("FORM_POST method '" + methodName + "' does not support event attribute of @ExtDirectMethod"));
            }
            if (extDirectMethodAnnotation.entryClass() != Object.class) {
                log.warn((Object)("FORM_POST method '" + methodName + "' does not support entryClass attribute of @ExtDirectMethod"));
            }
            if (extDirectMethodAnnotation.synchronizeOnSession()) {
                log.warn((Object)("FORM_POST method '" + methodName + "' does not support synchronizeOnSession attribute of @ExtDirectMethod"));
            }
            return isValid;
        }
    }
    ,
    TREE_LOAD{

        @Override
        public boolean isValid(String methodName, Class<?> clazz, Method method) {
            ExtDirectMethod extDirectMethodAnnotation = (ExtDirectMethod)AnnotationUtils.findAnnotation((Method)method, ExtDirectMethod.class);
            if (StringUtils.hasText((String)extDirectMethodAnnotation.event())) {
                log.warn((Object)("TREE_LOAD method '" + methodName + "' does not support event attribute of @ExtDirectMethod"));
            }
            if (extDirectMethodAnnotation.entryClass() != Object.class) {
                log.warn((Object)("TREE_LOAD method '" + methodName + "' does not support entryClass attribute of @ExtDirectMethod"));
            }
            return true;
        }
    }
    ,
    POLL{

        @Override
        public boolean isValid(String methodName, Class<?> clazz, Method method) {
            ExtDirectMethod extDirectMethodAnnotation = (ExtDirectMethod)AnnotationUtils.findAnnotation((Method)method, ExtDirectMethod.class);
            if (extDirectMethodAnnotation.entryClass() != Object.class) {
                log.warn((Object)("POLL method '" + methodName + "' does not support entryClass attribute of @ExtDirectMethod"));
            }
            return true;
        }
    };

    static final Log log;

    public abstract boolean isValid(String var1, Class<?> var2, Method var3);

    static {
        log = LogFactory.getLog(ExtDirectMethodType.class);
    }
}

