/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.controller;

import ch.ralscha.extdirectspring.bean.api.PollingProvider;
import ch.ralscha.extdirectspring.bean.api.RemotingApi;
import ch.ralscha.extdirectspring.controller.RouterController;
import ch.ralscha.extdirectspring.util.ApiCache;
import ch.ralscha.extdirectspring.util.ApiCacheKey;
import ch.ralscha.extdirectspring.util.ExtDirectSpringUtil;
import ch.ralscha.extdirectspring.util.MethodInfo;
import ch.ralscha.extdirectspring.util.MethodInfoCache;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.NumberUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class ApiController {
    @Autowired
    private RouterController routerController;

    @RequestMapping(value={"/api.js", "/api-debug.js"}, method={RequestMethod.GET})
    public void api(@RequestParam(value="apiNs", required=false, defaultValue="Ext.app") String apiNs, @RequestParam(value="actionNs", required=false) String actionNs, @RequestParam(value="remotingApiVar", required=false, defaultValue="REMOTING_API") String remotingApiVar, @RequestParam(value="pollingUrlsVar", required=false, defaultValue="POLLING_URLS") String pollingUrlsVar, @RequestParam(value="group", required=false) String group, @RequestParam(value="fullRouterUrl", required=false, defaultValue="false") boolean fullRouterUrl, @RequestParam(value="format", required=false) String format, HttpServletRequest request, HttpServletResponse response) throws IOException {
        ServletOutputStream outputStream = response.getOutputStream();
        if (format == null) {
            response.setContentType("application/x-javascript");
            String requestUrlString = fullRouterUrl ? request.getRequestURL().toString() : request.getRequestURI();
            boolean debug = requestUrlString.contains("api-debug.js");
            ApiCacheKey apiKey = new ApiCacheKey(apiNs, actionNs, remotingApiVar, pollingUrlsVar, group, debug);
            String apiString = ApiCache.INSTANCE.get(apiKey);
            if (apiString == null) {
                String basePollUrl;
                String routerUrl;
                if (!debug) {
                    routerUrl = requestUrlString.replace("api.js", "router");
                    basePollUrl = requestUrlString.replace("api.js", "poll");
                } else {
                    routerUrl = requestUrlString.replace("api-debug.js", "router");
                    basePollUrl = requestUrlString.replace("api-debug.js", "poll");
                }
                apiString = this.buildApiString(apiNs, actionNs, remotingApiVar, pollingUrlsVar, routerUrl, basePollUrl, group, debug);
                ApiCache.INSTANCE.put(apiKey, apiString);
            }
            response.setContentLength(apiString.getBytes().length);
            outputStream.write(apiString.getBytes());
        } else {
            response.setContentType(RouterController.APPLICATION_JSON.toString());
            response.setCharacterEncoding(RouterController.APPLICATION_JSON.getCharSet().name());
            String requestUrlString = request.getRequestURL().toString();
            boolean debug = requestUrlString.contains("api-debug.js");
            String routerUrl = !debug ? requestUrlString.replace("api.js", "router") : requestUrlString.replace("api-debug.js", "router");
            String apiString = this.buildApiJson(apiNs, actionNs, remotingApiVar, routerUrl, group, debug);
            response.setContentLength(apiString.getBytes().length);
            outputStream.write(apiString.getBytes());
        }
        outputStream.flush();
    }

    private String buildApiString(String apiNs, String actionNs, String remotingApiVar, String pollingUrlsVar, String routerUrl, String basePollUrl, String group, boolean debug) {
        List<PollingProvider> pollingProviders;
        RemotingApi remotingApi = new RemotingApi(routerUrl, actionNs);
        remotingApi.setTimeout(this.routerController.getConfiguration().getTimeout());
        remotingApi.setMaxRetries(this.routerController.getConfiguration().getMaxRetries());
        Object enableBuffer = this.routerController.getConfiguration().getEnableBuffer();
        if (enableBuffer instanceof String && StringUtils.hasText((String)((String)enableBuffer))) {
            String enableBufferString = (String)enableBuffer;
            if (enableBufferString.equalsIgnoreCase("true")) {
                remotingApi.setEnableBuffer(true);
            } else if (enableBufferString.equalsIgnoreCase("false")) {
                remotingApi.setEnableBuffer(false);
            } else {
                Integer enableBufferMs = (Integer)NumberUtils.parseNumber((String)enableBufferString, Integer.class);
                remotingApi.setEnableBuffer(enableBufferMs);
            }
        } else if (enableBuffer instanceof Number || enableBuffer instanceof Boolean) {
            remotingApi.setEnableBuffer(enableBuffer);
        }
        this.buildRemotingApi(remotingApi, group);
        StringBuilder sb = new StringBuilder();
        if (StringUtils.hasText((String)apiNs)) {
            sb.append("Ext.ns('");
            sb.append(apiNs);
            sb.append("');");
        }
        if (debug) {
            sb.append("\n\n");
        }
        if (StringUtils.hasText((String)actionNs)) {
            sb.append("Ext.ns('");
            sb.append(actionNs);
            sb.append("');");
            if (debug) {
                sb.append("\n\n");
            }
        }
        String jsonConfig = this.routerController.getJsonHandler().writeValueAsString(remotingApi, debug);
        if (StringUtils.hasText((String)apiNs)) {
            sb.append(apiNs).append(".");
        }
        sb.append(remotingApiVar).append(" = ");
        sb.append(jsonConfig);
        sb.append(";");
        if (debug) {
            sb.append("\n\n");
        }
        if (!(pollingProviders = remotingApi.getPollingProviders()).isEmpty()) {
            if (StringUtils.hasText((String)apiNs)) {
                sb.append(apiNs).append(".");
            }
            sb.append(pollingUrlsVar).append(" = {");
            if (debug) {
                sb.append("\n");
            }
            for (int i = 0; i < pollingProviders.size(); ++i) {
                if (debug) {
                    sb.append("  ");
                }
                sb.append("\"");
                sb.append(pollingProviders.get(i).getEvent());
                sb.append("\"");
                sb.append(" : \"").append(basePollUrl).append("/");
                sb.append(pollingProviders.get(i).getBeanName());
                sb.append("/");
                sb.append(pollingProviders.get(i).getMethod());
                sb.append("/");
                sb.append(pollingProviders.get(i).getEvent());
                sb.append("\"");
                if (i >= pollingProviders.size() - 1) continue;
                sb.append(",");
                if (!debug) continue;
                sb.append("\n");
            }
            if (debug) {
                sb.append("\n");
            }
            sb.append("};");
        }
        return sb.toString();
    }

    private String buildApiJson(String apiNs, String actionNs, String remotingApiVar, String routerUrl, String group, boolean debug) {
        RemotingApi remotingApi = new RemotingApi(routerUrl, actionNs);
        if (StringUtils.hasText((String)apiNs)) {
            remotingApi.setDescriptor(apiNs + "." + remotingApiVar);
        } else {
            remotingApi.setDescriptor(remotingApiVar);
        }
        this.buildRemotingApi(remotingApi, group);
        return this.routerController.getJsonHandler().writeValueAsString(remotingApi, debug);
    }

    private void buildRemotingApi(RemotingApi remotingApi, String group) {
        for (Map.Entry<MethodInfoCache.Key, MethodInfo> entry : MethodInfoCache.INSTANCE) {
            MethodInfo methodInfo = entry.getValue();
            if (!this.isSameGroup(group, methodInfo.getGroup())) continue;
            if (methodInfo.getAction() != null) {
                remotingApi.addAction(entry.getKey().getBeanName(), methodInfo.getAction());
                continue;
            }
            remotingApi.addPollingProvider(methodInfo.getPollingProvider());
        }
    }

    private boolean isSameGroup(String requestedGroupString, String annotationGroupString) {
        if (requestedGroupString != null) {
            if (annotationGroupString != null) {
                for (String requestedGroup : requestedGroupString.split(",")) {
                    for (String annotationGroup : annotationGroupString.split(",")) {
                        if (!ExtDirectSpringUtil.equal(requestedGroup, annotationGroup)) continue;
                        return true;
                    }
                }
            }
            return false;
        }
        return true;
    }
}

