/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.controller;

import ch.ralscha.extdirectspring.annotation.ExtDirectMethod;
import ch.ralscha.extdirectspring.controller.RouterController;
import ch.ralscha.extdirectspring.util.ExtDirectSpringUtil;
import ch.ralscha.extdirectspring.util.MethodInfoCache;
import java.lang.reflect.Method;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class MethodRegistrar
implements ApplicationListener<ContextRefreshedEvent> {
    private static final Log log = LogFactory.getLog(RouterController.class);

    public void onApplicationEvent(ContextRefreshedEvent event) {
        String[] beanNames;
        ApplicationContext context = (ApplicationContext)event.getSource();
        for (String beanName : beanNames = context.getBeanNamesForType(Object.class)) {
            Class handlerType = context.getType(beanName);
            Class userType = ClassUtils.getUserClass((Class)handlerType);
            Set<Method> methods = ExtDirectSpringUtil.selectMethods(userType, new ReflectionUtils.MethodFilter(){

                public boolean matches(Method method) {
                    return AnnotationUtils.findAnnotation((Method)method, ExtDirectMethod.class) != null;
                }
            });
            for (Method method : methods) {
                ExtDirectMethod directMethodAnnotation = (ExtDirectMethod)AnnotationUtils.findAnnotation((Method)method, ExtDirectMethod.class);
                String beanMethodName = beanName + "." + method.getName();
                if (!directMethodAnnotation.value().isValid(beanMethodName, userType, method)) continue;
                MethodInfoCache.INSTANCE.put(beanName, handlerType, method);
                if (!log.isDebugEnabled()) continue;
                String info = "Register " + beanMethodName + "(" + (Object)((Object)directMethodAnnotation.value());
                if (StringUtils.hasText((String)directMethodAnnotation.group())) {
                    info = info + ", " + directMethodAnnotation.group();
                }
                info = info + ")";
                log.debug((Object)info);
            }
        }
    }
}

