/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.controller;

import ch.ralscha.extdirectspring.annotation.ExtDirectMethodType;
import ch.ralscha.extdirectspring.bean.BaseResponse;
import ch.ralscha.extdirectspring.bean.ExtDirectFormLoadResult;
import ch.ralscha.extdirectspring.bean.ExtDirectPollResponse;
import ch.ralscha.extdirectspring.bean.ExtDirectRequest;
import ch.ralscha.extdirectspring.bean.ExtDirectResponse;
import ch.ralscha.extdirectspring.bean.ExtDirectStoreReadRequest;
import ch.ralscha.extdirectspring.bean.ExtDirectStoreResponse;
import ch.ralscha.extdirectspring.bean.GroupInfo;
import ch.ralscha.extdirectspring.bean.SortDirection;
import ch.ralscha.extdirectspring.bean.SortInfo;
import ch.ralscha.extdirectspring.controller.Configuration;
import ch.ralscha.extdirectspring.filter.Filter;
import ch.ralscha.extdirectspring.util.ExtDirectSpringUtil;
import ch.ralscha.extdirectspring.util.JsonHandler;
import ch.ralscha.extdirectspring.util.MethodInfo;
import ch.ralscha.extdirectspring.util.MethodInfoCache;
import ch.ralscha.extdirectspring.util.ParameterInfo;
import ch.ralscha.extdirectspring.util.SupportedParameters;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.util.WebUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Controller
public class RouterController
implements InitializingBean {
    public static final MediaType APPLICATION_JSON = new MediaType("application", "json", Charset.forName("UTF-8"));
    public static final MediaType TEXT_HTML = new MediaType("text", "html", Charset.forName("UTF-8"));
    private static final Log log = LogFactory.getLog(RouterController.class);
    @Autowired
    private ConversionService conversionService;
    @Autowired
    private ApplicationContext context;
    @Autowired(required=false)
    private JsonHandler jsonHandler;
    @Autowired(required=false)
    private Configuration configuration;

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public JsonHandler getJsonHandler() {
        return this.jsonHandler;
    }

    public void afterPropertiesSet() {
        if (this.configuration == null) {
            this.configuration = new Configuration();
        }
        if (this.jsonHandler == null) {
            this.jsonHandler = new JsonHandler();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/poll/{beanName}/{method}/{event}"})
    public void poll(@PathVariable(value="beanName") String beanName, @PathVariable(value="method") String method, @PathVariable(value="event") String event, HttpServletRequest request, HttpServletResponse response, Locale locale) throws Exception {
        boolean streamResponse;
        ExtDirectPollResponse directPollResponse;
        block11: {
            directPollResponse = new ExtDirectPollResponse();
            directPollResponse.setName(event);
            MethodInfo methodInfo = MethodInfoCache.INSTANCE.get(beanName, method);
            if (methodInfo != null) {
                streamResponse = this.configuration.isStreamResponse() || methodInfo.isStreamResponse();
                try {
                    List<ParameterInfo> methodParameters = methodInfo.getParameters();
                    Object[] parameters = null;
                    if (!methodParameters.isEmpty()) {
                        parameters = new Object[methodParameters.size()];
                        for (int paramIndex = 0; paramIndex < methodParameters.size(); ++paramIndex) {
                            ParameterInfo methodParameter = methodParameters.get(paramIndex);
                            parameters[paramIndex] = methodParameter.isSupportedParameter() ? SupportedParameters.resolveParameter(methodParameter.getType(), request, response, locale) : (methodParameter.isHasRequestHeaderAnnotation() ? this.handleRequestHeader(request, methodParameter) : this.handleRequestParam(request, null, methodParameter));
                        }
                    }
                    if (this.configuration.isSynchronizeOnSession() || methodInfo.isSynchronizeOnSession()) {
                        HttpSession session = request.getSession(false);
                        if (session != null) {
                            Object mutex;
                            Object object = mutex = WebUtils.getSessionMutex((HttpSession)session);
                            synchronized (object) {
                                directPollResponse.setData(ExtDirectSpringUtil.invoke(this.context, beanName, methodInfo, parameters));
                                break block11;
                            }
                        }
                        directPollResponse.setData(ExtDirectSpringUtil.invoke(this.context, beanName, methodInfo, parameters));
                        break block11;
                    }
                    directPollResponse.setData(ExtDirectSpringUtil.invoke(this.context, beanName, methodInfo, parameters));
                }
                catch (Exception e) {
                    log.error((Object)("Error polling method '" + beanName + "." + method + "'"), e.getCause() != null ? e.getCause() : e);
                    this.handleException(directPollResponse, e);
                }
            } else {
                log.error((Object)("Error invoking method '" + beanName + "." + method + "'. Method or Bean not found"));
                this.handleMethodNotFoundError(directPollResponse, beanName, method);
                streamResponse = this.configuration.isStreamResponse();
            }
        }
        this.writeJsonResponse(response, directPollResponse, streamResponse);
    }

    @RequestMapping(value={"/router"}, method={RequestMethod.POST}, params={"extAction"})
    public String router(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="extAction") String extAction, @RequestParam(value="extMethod") String extMethod) throws IOException {
        MethodInfo methodInfo = MethodInfoCache.INSTANCE.get(extAction, extMethod);
        if (methodInfo != null && methodInfo.getForwardPath() != null) {
            return methodInfo.getForwardPath();
        }
        log.error((Object)("Error invoking method '" + extAction + "." + extMethod + "'. Method  or Bean not found"));
        ExtDirectResponse directResponse = new ExtDirectResponse(request);
        this.handleMethodNotFoundError(directResponse, extAction, extMethod);
        this.writeJsonResponse(response, directResponse, this.configuration.isStreamResponse());
        return null;
    }

    @RequestMapping(value={"/router"}, method={RequestMethod.POST}, params={"!extAction"})
    public void router(HttpServletRequest request, HttpServletResponse response, Locale locale) throws IOException {
        Object requestData = this.jsonHandler.readValue((InputStream)request.getInputStream(), Object.class);
        ArrayList<ExtDirectRequest> directRequests = new ArrayList<ExtDirectRequest>();
        if (requestData instanceof Map) {
            directRequests.add(this.jsonHandler.convertValue(requestData, ExtDirectRequest.class));
        } else if (requestData instanceof List) {
            for (Object oneRequest : (List)requestData) {
                directRequests.add(this.jsonHandler.convertValue(oneRequest, ExtDirectRequest.class));
            }
        }
        ArrayList<ExtDirectResponse> directResponses = new ArrayList<ExtDirectResponse>();
        boolean streamResponse = this.configuration.isStreamResponse();
        for (ExtDirectRequest directRequest : directRequests) {
            ExtDirectResponse directResponse = new ExtDirectResponse(directRequest);
            MethodInfo methodInfo = MethodInfoCache.INSTANCE.get(directRequest.getAction(), directRequest.getMethod());
            if (methodInfo != null) {
                try {
                    streamResponse = streamResponse || methodInfo.isStreamResponse();
                    ExtDirectStoreResponse<Object> result = this.processRemotingRequest(request, response, locale, directRequest, methodInfo);
                    if (result != null) {
                        if (methodInfo.isType(ExtDirectMethodType.FORM_LOAD) && !ExtDirectFormLoadResult.class.isAssignableFrom(result.getClass())) {
                            result = new ExtDirectFormLoadResult(result);
                        } else if ((methodInfo.isType(ExtDirectMethodType.STORE_MODIFY) || methodInfo.isType(ExtDirectMethodType.STORE_READ)) && !ExtDirectStoreResponse.class.isAssignableFrom(result.getClass()) && this.configuration.isAlwaysWrapStoreResponse()) {
                            if (result instanceof Collection) {
                                result = new ExtDirectStoreResponse((Collection)((Object)result));
                            } else {
                                ArrayList responses = new ArrayList();
                                responses.add(result);
                                result = new ExtDirectStoreResponse(responses);
                            }
                        }
                        directResponse.setResult(result);
                    } else if (methodInfo.isType(ExtDirectMethodType.STORE_MODIFY) || methodInfo.isType(ExtDirectMethodType.STORE_READ)) {
                        directResponse.setResult(Collections.emptyList());
                    }
                }
                catch (Exception e) {
                    log.error((Object)("Error calling method: " + directRequest.getMethod()), e.getCause() != null ? e.getCause() : e);
                    this.handleException(directResponse, e);
                }
            } else {
                log.error((Object)("Error invoking method '" + directRequest.getAction() + "." + directRequest.getMethod() + "'. Method or Bean not found"));
                this.handleMethodNotFoundError(directResponse, directRequest.getAction(), directRequest.getMethod());
            }
            directResponses.add(directResponse);
        }
        this.writeJsonResponse(response, directResponses, streamResponse);
    }

    public void writeJsonResponse(HttpServletResponse response, Object responseObject, boolean streamResponse) throws IOException, JsonGenerationException, JsonMappingException {
        response.setContentType(APPLICATION_JSON.toString());
        response.setCharacterEncoding(APPLICATION_JSON.getCharSet().name());
        ObjectMapper objectMapper = this.jsonHandler.getMapper();
        ServletOutputStream outputStream = response.getOutputStream();
        if (!streamResponse) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
            JsonGenerator jsonGenerator = objectMapper.getJsonFactory().createJsonGenerator((OutputStream)bos, JsonEncoding.UTF8);
            objectMapper.writeValue(jsonGenerator, responseObject);
            response.setContentLength(bos.size());
            outputStream.write(bos.toByteArray());
        } else {
            JsonGenerator jsonGenerator = objectMapper.getJsonFactory().createJsonGenerator((OutputStream)outputStream, JsonEncoding.UTF8);
            objectMapper.writeValue(jsonGenerator, responseObject);
        }
        outputStream.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object processRemotingRequest(HttpServletRequest request, HttpServletResponse response, Locale locale, ExtDirectRequest directRequest, MethodInfo methodInfo) throws Exception {
        HttpSession session;
        Object data;
        int jsonParamIndex = 0;
        Map<String, Object> remainingParameters = null;
        ExtDirectStoreReadRequest ExtDirectStoreReadRequest2 = null;
        List<Object> directStoreModifyRecords = null;
        if (methodInfo.isType(ExtDirectMethodType.STORE_READ) || methodInfo.isType(ExtDirectMethodType.FORM_LOAD) || methodInfo.isType(ExtDirectMethodType.TREE_LOAD)) {
            data = (List)directRequest.getData();
            if (data != null && data.size() > 0) {
                if (methodInfo.isType(ExtDirectMethodType.STORE_READ)) {
                    ExtDirectStoreReadRequest2 = new ExtDirectStoreReadRequest();
                    remainingParameters = this.fillReadRequestFromMap(ExtDirectStoreReadRequest2, (Map)data.get(0));
                } else {
                    remainingParameters = (Map<String, Object>)data.get(0);
                }
                jsonParamIndex = 1;
            }
        } else if (methodInfo.isType(ExtDirectMethodType.STORE_MODIFY)) {
            Object obj;
            Class<?> directStoreEntryClass = methodInfo.getCollectionType();
            data = (List)directRequest.getData();
            if (directStoreEntryClass != null && data != null && data.size() > 0) {
                obj = data.get(0);
                if (obj instanceof List) {
                    directStoreModifyRecords = this.convertObjectEntriesToType((List)obj, directStoreEntryClass);
                } else {
                    Map jsonData = (Map)obj;
                    Object records = jsonData.get("records");
                    if (records != null) {
                        if (records instanceof List) {
                            directStoreModifyRecords = this.convertObjectEntriesToType((List)records, directStoreEntryClass);
                        } else {
                            directStoreModifyRecords = new ArrayList<Object>();
                            directStoreModifyRecords.add(this.jsonHandler.convertValue(records, directStoreEntryClass));
                        }
                        remainingParameters = new HashMap<String, Object>(jsonData);
                        remainingParameters.remove("records");
                    } else {
                        directStoreModifyRecords = new ArrayList<Object>();
                        directStoreModifyRecords.add(this.jsonHandler.convertValue(jsonData, directStoreEntryClass));
                    }
                }
                jsonParamIndex = 1;
            } else if (data != null && data.size() > 0 && (obj = data.get(0)) instanceof Map) {
                remainingParameters = new HashMap<String, Object>((Map)obj);
                remainingParameters.remove("records");
            }
        } else if (methodInfo.isType(ExtDirectMethodType.SIMPLE_NAMED)) {
            data = (Map)directRequest.getData();
            if (data != null && data.size() > 0) {
                remainingParameters = new HashMap<String, Object>((Map<String, Object>)data);
            }
        } else {
            if (methodInfo.isType(ExtDirectMethodType.POLL)) {
                throw new IllegalStateException("this controller does not handle poll calls");
            }
            if (methodInfo.isType(ExtDirectMethodType.FORM_POST)) {
                throw new IllegalStateException("this controller does not handle form posts");
            }
        }
        List<ParameterInfo> methodParameters = methodInfo.getParameters();
        Object[] parameters = null;
        if (!methodParameters.isEmpty()) {
            parameters = new Object[methodParameters.size()];
            for (int paramIndex = 0; paramIndex < methodParameters.size(); ++paramIndex) {
                Object jsonValue;
                ParameterInfo methodParameter = methodParameters.get(paramIndex);
                if (methodParameter.isSupportedParameter()) {
                    parameters[paramIndex] = SupportedParameters.resolveParameter(methodParameter.getType(), request, response, locale);
                    continue;
                }
                if (ExtDirectStoreReadRequest.class.isAssignableFrom(methodParameter.getType())) {
                    parameters[paramIndex] = ExtDirectStoreReadRequest2;
                    continue;
                }
                if (directStoreModifyRecords != null && methodParameter.getCollectionType() != null) {
                    parameters[paramIndex] = directStoreModifyRecords;
                    continue;
                }
                if (methodParameter.isHasRequestParamAnnotation()) {
                    parameters[paramIndex] = this.handleRequestParam(null, remainingParameters, methodParameter);
                    continue;
                }
                if (methodParameter.isHasRequestHeaderAnnotation()) {
                    parameters[paramIndex] = this.handleRequestHeader(request, methodParameter);
                    continue;
                }
                if (remainingParameters != null && remainingParameters.containsKey(methodParameter.getName())) {
                    jsonValue = remainingParameters.get(methodParameter.getName());
                    parameters[paramIndex] = this.convertValue(jsonValue, methodParameter);
                    continue;
                }
                if (directRequest.getData() != null && directRequest.getData() instanceof List && ((List)directRequest.getData()).size() > jsonParamIndex) {
                    jsonValue = ((List)directRequest.getData()).get(jsonParamIndex);
                    parameters[paramIndex] = this.convertValue(jsonValue, methodParameter);
                    ++jsonParamIndex;
                    continue;
                }
                throw new IllegalArgumentException("Error, parameter mismatch. Please check your remoting method signature to ensure all supported parameters types are used.");
            }
        }
        if ((this.configuration.isSynchronizeOnSession() || methodInfo.isSynchronizeOnSession()) && (session = request.getSession(false)) != null) {
            Object mutex;
            Object object = mutex = WebUtils.getSessionMutex((HttpSession)session);
            synchronized (object) {
                return ExtDirectSpringUtil.invoke(this.context, directRequest.getAction(), methodInfo, parameters);
            }
        }
        return ExtDirectSpringUtil.invoke(this.context, directRequest.getAction(), methodInfo, parameters);
    }

    private Object convertValue(Object value, ParameterInfo methodParameter) {
        if (value != null) {
            if (methodParameter.getType().equals(value.getClass())) {
                return value;
            }
            if (this.conversionService.canConvert(TypeDescriptor.forObject((Object)value), methodParameter.getTypeDescriptor())) {
                return this.conversionService.convert(value, TypeDescriptor.forObject((Object)value), methodParameter.getTypeDescriptor());
            }
            return this.jsonHandler.convertValue(value, methodParameter.getType());
        }
        return value;
    }

    private Object handleRequestParam(HttpServletRequest request, Map<String, Object> valueContainer, ParameterInfo parameterInfo) {
        if (parameterInfo.getName() != null) {
            Object value = request != null ? request.getParameter(parameterInfo.getName()) : (valueContainer != null ? valueContainer.get(parameterInfo.getName()) : null);
            if (value == null) {
                value = parameterInfo.getDefaultValue();
            }
            if (value != null) {
                return this.convertValue(value, parameterInfo);
            }
            if (parameterInfo.isRequired()) {
                throw new IllegalStateException("Missing parameter '" + parameterInfo.getName() + "' of type [" + parameterInfo.getTypeDescriptor().getType() + "]");
            }
        }
        return null;
    }

    private Object handleRequestHeader(HttpServletRequest request, ParameterInfo parameterInfo) {
        String value = request.getHeader(parameterInfo.getName());
        if (value == null) {
            value = parameterInfo.getDefaultValue();
        }
        if (value != null) {
            return this.convertValue(value, parameterInfo);
        }
        if (parameterInfo.isRequired()) {
            throw new IllegalStateException("Missing header '" + parameterInfo.getName() + "' of type [" + parameterInfo.getTypeDescriptor().getType() + "]");
        }
        return null;
    }

    private Map<String, Object> fillReadRequestFromMap(ExtDirectStoreReadRequest to, Map<String, Object> from) {
        HashSet<String> foundParameters = new HashSet<String>();
        for (Map.Entry<String, Object> entry : from.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (key.equals("filter")) {
                ArrayList<Filter> filters = new ArrayList<Filter>();
                if (value instanceof String) {
                    List<Map<String, Object>> rawFilters = this.jsonHandler.readValue((String)value, new TypeReference<List<Map<String, Object>>>(){});
                    for (Map map : rawFilters) {
                        filters.add(Filter.createFilter(map, this.conversionService));
                    }
                } else if (value instanceof List) {
                    List filterList = (List)value;
                    for (Map map : filterList) {
                        filters.add(Filter.createFilter(map, this.conversionService));
                    }
                }
                to.setFilters(filters);
                foundParameters.add(key);
                continue;
            }
            if (key.equals("sort") && value != null && value instanceof List) {
                ArrayList<SortInfo> sorters = new ArrayList<SortInfo>();
                List rawSorters = (List)value;
                for (Map map : rawSorters) {
                    sorters.add(SortInfo.create(map));
                }
                to.setSorters(sorters);
                foundParameters.add(key);
                continue;
            }
            if (key.equals("group") && value != null && value instanceof List) {
                ArrayList<GroupInfo> groups = new ArrayList<GroupInfo>();
                List rawGroups = (List)value;
                for (Map map : rawGroups) {
                    groups.add(GroupInfo.create(map));
                }
                to.setGroups(groups);
                foundParameters.add(key);
                continue;
            }
            PropertyDescriptor descriptor = BeanUtils.getPropertyDescriptor(to.getClass(), (String)key);
            if (descriptor == null || descriptor.getWriteMethod() == null) continue;
            try {
                descriptor.getWriteMethod().invoke((Object)to, this.conversionService.convert(value, descriptor.getPropertyType()));
                foundParameters.add(key);
            }
            catch (IllegalArgumentException e) {
                log.error((Object)"fillObjectFromMap", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error((Object)"fillObjectFromMap", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                log.error((Object)"fillObjectFromMap", (Throwable)e);
            }
        }
        if (to.getLimit() != null) {
            if (to.getPage() != null && to.getStart() == null) {
                to.setStart(to.getLimit() * (to.getPage() - 1));
            } else if (to.getPage() == null && to.getStart() != null) {
                to.setPage(to.getStart() / to.getLimit() + 1);
            }
        }
        if (to.getSort() != null && to.getDir() != null) {
            ArrayList<SortInfo> sorters = new ArrayList<SortInfo>();
            sorters.add(new SortInfo(to.getSort(), SortDirection.fromString(to.getDir())));
            to.setSorters(sorters);
        }
        if (to.getGroupBy() != null && to.getGroupDir() != null) {
            ArrayList<GroupInfo> groups = new ArrayList<GroupInfo>();
            groups.add(new GroupInfo(to.getGroupBy(), SortDirection.fromString(to.getGroupDir())));
            to.setGroups(groups);
        }
        HashMap<String, Object> remainingParameters = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : from.entrySet()) {
            if (foundParameters.contains(entry.getKey())) continue;
            remainingParameters.put(entry.getKey(), entry.getValue());
        }
        to.setParams(remainingParameters);
        return remainingParameters;
    }

    private List<Object> convertObjectEntriesToType(List<Object> records, Class<?> directStoreType) {
        if (records != null) {
            ArrayList<Object> convertedList = new ArrayList<Object>();
            for (Object record : records) {
                Object convertedObject = this.jsonHandler.convertValue(record, directStoreType);
                convertedList.add(convertedObject);
            }
            return convertedList;
        }
        return null;
    }

    private void handleException(BaseResponse response, Exception e) {
        Throwable cause = e.getCause() != null ? e.getCause() : e;
        response.setType("exception");
        response.setMessage(this.configuration.getMessage(cause));
        if (this.configuration.isSendStacktrace()) {
            response.setWhere(ExtDirectSpringUtil.getStackTrace(cause));
        } else {
            response.setWhere(null);
        }
    }

    private void handleMethodNotFoundError(BaseResponse response, String beanName, String methodName) {
        response.setType("exception");
        response.setMessage(this.configuration.getDefaultExceptionMessage());
        if (this.configuration.isSendStacktrace()) {
            response.setWhere("Bean or Method '" + beanName + "." + methodName + "' not found");
        } else {
            response.setWhere(null);
        }
    }
}

