/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.util;

import ch.ralscha.extdirectspring.annotation.ExtDirectMethod;
import ch.ralscha.extdirectspring.annotation.ExtDirectMethodType;
import ch.ralscha.extdirectspring.bean.api.Action;
import ch.ralscha.extdirectspring.bean.api.PollingProvider;
import ch.ralscha.extdirectspring.util.ParameterInfo;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MethodInfo {
    private String group;
    private final ExtDirectMethodType type;
    private boolean synchronizeOnSession;
    private boolean streamResponse;
    private List<ParameterInfo> parameters;
    private Method method;
    private String forwardPath;
    private Class<?> collectionType;
    private Action action;
    private PollingProvider pollingProvider;

    public MethodInfo(Class<?> clazz, String beanName, Method method) {
        ExtDirectMethod extDirectMethodAnnotation = (ExtDirectMethod)AnnotationUtils.findAnnotation((Method)method, ExtDirectMethod.class);
        this.type = extDirectMethodAnnotation.value();
        this.group = StringUtils.hasText((String)extDirectMethodAnnotation.group()) ? extDirectMethodAnnotation.group().trim() : null;
        if (this.type != ExtDirectMethodType.FORM_POST) {
            this.method = method;
            this.synchronizeOnSession = extDirectMethodAnnotation.synchronizeOnSession();
            this.streamResponse = extDirectMethodAnnotation.streamResponse();
            this.parameters = MethodInfo.buildParameterList(method);
            Class<?> clazz2 = this.collectionType = extDirectMethodAnnotation.entryClass() == Object.class ? null : extDirectMethodAnnotation.entryClass();
            if (this.collectionType == null) {
                for (ParameterInfo parameter : this.parameters) {
                    if (parameter.getCollectionType() == null) continue;
                    this.collectionType = parameter.getCollectionType();
                    break;
                }
            }
        } else {
            RequestMapping methodAnnotation = (RequestMapping)AnnotationUtils.findAnnotation((Method)method, RequestMapping.class);
            if (methodAnnotation != null) {
                RequestMapping classAnnotation = (RequestMapping)AnnotationUtils.findAnnotation(clazz, RequestMapping.class);
                String path = null;
                if (this.hasValue(classAnnotation)) {
                    path = classAnnotation.value()[0];
                }
                if (this.hasValue(methodAnnotation)) {
                    String methodPath = methodAnnotation.value()[0];
                    path = path != null ? path + methodPath : methodPath;
                }
                if (path != null) {
                    if (path.charAt(0) == '/' && path.length() > 1) {
                        path = path.substring(1, path.length());
                    }
                    this.forwardPath = "forward:" + path;
                }
            }
        }
        switch (this.type) {
            case SIMPLE: {
                int paramLength = 0;
                for (ParameterInfo parameter : this.parameters) {
                    if (parameter.isSupportedParameter() || parameter.isHasRequestHeaderAnnotation()) continue;
                    ++paramLength;
                }
                this.action = new Action(method.getName(), paramLength, null);
                break;
            }
            case SIMPLE_NAMED: {
                ArrayList<String> parameterNames = new ArrayList<String>();
                for (ParameterInfo parameter : this.parameters) {
                    if (parameter.isSupportedParameter() || parameter.isHasRequestHeaderAnnotation()) continue;
                    parameterNames.add(parameter.getName());
                }
                this.action = new Action(method.getName(), parameterNames);
                break;
            }
            case FORM_LOAD: 
            case STORE_READ: 
            case STORE_MODIFY: 
            case TREE_LOAD: {
                this.action = new Action(method.getName(), 1, null);
                break;
            }
            case FORM_POST: {
                this.action = new Action(method.getName(), 0, true);
                break;
            }
            case POLL: {
                this.pollingProvider = new PollingProvider(beanName, method.getName(), extDirectMethodAnnotation.event());
            }
        }
    }

    private boolean hasValue(RequestMapping requestMapping) {
        return requestMapping != null && requestMapping.value() != null && requestMapping.value().length > 0 && StringUtils.hasText((String)requestMapping.value()[0]);
    }

    private static List<ParameterInfo> buildParameterList(Method method) {
        ArrayList<ParameterInfo> params = new ArrayList<ParameterInfo>();
        Class<?>[] parameterTypes = method.getParameterTypes();
        Method methodWithAnnotation = MethodInfo.findMethodWithAnnotation(method, ExtDirectMethod.class);
        if (methodWithAnnotation == null) {
            methodWithAnnotation = method;
        }
        for (int paramIndex = 0; paramIndex < parameterTypes.length; ++paramIndex) {
            params.add(new ParameterInfo(methodWithAnnotation, paramIndex));
        }
        return params;
    }

    public Method getMethod() {
        return this.method;
    }

    public String getForwardPath() {
        return this.forwardPath;
    }

    public List<ParameterInfo> getParameters() {
        return this.parameters;
    }

    public Class<?> getCollectionType() {
        return this.collectionType;
    }

    public boolean isType(ExtDirectMethodType methodType) {
        return this.type == methodType;
    }

    public boolean isSynchronizeOnSession() {
        return this.synchronizeOnSession;
    }

    public boolean isStreamResponse() {
        return this.streamResponse;
    }

    public PollingProvider getPollingProvider() {
        return this.pollingProvider;
    }

    public Action getAction() {
        return this.action;
    }

    public String getGroup() {
        return this.group;
    }

    public static Method findMethodWithAnnotation(Method method, Class<? extends Annotation> annotation) {
        if (method.isAnnotationPresent(annotation)) {
            return method;
        }
        for (Class<?> cl = method.getDeclaringClass(); cl != null && cl != Object.class; cl = cl.getSuperclass()) {
            try {
                Method equivalentMethod = cl.getDeclaredMethod(method.getName(), method.getParameterTypes());
                if (!equivalentMethod.isAnnotationPresent(annotation)) continue;
                return equivalentMethod;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return null;
    }
}

