/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.controller;

import ch.ralscha.extdirectspring.annotation.ExtDirectMethodType;
import ch.ralscha.extdirectspring.bean.BaseResponse;
import ch.ralscha.extdirectspring.bean.ExtDirectFormLoadResult;
import ch.ralscha.extdirectspring.bean.ExtDirectPollResponse;
import ch.ralscha.extdirectspring.bean.ExtDirectRequest;
import ch.ralscha.extdirectspring.bean.ExtDirectResponse;
import ch.ralscha.extdirectspring.bean.ExtDirectStoreResponse;
import ch.ralscha.extdirectspring.controller.Configuration;
import ch.ralscha.extdirectspring.util.ExtDirectSpringUtil;
import ch.ralscha.extdirectspring.util.JsonHandler;
import ch.ralscha.extdirectspring.util.MethodInfo;
import ch.ralscha.extdirectspring.util.MethodInfoCache;
import ch.ralscha.extdirectspring.util.ParameterInfo;
import ch.ralscha.extdirectspring.util.ParametersResolver;
import ch.ralscha.extdirectspring.util.SupportedParameters;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.util.WebUtils;

@Controller
public class RouterController
implements InitializingBean {
    public static final MediaType APPLICATION_JSON = new MediaType("application", "json", Charset.forName("UTF-8"));
    public static final MediaType TEXT_HTML = new MediaType("text", "html", Charset.forName("UTF-8"));
    private static final Log log = LogFactory.getLog(RouterController.class);
    @Autowired
    private ApplicationContext context;
    @Autowired(required=false)
    private JsonHandler jsonHandler;
    @Autowired(required=false)
    private Configuration configuration;
    @Autowired
    private ParametersResolver parametersResolver;

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public JsonHandler getJsonHandler() {
        return this.jsonHandler;
    }

    public void afterPropertiesSet() {
        if (this.configuration == null) {
            this.configuration = new Configuration();
        }
        if (this.jsonHandler == null) {
            this.jsonHandler = new JsonHandler();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/poll/{beanName}/{method}/{event}"})
    public void poll(@PathVariable(value="beanName") String beanName, @PathVariable(value="method") String method, @PathVariable(value="event") String event, HttpServletRequest request, HttpServletResponse response, Locale locale) throws Exception {
        boolean streamResponse;
        ExtDirectPollResponse directPollResponse;
        block11: {
            directPollResponse = new ExtDirectPollResponse();
            directPollResponse.setName(event);
            MethodInfo methodInfo = MethodInfoCache.INSTANCE.get(beanName, method);
            if (methodInfo != null) {
                streamResponse = this.configuration.isStreamResponse() || methodInfo.isStreamResponse();
                try {
                    List<ParameterInfo> methodParameters = methodInfo.getParameters();
                    Object[] parameters = null;
                    if (!methodParameters.isEmpty()) {
                        parameters = new Object[methodParameters.size()];
                        for (int paramIndex = 0; paramIndex < methodParameters.size(); ++paramIndex) {
                            ParameterInfo methodParameter = methodParameters.get(paramIndex);
                            parameters[paramIndex] = methodParameter.isSupportedParameter() ? SupportedParameters.resolveParameter(methodParameter.getType(), request, response, locale) : (methodParameter.isHasRequestHeaderAnnotation() ? this.parametersResolver.resolveRequestHeader(request, methodParameter) : this.parametersResolver.resolveRequestParam(request, null, methodParameter));
                        }
                    }
                    if (this.configuration.isSynchronizeOnSession() || methodInfo.isSynchronizeOnSession()) {
                        HttpSession session = request.getSession(false);
                        if (session != null) {
                            Object mutex;
                            Object object = mutex = WebUtils.getSessionMutex((HttpSession)session);
                            synchronized (object) {
                                directPollResponse.setData(ExtDirectSpringUtil.invoke(this.context, beanName, methodInfo, parameters));
                                break block11;
                            }
                        }
                        directPollResponse.setData(ExtDirectSpringUtil.invoke(this.context, beanName, methodInfo, parameters));
                        break block11;
                    }
                    directPollResponse.setData(ExtDirectSpringUtil.invoke(this.context, beanName, methodInfo, parameters));
                }
                catch (Exception e) {
                    log.error((Object)("Error polling method '" + beanName + "." + method + "'"), e.getCause() != null ? e.getCause() : e);
                    this.handleException(directPollResponse, e);
                }
            } else {
                log.error((Object)("Error invoking method '" + beanName + "." + method + "'. Method or Bean not found"));
                this.handleMethodNotFoundError(directPollResponse, beanName, method);
                streamResponse = this.configuration.isStreamResponse();
            }
        }
        this.writeJsonResponse(response, directPollResponse, streamResponse);
    }

    @RequestMapping(value={"/router"}, method={RequestMethod.POST}, params={"extAction"})
    public String router(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="extAction") String extAction, @RequestParam(value="extMethod") String extMethod) throws IOException {
        MethodInfo methodInfo = MethodInfoCache.INSTANCE.get(extAction, extMethod);
        if (methodInfo != null && methodInfo.getForwardPath() != null) {
            return methodInfo.getForwardPath();
        }
        log.error((Object)("Error invoking method '" + extAction + "." + extMethod + "'. Method  or Bean not found"));
        ExtDirectResponse directResponse = new ExtDirectResponse(request);
        this.handleMethodNotFoundError(directResponse, extAction, extMethod);
        this.writeJsonResponse(response, directResponse, this.configuration.isStreamResponse());
        return null;
    }

    @RequestMapping(value={"/router"}, method={RequestMethod.POST}, params={"!extAction"})
    public void router(HttpServletRequest request, HttpServletResponse response, Locale locale) throws IOException {
        Object requestData = this.jsonHandler.readValue((InputStream)request.getInputStream(), Object.class);
        ArrayList<ExtDirectRequest> directRequests = new ArrayList<ExtDirectRequest>();
        if (requestData instanceof Map) {
            directRequests.add(this.jsonHandler.convertValue(requestData, ExtDirectRequest.class));
        } else if (requestData instanceof List) {
            for (Object oneRequest : (List)requestData) {
                directRequests.add(this.jsonHandler.convertValue(oneRequest, ExtDirectRequest.class));
            }
        }
        ArrayList<ExtDirectResponse> directResponses = new ArrayList<ExtDirectResponse>();
        boolean streamResponse = this.configuration.isStreamResponse();
        for (ExtDirectRequest directRequest : directRequests) {
            ExtDirectResponse directResponse = new ExtDirectResponse(directRequest);
            MethodInfo methodInfo = MethodInfoCache.INSTANCE.get(directRequest.getAction(), directRequest.getMethod());
            if (methodInfo != null) {
                try {
                    streamResponse = streamResponse || methodInfo.isStreamResponse();
                    ExtDirectStoreResponse<Object> result = this.processRemotingRequest(request, response, locale, directRequest, methodInfo);
                    if (result != null) {
                        if (methodInfo.isType(ExtDirectMethodType.FORM_LOAD) && !ExtDirectFormLoadResult.class.isAssignableFrom(result.getClass())) {
                            result = new ExtDirectFormLoadResult(result);
                        } else if (methodInfo.isType(ExtDirectMethodType.TREE_LOAD)) {
                            if (!(result instanceof Collection) && !result.getClass().isArray()) {
                                result = Arrays.asList(result);
                            }
                        } else if ((methodInfo.isType(ExtDirectMethodType.STORE_MODIFY) || methodInfo.isType(ExtDirectMethodType.STORE_READ)) && !ExtDirectStoreResponse.class.isAssignableFrom(result.getClass()) && this.configuration.isAlwaysWrapStoreResponse()) {
                            result = result instanceof Collection ? new ExtDirectStoreResponse((Collection)((Object)result)) : new ExtDirectStoreResponse<List<Object>>((List<Object>)((Object)result));
                        }
                        directResponse.setResult(result);
                    } else if (methodInfo.isType(ExtDirectMethodType.STORE_MODIFY) || methodInfo.isType(ExtDirectMethodType.STORE_READ)) {
                        directResponse.setResult(Collections.emptyList());
                    }
                }
                catch (Exception e) {
                    log.error((Object)("Error calling method: " + directRequest.getMethod()), e.getCause() != null ? e.getCause() : e);
                    this.handleException(directResponse, e);
                }
            } else {
                log.error((Object)("Error invoking method '" + directRequest.getAction() + "." + directRequest.getMethod() + "'. Method or Bean not found"));
                this.handleMethodNotFoundError(directResponse, directRequest.getAction(), directRequest.getMethod());
            }
            directResponses.add(directResponse);
        }
        this.writeJsonResponse(response, directResponses, streamResponse);
    }

    public void writeJsonResponse(HttpServletResponse response, Object responseObject, boolean streamResponse) throws IOException, JsonGenerationException, JsonMappingException {
        response.setContentType(APPLICATION_JSON.toString());
        response.setCharacterEncoding(APPLICATION_JSON.getCharSet().name());
        ObjectMapper objectMapper = this.jsonHandler.getMapper();
        ServletOutputStream outputStream = response.getOutputStream();
        if (!streamResponse) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
            JsonGenerator jsonGenerator = objectMapper.getJsonFactory().createJsonGenerator((OutputStream)bos, JsonEncoding.UTF8);
            objectMapper.writeValue(jsonGenerator, responseObject);
            response.setContentLength(bos.size());
            outputStream.write(bos.toByteArray());
        } else {
            JsonGenerator jsonGenerator = objectMapper.getJsonFactory().createJsonGenerator((OutputStream)outputStream, JsonEncoding.UTF8);
            objectMapper.writeValue(jsonGenerator, responseObject);
        }
        outputStream.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object processRemotingRequest(HttpServletRequest request, HttpServletResponse response, Locale locale, ExtDirectRequest directRequest, MethodInfo methodInfo) throws Exception {
        HttpSession session;
        Object[] parameters = this.parametersResolver.resolveParameters(request, response, locale, directRequest, methodInfo);
        if ((this.configuration.isSynchronizeOnSession() || methodInfo.isSynchronizeOnSession()) && (session = request.getSession(false)) != null) {
            Object mutex;
            Object object = mutex = WebUtils.getSessionMutex((HttpSession)session);
            synchronized (object) {
                return ExtDirectSpringUtil.invoke(this.context, directRequest.getAction(), methodInfo, parameters);
            }
        }
        return ExtDirectSpringUtil.invoke(this.context, directRequest.getAction(), methodInfo, parameters);
    }

    private void handleException(BaseResponse response, Exception e) {
        Throwable cause = e.getCause() != null ? e.getCause() : e;
        response.setType("exception");
        response.setMessage(this.configuration.getMessage(cause));
        if (this.configuration.isSendStacktrace()) {
            response.setWhere(ExtDirectSpringUtil.getStackTrace(cause));
        } else {
            response.setWhere(null);
        }
    }

    private void handleMethodNotFoundError(BaseResponse response, String beanName, String methodName) {
        response.setType("exception");
        response.setMessage(this.configuration.getDefaultExceptionMessage());
        if (this.configuration.isSendStacktrace()) {
            response.setWhere("Bean or Method '" + beanName + "." + methodName + "' not found");
        } else {
            response.setWhere(null);
        }
    }
}

