/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.util;

import ch.ralscha.extdirectspring.bean.ExtDirectRequest;
import ch.ralscha.extdirectspring.util.MethodInfo;
import ch.ralscha.extdirectspring.util.MethodInfoCache;
import ch.ralscha.extdirectspring.util.ParametersResolver;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.context.ApplicationContext;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExtDirectSpringUtil {
    private ExtDirectSpringUtil() {
    }

    public static boolean equal(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static Object invoke(ApplicationContext context, String beanName, MethodInfo methodInfo, Object[] params) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object bean = context.getBean(beanName);
        Method handlerMethod = methodInfo.getMethod();
        ReflectionUtils.makeAccessible((Method)handlerMethod);
        return handlerMethod.invoke(bean, params);
    }

    public static Object invoke(HttpServletRequest request, HttpServletResponse response, Locale locale, ApplicationContext context, ExtDirectRequest directRequest, ParametersResolver parametersResolver) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, Exception {
        MethodInfo methodInfo = MethodInfoCache.INSTANCE.get(directRequest.getAction(), directRequest.getMethod());
        Object[] resolvedParams = parametersResolver.resolveParameters(request, response, locale, directRequest, methodInfo);
        return ExtDirectSpringUtil.invoke(context, directRequest.getAction(), methodInfo, resolvedParams);
    }

    public static String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        t.printStackTrace(pw);
        pw.flush();
        sw.flush();
        return sw.toString();
    }

    public static Set<Method> selectMethods(Class<?> handlerType, final ReflectionUtils.MethodFilter handlerMethodFilter) {
        final LinkedHashSet<Method> handlerMethods = new LinkedHashSet<Method>();
        LinkedHashSet handlerTypes = new LinkedHashSet();
        Class specificHandlerType = null;
        if (!Proxy.isProxyClass(handlerType)) {
            handlerTypes.add(handlerType);
            specificHandlerType = handlerType;
        }
        for (Class<?> handlerTypeInterface : handlerType.getInterfaces()) {
            handlerTypes.add(handlerTypeInterface);
        }
        for (Class clazz : handlerTypes) {
            final Class targetClass = specificHandlerType != null ? specificHandlerType : clazz;
            ReflectionUtils.doWithMethods((Class)clazz, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

                public void doWith(Method method) {
                    Method specificMethod = ClassUtils.getMostSpecificMethod((Method)method, (Class)targetClass);
                    Method bridgedMethod = BridgeMethodResolver.findBridgedMethod((Method)specificMethod);
                    if (handlerMethodFilter.matches(specificMethod) && (bridgedMethod == specificMethod || !handlerMethodFilter.matches(bridgedMethod))) {
                        handlerMethods.add(specificMethod);
                    }
                }
            }, (ReflectionUtils.MethodFilter)ReflectionUtils.USER_DECLARED_METHODS);
        }
        return handlerMethods;
    }
}

