/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.util;

import java.io.InputStream;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonHandler {
    private ObjectMapper mapper = new ObjectMapper();

    public void setMapper(ObjectMapper mapper) {
        if (mapper == null) {
            throw new IllegalArgumentException("ObjectMapper must not be null");
        }
        this.mapper = mapper;
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public String writeValueAsString(Object obj) {
        return this.writeValueAsString(obj, false);
    }

    public String writeValueAsString(Object obj, boolean indent) {
        try {
            if (indent) {
                return this.mapper.writer().withDefaultPrettyPrinter().writeValueAsString(obj);
            }
            return this.mapper.writeValueAsString(obj);
        }
        catch (Exception e) {
            LogFactory.getLog(JsonHandler.class).info((Object)"serialize object to json", (Throwable)e);
            return null;
        }
    }

    public <T> T readValue(String json, TypeReference<T> typeReference) {
        try {
            return (T)this.mapper.readValue(json, typeReference);
        }
        catch (Exception e) {
            LogFactory.getLog(JsonHandler.class).info((Object)"deserialize json to object", (Throwable)e);
            return null;
        }
    }

    public <T> T readValue(String json, Class<T> clazz) {
        try {
            return (T)this.mapper.readValue(json, clazz);
        }
        catch (Exception e) {
            LogFactory.getLog(JsonHandler.class).info((Object)"deserialize json to object", (Throwable)e);
            return null;
        }
    }

    public Object readValue(InputStream is, Class<Object> clazz) {
        try {
            return this.mapper.readValue(is, clazz);
        }
        catch (Exception e) {
            LogFactory.getLog(JsonHandler.class).info((Object)"deserialize json to object", (Throwable)e);
            return null;
        }
    }

    public <T> T convertValue(Object object, Class<T> clazz) {
        return (T)this.mapper.convertValue(object, clazz);
    }
}

