/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.util;

import ch.ralscha.extdirectspring.annotation.ExtDirectMethodType;
import ch.ralscha.extdirectspring.bean.ExtDirectRequest;
import ch.ralscha.extdirectspring.bean.ExtDirectStoreReadRequest;
import ch.ralscha.extdirectspring.bean.GroupInfo;
import ch.ralscha.extdirectspring.bean.SortDirection;
import ch.ralscha.extdirectspring.bean.SortInfo;
import ch.ralscha.extdirectspring.filter.Filter;
import ch.ralscha.extdirectspring.util.JsonHandler;
import ch.ralscha.extdirectspring.util.MethodInfo;
import ch.ralscha.extdirectspring.util.ParameterInfo;
import ch.ralscha.extdirectspring.util.SupportedParameters;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.type.TypeReference;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
public final class ParametersResolver
implements InitializingBean {
    private static final Log log = LogFactory.getLog(ParametersResolver.class);
    @Autowired
    private ConversionService conversionService;
    @Autowired(required=false)
    private JsonHandler jsonHandler;

    public void afterPropertiesSet() throws Exception {
        if (this.jsonHandler == null) {
            this.jsonHandler = new JsonHandler();
        }
    }

    public Object[] resolveParameters(HttpServletRequest request, HttpServletResponse response, Locale locale, ExtDirectRequest directRequest, MethodInfo methodInfo) throws Exception {
        Object data;
        int jsonParamIndex = 0;
        Map<String, Object> remainingParameters = null;
        ExtDirectStoreReadRequest ExtDirectStoreReadRequest2 = null;
        List<Object> directStoreModifyRecords = null;
        if (methodInfo.isType(ExtDirectMethodType.STORE_READ) || methodInfo.isType(ExtDirectMethodType.FORM_LOAD) || methodInfo.isType(ExtDirectMethodType.TREE_LOAD)) {
            data = (List)directRequest.getData();
            if (data != null && data.size() > 0) {
                if (methodInfo.isType(ExtDirectMethodType.STORE_READ)) {
                    ExtDirectStoreReadRequest2 = new ExtDirectStoreReadRequest();
                    remainingParameters = this.fillReadRequestFromMap(ExtDirectStoreReadRequest2, (Map)data.get(0));
                } else {
                    remainingParameters = (Map<String, Object>)data.get(0);
                }
                jsonParamIndex = 1;
            }
        } else if (methodInfo.isType(ExtDirectMethodType.STORE_MODIFY)) {
            Object obj;
            Class<?> directStoreEntryClass = methodInfo.getCollectionType();
            data = (List)directRequest.getData();
            if (directStoreEntryClass != null && data != null && data.size() > 0) {
                obj = data.get(0);
                if (obj instanceof List) {
                    directStoreModifyRecords = this.convertObjectEntriesToType((List)obj, directStoreEntryClass);
                } else {
                    Map jsonData = (Map)obj;
                    Object records = jsonData.get("records");
                    if (records != null) {
                        if (records instanceof List) {
                            directStoreModifyRecords = this.convertObjectEntriesToType((List)records, directStoreEntryClass);
                        } else {
                            directStoreModifyRecords = new ArrayList<Object>();
                            directStoreModifyRecords.add(this.jsonHandler.convertValue(records, directStoreEntryClass));
                        }
                        remainingParameters = new HashMap<String, Object>(jsonData);
                        remainingParameters.remove("records");
                    } else {
                        directStoreModifyRecords = new ArrayList<Object>();
                        directStoreModifyRecords.add(this.jsonHandler.convertValue(jsonData, directStoreEntryClass));
                    }
                }
                jsonParamIndex = 1;
            } else if (data != null && data.size() > 0 && (obj = data.get(0)) instanceof Map) {
                remainingParameters = new HashMap<String, Object>((Map)obj);
                remainingParameters.remove("records");
            }
        } else if (methodInfo.isType(ExtDirectMethodType.SIMPLE_NAMED)) {
            data = (Map)directRequest.getData();
            if (data != null && data.size() > 0) {
                remainingParameters = new HashMap<String, Object>((Map<String, Object>)data);
            }
        } else {
            if (methodInfo.isType(ExtDirectMethodType.POLL)) {
                throw new IllegalStateException("this controller does not handle poll calls");
            }
            if (methodInfo.isType(ExtDirectMethodType.FORM_POST)) {
                throw new IllegalStateException("this controller does not handle form posts");
            }
        }
        List<ParameterInfo> methodParameters = methodInfo.getParameters();
        Object[] parameters = null;
        if (!methodParameters.isEmpty()) {
            parameters = new Object[methodParameters.size()];
            for (int paramIndex = 0; paramIndex < methodParameters.size(); ++paramIndex) {
                Object jsonValue;
                ParameterInfo methodParameter = methodParameters.get(paramIndex);
                if (methodParameter.isSupportedParameter()) {
                    parameters[paramIndex] = SupportedParameters.resolveParameter(methodParameter.getType(), request, response, locale);
                    continue;
                }
                if (ExtDirectStoreReadRequest.class.isAssignableFrom(methodParameter.getType())) {
                    parameters[paramIndex] = ExtDirectStoreReadRequest2;
                    continue;
                }
                if (directStoreModifyRecords != null && methodParameter.getCollectionType() != null) {
                    parameters[paramIndex] = directStoreModifyRecords;
                    continue;
                }
                if (methodParameter.isHasRequestParamAnnotation()) {
                    parameters[paramIndex] = this.resolveRequestParam(null, remainingParameters, methodParameter);
                    continue;
                }
                if (methodParameter.isHasRequestHeaderAnnotation()) {
                    parameters[paramIndex] = this.resolveRequestHeader(request, methodParameter);
                    continue;
                }
                if (remainingParameters != null && remainingParameters.containsKey(methodParameter.getName())) {
                    jsonValue = remainingParameters.get(methodParameter.getName());
                    parameters[paramIndex] = this.convertValue(jsonValue, methodParameter);
                    continue;
                }
                if (directRequest.getData() != null && directRequest.getData() instanceof List && ((List)directRequest.getData()).size() > jsonParamIndex) {
                    jsonValue = ((List)directRequest.getData()).get(jsonParamIndex);
                    parameters[paramIndex] = this.convertValue(jsonValue, methodParameter);
                    ++jsonParamIndex;
                    continue;
                }
                throw new IllegalArgumentException("Error, parameter mismatch. Please check your remoting method signature to ensure all supported parameters types are used.");
            }
        }
        return parameters;
    }

    public Object resolveRequestParam(HttpServletRequest request, Map<String, Object> valueContainer, ParameterInfo parameterInfo) {
        if (parameterInfo.getName() != null) {
            Object value = request != null ? request.getParameter(parameterInfo.getName()) : (valueContainer != null ? valueContainer.get(parameterInfo.getName()) : null);
            if (value == null) {
                value = parameterInfo.getDefaultValue();
            }
            if (value != null) {
                return this.convertValue(value, parameterInfo);
            }
            if (parameterInfo.isRequired()) {
                throw new IllegalStateException("Missing parameter '" + parameterInfo.getName() + "' of type [" + parameterInfo.getTypeDescriptor().getType() + "]");
            }
        }
        return null;
    }

    public Object resolveRequestHeader(HttpServletRequest request, ParameterInfo parameterInfo) {
        String value = request.getHeader(parameterInfo.getName());
        if (value == null) {
            value = parameterInfo.getDefaultValue();
        }
        if (value != null) {
            return this.convertValue(value, parameterInfo);
        }
        if (parameterInfo.isRequired()) {
            throw new IllegalStateException("Missing header '" + parameterInfo.getName() + "' of type [" + parameterInfo.getTypeDescriptor().getType() + "]");
        }
        return null;
    }

    private Object convertValue(Object value, ParameterInfo methodParameter) {
        if (value != null) {
            if (methodParameter.getType().equals(value.getClass())) {
                return value;
            }
            if (this.conversionService.canConvert(TypeDescriptor.forObject((Object)value), methodParameter.getTypeDescriptor())) {
                return this.conversionService.convert(value, TypeDescriptor.forObject((Object)value), methodParameter.getTypeDescriptor());
            }
            return this.jsonHandler.convertValue(value, methodParameter.getType());
        }
        return value;
    }

    private Map<String, Object> fillReadRequestFromMap(ExtDirectStoreReadRequest to, Map<String, Object> from) {
        HashSet<String> foundParameters = new HashSet<String>();
        for (Map.Entry<String, Object> entry : from.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (key.equals("filter")) {
                ArrayList<Filter> filters = new ArrayList<Filter>();
                if (value instanceof String) {
                    List<Map<String, Object>> rawFilters = this.jsonHandler.readValue((String)value, new TypeReference<List<Map<String, Object>>>(){});
                    for (Map map : rawFilters) {
                        filters.add(Filter.createFilter(map, this.conversionService));
                    }
                } else if (value instanceof List) {
                    List filterList = (List)value;
                    for (Map map : filterList) {
                        filters.add(Filter.createFilter(map, this.conversionService));
                    }
                }
                to.setFilters(filters);
                foundParameters.add(key);
                continue;
            }
            if (key.equals("sort") && value != null && value instanceof List) {
                ArrayList<SortInfo> sorters = new ArrayList<SortInfo>();
                List rawSorters = (List)value;
                for (Map map : rawSorters) {
                    sorters.add(SortInfo.create(map));
                }
                to.setSorters(sorters);
                foundParameters.add(key);
                continue;
            }
            if (key.equals("group") && value != null && value instanceof List) {
                ArrayList<GroupInfo> groups = new ArrayList<GroupInfo>();
                List rawGroups = (List)value;
                for (Map map : rawGroups) {
                    groups.add(GroupInfo.create(map));
                }
                to.setGroups(groups);
                foundParameters.add(key);
                continue;
            }
            PropertyDescriptor descriptor = BeanUtils.getPropertyDescriptor(to.getClass(), (String)key);
            if (descriptor == null || descriptor.getWriteMethod() == null) continue;
            try {
                descriptor.getWriteMethod().invoke((Object)to, this.conversionService.convert(value, descriptor.getPropertyType()));
                foundParameters.add(key);
            }
            catch (IllegalArgumentException e) {
                log.error((Object)"fillObjectFromMap", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error((Object)"fillObjectFromMap", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                log.error((Object)"fillObjectFromMap", (Throwable)e);
            }
        }
        if (to.getLimit() != null) {
            if (to.getPage() != null && to.getStart() == null) {
                to.setStart(to.getLimit() * (to.getPage() - 1));
            } else if (to.getPage() == null && to.getStart() != null) {
                to.setPage(to.getStart() / to.getLimit() + 1);
            }
        }
        if (to.getSort() != null && to.getDir() != null) {
            ArrayList<SortInfo> sorters = new ArrayList<SortInfo>();
            sorters.add(new SortInfo(to.getSort(), SortDirection.fromString(to.getDir())));
            to.setSorters(sorters);
        }
        if (to.getGroupBy() != null && to.getGroupDir() != null) {
            ArrayList<GroupInfo> groups = new ArrayList<GroupInfo>();
            groups.add(new GroupInfo(to.getGroupBy(), SortDirection.fromString(to.getGroupDir())));
            to.setGroups(groups);
        }
        HashMap<String, Object> remainingParameters = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : from.entrySet()) {
            if (foundParameters.contains(entry.getKey())) continue;
            remainingParameters.put(entry.getKey(), entry.getValue());
        }
        to.setParams(remainingParameters);
        return remainingParameters;
    }

    private List<Object> convertObjectEntriesToType(List<Object> records, Class<?> directStoreType) {
        if (records != null) {
            ArrayList<Object> convertedList = new ArrayList<Object>();
            for (Object record : records) {
                Object convertedObject = this.jsonHandler.convertValue(record, directStoreType);
                convertedList.add(convertedObject);
            }
            return convertedList;
        }
        return null;
    }
}

