/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.util;

import java.security.Principal;
import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SupportedParameters {
    SERVLET_REQUEST(ServletRequest.class),
    SERVLET_RESPONSE(ServletResponse.class),
    SESSION(HttpSession.class),
    LOCALE(Locale.class),
    PRINCIPAL(Principal.class);

    private final Class<?> clazz;

    private SupportedParameters(Class<?> clazz) {
        this.clazz = clazz;
    }

    public Class<?> getSupportedClass() {
        return this.clazz;
    }

    public static boolean isSupported(Class<?> clazz) {
        if (clazz != null) {
            for (SupportedParameters supportedParameter : SupportedParameters.values()) {
                if (!supportedParameter.clazz.isAssignableFrom(clazz)) continue;
                return true;
            }
        }
        return false;
    }

    public static Object resolveParameter(Class<?> parameterType, HttpServletRequest request, HttpServletResponse response, Locale locale) {
        if (SERVLET_REQUEST.getSupportedClass().isAssignableFrom(parameterType)) {
            return request;
        }
        if (SERVLET_RESPONSE.getSupportedClass().isAssignableFrom(parameterType)) {
            return response;
        }
        if (SESSION.getSupportedClass().isAssignableFrom(parameterType)) {
            return request.getSession();
        }
        if (PRINCIPAL.getSupportedClass().isAssignableFrom(parameterType)) {
            return request.getUserPrincipal();
        }
        if (LOCALE.getSupportedClass().equals(parameterType)) {
            return locale;
        }
        return null;
    }
}

